/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.any.TypeExtensionWizardBuilder;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.panels.SubmitableModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class TypeExtensionDirectoryPanel
extends DirectoryPanel<TypeExtensionTO, TypeExtensionTO, TypeExtensionDataProvider, BaseRestClient>
implements SubmitableModalPanel {
    private static final long serialVersionUID = -4117015319209624858L;
    private final BaseModal<Serializable> baseModal;
    private final GroupTO groupTO;

    protected TypeExtensionDirectoryPanel(BaseModal<Serializable> baseModal, GroupTO groupTO, PageReference pageRef) {
        super("content", pageRef, false);
        this.baseModal = baseModal;
        this.groupTO = groupTO;
        TypeExtensionWizardBuilder builder = new TypeExtensionWizardBuilder(groupTO, new TypeExtensionTO(), (String)new StringResourceModel("anyType", (Component)this).getObject(), (String)new StringResourceModel("auxClasses", (Component)this).getObject(), pageRef);
        this.addNewItemPanelBuilder(builder, true);
        this.setShowResultPanel(false);
        this.initResultTable();
    }

    public void onSubmit(AjaxRequestTarget target) {
        GroupUR req = new GroupUR();
        req.setKey(this.groupTO.getKey());
        req.getTypeExtensions().addAll(this.groupTO.getTypeExtensions());
        try {
            new GroupRestClient().update(this.groupTO.getETagValue(), req);
            this.baseModal.show(false);
            this.baseModal.close((IPartialPageRequestHandler)target);
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
        }
        catch (Exception e) {
            LOG.error("Group update failure", (Throwable)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    public void onError(AjaxRequestTarget target) {
        SyncopeConsoleSession.get().error((Serializable)((Object)this.getString("operation_error")));
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    @Override
    protected TypeExtensionDataProvider dataProvider() {
        return new TypeExtensionDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "typeextensions.paginator.rows";
    }

    @Override
    protected List<IColumn<TypeExtensionTO, String>> getColumns() {
        ArrayList<IColumn<TypeExtensionTO, String>> columns = new ArrayList<IColumn<TypeExtensionTO, String>>();
        columns.add((IColumn<TypeExtensionTO, String>)new PropertyColumn((IModel)Model.of((Serializable)((Object)"Any Type")), (Object)"anyType", "anyType"));
        columns.add((IColumn<TypeExtensionTO, String>)new PropertyColumn((IModel)new StringResourceModel("auxClasses", (Component)this), (Object)"auxClasses", "auxClasses"));
        return columns;
    }

    @Override
    public ActionsPanel<TypeExtensionTO> getActions(IModel<TypeExtensionTO> model) {
        ActionsPanel<TypeExtensionTO> panel = super.getActions(model);
        final TypeExtensionTO typeExtension = (TypeExtensionTO)model.getObject();
        panel.add(new ActionLink<TypeExtensionTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, TypeExtensionTO ignore) {
                TypeExtensionDirectoryPanel.this.send((IEventSink)TypeExtensionDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)typeExtension, target));
            }
        }, ActionLink.ActionType.EDIT, "");
        panel.add(new ActionLink<TypeExtensionTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, TypeExtensionTO ignore) {
                TypeExtensionDirectoryPanel.this.groupTO.getTypeExtension(typeExtension.getAnyType()).ifPresent(typeExt -> {
                    TypeExtensionDirectoryPanel.this.groupTO.getTypeExtensions().remove(typeExt);
                    target.add(new Component[]{TypeExtensionDirectoryPanel.this.container});
                });
            }
        }, ActionLink.ActionType.DELETE, "", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    @Override
    protected void customActionCallback(AjaxRequestTarget target) {
        this.send((IEventSink)this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
    }

    @Override
    protected void customActionOnCancelCallback(AjaxRequestTarget target) {
        this.send((IEventSink)this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
    }

    @Override
    protected void customActionOnFinishCallback(AjaxRequestTarget target) {
        this.send((IEventSink)this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
    }

    protected class TypeExtensionDataProvider
    extends DirectoryDataProvider<TypeExtensionTO> {
        private static final long serialVersionUID = 4533123471004692755L;

        public TypeExtensionDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("anyType", SortOrder.ASCENDING);
        }

        public Iterator<? extends TypeExtensionTO> iterator(long first, long count) {
            return TypeExtensionDirectoryPanel.this.groupTO.getTypeExtensions().subList((int)first, (int)(first + count)).iterator();
        }

        public long size() {
            return TypeExtensionDirectoryPanel.this.groupTO.getTypeExtensions().size();
        }

        public IModel<TypeExtensionTO> model(TypeExtensionTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

