/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.ApplicationModalPanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.PrivilegeDirectoryPanel;
import org.apache.syncope.client.console.rest.ApplicationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ApplicationTO;
import org.apache.syncope.common.lib.to.PrivilegeTO;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class ApplicationDirectoryPanel
extends DirectoryPanel<ApplicationTO, ApplicationTO, ApplicationDataProvider, ApplicationRestClient> {
    private static final long serialVersionUID = -5491515010207202168L;
    protected final BaseModal<PrivilegeTO> privilegeModal = new BaseModal<PrivilegeTO>("outer"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.setFooterVisible(false);
        }
    };

    protected ApplicationDirectoryPanel(String id, Builder builder) {
        super(id, builder);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"APPLICATION_CREATE");
        this.setReadOnly(!SyncopeConsoleSession.get().owns("APPLICATION_UPDATE", new String[0]));
        this.disableCheckBoxes();
        this.setShowResultPanel(true);
        this.modal.size(Modal.Size.Default);
        this.modal.addSubmitButton();
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.updateResultTable(target);
            this.modal.show(false);
        });
        this.setFooterVisibility(true);
        this.privilegeModal.size(Modal.Size.Large);
        this.privilegeModal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.updateResultTable(target);
            this.modal.show(false);
        });
        this.addOuterObject(new Component[]{this.privilegeModal});
        AjaxLink<Void> newApplLink = new AjaxLink<Void>("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                ApplicationDirectoryPanel.this.modal.header((IModel)new StringResourceModel("any.new"));
                ApplicationDirectoryPanel.this.modal.setContent((ModalPanel)new ApplicationModalPanel(new ApplicationTO(), true, ApplicationDirectoryPanel.this.modal, ApplicationDirectoryPanel.this.pageRef));
                ApplicationDirectoryPanel.this.modal.show(true);
                target.add(new Component[]{ApplicationDirectoryPanel.this.modal});
            }
        };
        ((MarkupContainer)this.get("container:content")).addOrReplace(new Component[]{newApplLink});
        MetaDataRoleAuthorizationStrategy.authorize((Component)newApplLink, (Action)RENDER, (String)"APPLICATION_CREATE");
        this.initResultTable();
    }

    @Override
    protected ApplicationDataProvider dataProvider() {
        return new ApplicationDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "application.paginator.rows";
    }

    @Override
    protected List<IColumn<ApplicationTO, String>> getColumns() {
        ArrayList<IColumn<ApplicationTO, String>> columns = new ArrayList<IColumn<ApplicationTO, String>>();
        columns.add((IColumn<ApplicationTO, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"key", "key"));
        columns.add((IColumn<ApplicationTO, String>)new PropertyColumn((IModel)new ResourceModel("description"), (Object)"description", "description"));
        columns.add((IColumn<ApplicationTO, String>)new AbstractColumn<ApplicationTO, String>((IModel)new ResourceModel("privileges")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<ApplicationTO>> item, String componentId, IModel<ApplicationTO> rowModel) {
                item.add(new Component[]{new Label(componentId, (Serializable)((Object)("[" + ((ApplicationTO)rowModel.getObject()).getPrivileges().stream().map(PrivilegeTO::getKey).collect(Collectors.joining(", ")) + "]")))});
            }
        });
        return columns;
    }

    @Override
    public ActionsPanel<ApplicationTO> getActions(final IModel<ApplicationTO> model) {
        ActionsPanel<ApplicationTO> panel = super.getActions(model);
        panel.add(new ActionLink<ApplicationTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, ApplicationTO ignore) {
                ApplicationDirectoryPanel.this.modal.header((IModel)new StringResourceModel("any.edit", model));
                ApplicationDirectoryPanel.this.modal.setContent((ModalPanel)new ApplicationModalPanel((ApplicationTO)model.getObject(), false, ApplicationDirectoryPanel.this.modal, ApplicationDirectoryPanel.this.pageRef));
                ApplicationDirectoryPanel.this.modal.show(true);
                target.add(new Component[]{ApplicationDirectoryPanel.this.modal});
            }
        }, ActionLink.ActionType.EDIT, "APPLICATION_UPDATE");
        panel.add(new ActionLink<ApplicationTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, ApplicationTO ignore) {
                target.add(new Component[]{ApplicationDirectoryPanel.this.privilegeModal.setContent(new PrivilegeDirectoryPanel(ApplicationDirectoryPanel.this.privilegeModal, (ApplicationTO)model.getObject(), ApplicationDirectoryPanel.this.pageRef))});
                ApplicationDirectoryPanel.this.privilegeModal.header((IModel)new StringResourceModel("application.privileges", (Component)ApplicationDirectoryPanel.this, (IModel)Model.of((Serializable)((ApplicationTO)model.getObject()))));
                MetaDataRoleAuthorizationStrategy.authorize(ApplicationDirectoryPanel.this.privilegeModal.getForm(), (Action)Component.ENABLE, (String)"APPLICATION_UPDATE");
                ApplicationDirectoryPanel.this.privilegeModal.show(true);
            }
        }, ActionLink.ActionType.COMPOSE, "APPLICATION_UPDATE");
        panel.add(new ActionLink<ApplicationTO>(){
            private static final long serialVersionUID = 3766262567901552032L;

            @Override
            public void onClick(AjaxRequestTarget target, ApplicationTO ignore) {
                try {
                    ApplicationRestClient.delete(((ApplicationTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)ApplicationDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ApplicationDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting application {}", (Object)((ApplicationTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)ApplicationDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "APPLICATION_DELETE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected static class ApplicationDataProvider
    extends DirectoryDataProvider<ApplicationTO> {
        private static final long serialVersionUID = 3124431855954382273L;
        private final SortableDataProviderComparator<ApplicationTO> comparator = new SortableDataProviderComparator(this);

        public ApplicationDataProvider(int paginatorRows) {
            super(paginatorRows);
        }

        public Iterator<ApplicationTO> iterator(long first, long count) {
            List<ApplicationTO> result = ApplicationRestClient.list();
            result.sort(this.comparator);
            return result.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ApplicationRestClient.list().size();
        }

        public IModel<ApplicationTO> model(ApplicationTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    public static abstract class Builder
    extends DirectoryPanel.Builder<ApplicationTO, ApplicationTO, ApplicationRestClient> {
        private static final long serialVersionUID = 5530948153889495221L;

        public Builder(PageReference pageRef) {
            super(new ApplicationRestClient(), pageRef);
        }

        @Override
        protected WizardMgtPanel<ApplicationTO> newInstance(String id, boolean wizardInModal) {
            return new ApplicationDirectoryPanel(id, this);
        }
    }
}

