/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.batch.BatchContent;
import org.apache.syncope.client.console.batch.BatchModal;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.AjaxFallbackDataTable;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.CheckGroupColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormChoiceComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.CheckGroupSelector;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public final class AjaxDataTablePanel<T extends Serializable, S>
extends DataTablePanel<T, S> {
    private static final long serialVersionUID = -7264400471578272966L;
    protected final BaseModal<T> batchModal = new BaseModal("batchModal");

    private AjaxDataTablePanel(String id, final Builder<T, S> builder) {
        super(id);
        this.batchModal.size(Modal.Size.Default);
        this.add(new Component[]{this.batchModal});
        this.batchModal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.batchModal.show(false);
            DirectoryPanel.EventDataWrapper data = new DirectoryPanel.EventDataWrapper();
            data.setTarget(target);
            data.setRows(builder.rowsPerPage);
            this.send((IEventSink)builder.pageRef.getPage(), Broadcast.BREADTH, data);
            Optional.ofNullable((BasePage)this.findPage()).ifPresent(page -> page.getNotificationPanel().refresh((IPartialPageRequestHandler)target));
        });
        Fragment fragment = new Fragment("tablePanel", "batchAvailable", (MarkupContainer)this);
        this.add(new Component[]{fragment});
        Form groupForm = new Form("groupForm");
        fragment.add(new Component[]{groupForm});
        this.group = new CheckGroup("checkgroup", this.model);
        this.group.add(new Behavior[]{new IndicatorAjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -151291731388673682L;

            protected void onUpdate(AjaxRequestTarget target) {
                AjaxDataTablePanel.this.group.visitChildren(CheckGroupSelector.class, (selector, ivisit) -> {
                    target.focusComponent(selector);
                    ivisit.stop();
                });
            }
        }});
        groupForm.add(new Component[]{this.group});
        if (builder.checkBoxEnabled) {
            builder.columns.add(0, new CheckGroupColumn(this.group));
        }
        this.dataTable = new AjaxFallbackDataTable<T, S>("dataTable", builder.columns, builder.dataProvider, builder.rowsPerPage, builder.container){
            private static final long serialVersionUID = -7370603907251344224L;

            @Override
            protected ActionsPanel<T> getActions(IModel<T> model) {
                return builder.getActions(model);
            }

            @Override
            protected ActionLinksTogglePanel<T> getTogglePanel() {
                return builder.getTogglePanel();
            }
        };
        this.dataTable.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"table table-bordered table-hover dataTable"))});
        this.group.add(new Component[]{this.dataTable});
        fragment.add(new Component[]{new IndicatingAjaxButton("batchLink", groupForm){
            private static final long serialVersionUID = 382302811235019988L;

            protected void onSubmit(AjaxRequestTarget target) {
                if (builder.getTogglePanel() != null) {
                    builder.getTogglePanel().close(target);
                }
                if (builder.multiLevelPanel == null) {
                    AjaxDataTablePanel.this.batchModal.header((IModel)new ResourceModel("batch"));
                    AjaxDataTablePanel.this.batchModal.changeCloseButtonLabel(this.getString("cancel", null, "Cancel"), target);
                    target.add(new Component[]{AjaxDataTablePanel.this.batchModal.setContent((ModalPanel)new BatchModal(AjaxDataTablePanel.this.batchModal, builder.pageRef, new ArrayList((Collection)AjaxDataTablePanel.this.group.getModelObject()), builder.columns.size() == 1 ? builder.columns : new ArrayList(builder.columns.subList(1, builder.columns.size())), builder.batches, builder.batchExecutor, builder.itemKeyField))});
                    AjaxDataTablePanel.this.batchModal.show(true);
                } else {
                    builder.multiLevelPanel.next(this.getString("batch"), new BatchContent(new ArrayList((Collection)AjaxDataTablePanel.this.group.getModelObject()), builder.columns.size() == 1 ? builder.columns : new ArrayList(builder.columns.subList(1, builder.columns.size())), builder.batches, builder.batchExecutor, builder.itemKeyField), target);
                }
                AjaxDataTablePanel.this.group.setModelObject(List.of());
                target.add(new Component[]{AjaxDataTablePanel.this.group});
            }
        }.setEnabled(builder.isBatchEnabled()).setVisible(builder.isBatchEnabled())});
    }

    public static class Builder<T extends Serializable, S>
    implements Serializable {
        private static final long serialVersionUID = 8876232177473972722L;
        private boolean checkBoxEnabled = true;
        private final List<IColumn<T, S>> columns = new ArrayList<IColumn<T, S>>();
        private final ISortableDataProvider<T, S> dataProvider;
        private int rowsPerPage = 10;
        private final Collection<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        private RestClient batchExecutor;
        private String itemKeyField;
        private final PageReference pageRef;
        private WebMarkupContainer container;
        private MultilevelPanel multiLevelPanel;

        public Builder(ISortableDataProvider<T, S> provider, PageReference pageRef) {
            this.dataProvider = provider;
            this.pageRef = pageRef;
        }

        public AjaxDataTablePanel<T, S> build(String id) {
            return new AjaxDataTablePanel(id, this);
        }

        public Builder<T, S> setContainer(WebMarkupContainer container) {
            this.container = container;
            return this;
        }

        public Builder<T, S> addBatch(ActionLink.ActionType actionType) {
            this.batches.add(actionType);
            return this;
        }

        public Builder<T, S> setBatchExecutor(BaseRestClient batchExecutor) {
            this.batchExecutor = batchExecutor;
            return this;
        }

        public Builder<T, S> setItemKeyField(String itemKeyField) {
            this.itemKeyField = itemKeyField;
            return this;
        }

        public Builder<T, S> setBatches(Collection<ActionLink.ActionType> batches, RestClient batchExecutor, String itemKeyField) {
            this.batches.clear();
            if (batches != null) {
                this.batches.addAll(batches);
            }
            this.batchExecutor = batchExecutor;
            this.itemKeyField = itemKeyField;
            return this;
        }

        public Builder<T, S> addColumn(IColumn<T, S> column) {
            this.columns.add(column);
            return this;
        }

        public Builder<T, S> setColumns(List<IColumn<T, S>> columns) {
            this.columns.clear();
            if (columns != null) {
                this.columns.addAll(columns);
            }
            return this;
        }

        public Builder<T, S> setRowsPerPage(int rowsPerPage) {
            this.rowsPerPage = rowsPerPage;
            return this;
        }

        public Builder<T, S> disableCheckBoxes() {
            this.checkBoxEnabled = false;
            return this;
        }

        private boolean isBatchEnabled() {
            return this.checkBoxEnabled && this.batchExecutor != null && !this.batches.isEmpty();
        }

        public void setMultiLevelPanel(MultilevelPanel multiLevelPanel) {
            this.multiLevelPanel = multiLevelPanel;
        }

        protected ActionsPanel<T> getActions(IModel<T> model) {
            return null;
        }

        protected ActionLinksTogglePanel<T> getTogglePanel() {
            return null;
        }
    }
}

