/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.surrogate;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.wa.ImpersonationAccount;
import org.apache.syncope.common.rest.api.service.wa.ImpersonationService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WASurrogateAuthenticationService
implements SurrogateAuthenticationService {
    private static final Logger LOG = LoggerFactory.getLogger(WASurrogateAuthenticationService.class);
    private final WARestClient waRestClient;

    public WASurrogateAuthenticationService(WARestClient waRestClient) {
        this.waRestClient = waRestClient;
    }

    public boolean canImpersonate(String surrogate, Principal principal, Optional<Service> service) {
        try {
            LOG.debug("Checking impersonation attempt by {} for {}", (Object)principal, (Object)surrogate);
            return this.getImpersonationService().read(principal.getId()).stream().anyMatch(acct -> surrogate.equals(acct.getImpersonated()));
        }
        catch (Exception e) {
            LOG.info("Could not authorize account {} for owner {}", (Object)surrogate, (Object)principal.getId());
            return false;
        }
    }

    public Collection<String> getImpersonationAccounts(String username) {
        return this.getImpersonationService().read(username).stream().map(ImpersonationAccount::getImpersonated).collect(Collectors.toList());
    }

    private ImpersonationService getImpersonationService() {
        if (!this.waRestClient.isReady()) {
            throw new IllegalStateException("Syncope core is not yet ready");
        }
        return (ImpersonationService)this.waRestClient.getSyncopeClient().getService(ImpersonationService.class);
    }
}

