/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.pac4j.saml;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.syncope.common.lib.to.SAML2SPEntityTO;
import org.apache.syncope.common.rest.api.service.SAML2SPEntityService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.starter.pac4j.saml.WASAML2MetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractBatchMetadataResolver;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class WASAML2ClientMetadataGenerator
extends BaseSAML2MetadataGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(WASAML2ClientMetadataGenerator.class);
    private final WARestClient restClient;
    private final SAML2Client saml2Client;

    WASAML2ClientMetadataGenerator(WARestClient restClient, SAML2Client saml2Client) {
        this.restClient = restClient;
        this.saml2Client = saml2Client;
    }

    protected AbstractBatchMetadataResolver createMetadataResolver(Resource metadataResource) {
        return new WASAML2MetadataResolver(this.restClient, this.saml2Client);
    }

    public MetadataResolver buildMetadataResolver(Resource metadataResource) throws Exception {
        SAML2SPEntityTO entityTO;
        String encodedMetadata = Base64.getEncoder().encodeToString(this.getMetadata(this.buildEntityDescriptor()).getBytes(StandardCharsets.UTF_8));
        try {
            entityTO = ((SAML2SPEntityService)this.restClient.getSyncopeClient().getService(SAML2SPEntityService.class)).get(this.saml2Client.getName());
            entityTO.setMetadata(encodedMetadata);
        }
        catch (Exception e) {
            LOG.debug("SP Entity {} not found, creating new", (Object)this.saml2Client.getName(), (Object)e);
            entityTO = (SAML2SPEntityTO)((SAML2SPEntityTO.Builder)new SAML2SPEntityTO.Builder().key(this.saml2Client.getName())).metadata(encodedMetadata).build();
        }
        LOG.debug("Storing SP Entity {}", (Object)entityTO);
        ((SAML2SPEntityService)this.restClient.getSyncopeClient().getService(SAML2SPEntityService.class)).set(entityTO);
        return super.buildMetadataResolver(metadataResource);
    }

    public boolean storeMetadata(String metadata, Resource resource, boolean force) throws Exception {
        return true;
    }
}

