/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.HashSet;
import java.util.Map;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyTO;
import org.apache.syncope.common.lib.policy.DefaultAttrReleasePolicyConf;
import org.apache.syncope.wa.starter.mapping.AttrReleaseMapFor;
import org.apache.syncope.wa.starter.mapping.AttrReleaseMapper;
import org.apereo.cas.authentication.principal.DefaultPrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.RegisteredServicePrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.cache.CachingPrincipalAttributesRepository;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceConsentPolicy;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.ReturnMappedAttributeReleasePolicy;
import org.apereo.cas.services.consent.DefaultRegisteredServiceConsentPolicy;
import org.apereo.cas.util.model.TriStateBoolean;

@AttrReleaseMapFor(attrReleasePolicyConfClass=DefaultAttrReleasePolicyConf.class)
public class DefaultAttrReleaseMapper
implements AttrReleaseMapper {
    @Override
    public RegisteredServiceAttributeReleasePolicy build(AttrReleasePolicyTO policy, Map<String, Object> releaseAttrs) {
        DefaultAttrReleasePolicyConf conf = (DefaultAttrReleasePolicyConf)policy.getConf();
        ReturnMappedAttributeReleasePolicy returnMapped = null;
        if (!releaseAttrs.isEmpty()) {
            returnMapped = new ReturnMappedAttributeReleasePolicy();
            returnMapped.setAllowedAttributes(releaseAttrs);
        }
        ReturnAllowedAttributeReleasePolicy returnAllowed = null;
        if (!conf.getAllowedAttrs().isEmpty()) {
            returnAllowed = new ReturnAllowedAttributeReleasePolicy();
        }
        Object attributeReleasePolicy = returnMapped == null && returnAllowed == null ? new DenyAllAttributeReleasePolicy() : (returnMapped != null ? returnMapped : returnAllowed);
        DefaultRegisteredServiceConsentPolicy consentPolicy = new DefaultRegisteredServiceConsentPolicy(new HashSet(conf.getExcludedAttrs()), new HashSet(conf.getIncludeOnlyAttrs()));
        consentPolicy.setOrder(policy.getOrder());
        consentPolicy.setStatus(policy.getStatus() == null ? TriStateBoolean.UNDEFINED : TriStateBoolean.fromBoolean((boolean)policy.getStatus()));
        attributeReleasePolicy.setConsentPolicy((RegisteredServiceConsentPolicy)consentPolicy);
        if (conf.getPrincipalIdAttr() != null) {
            attributeReleasePolicy.setPrincipalIdAttribute(conf.getPrincipalIdAttr());
        }
        if (conf.getPrincipalAttrRepoConf() != null && !conf.getPrincipalAttrRepoConf().getAttrRepos().isEmpty()) {
            DefaultAttrReleasePolicyConf.PrincipalAttrRepoConf parc = conf.getPrincipalAttrRepoConf();
            CachingPrincipalAttributesRepository par = parc.getExpiration() > 0L ? new CachingPrincipalAttributesRepository(parc.getTimeUnit().name(), parc.getExpiration()) : new DefaultPrincipalAttributesRepository();
            par.setMergingStrategy(PrincipalAttributesCoreProperties.MergingStrategyTypes.valueOf((String)parc.getMergingStrategy().name()));
            par.setIgnoreResolvedAttributes(par.isIgnoreResolvedAttributes());
            par.setAttributeRepositoryIds(new HashSet(parc.getAttrRepos()));
            attributeReleasePolicy.setPrincipalAttributesRepository((RegisteredServicePrincipalAttributesRepository)par);
        }
        if (returnMapped != null && returnAllowed != null) {
            ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{returnMapped, returnAllowed});
            return chain;
        }
        return attributeReleasePolicy;
    }
}

