/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.config;

import java.util.Optional;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.util.AsciiArtUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.refresh.ContextRefresher;

public class WARefreshContextJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(WARefreshContextJob.class);
    @Autowired
    private WARestClient waRestClient;
    @Autowired
    private ContextRefresher contextRefresher;
    @Autowired
    private SamlIdPMetadataGenerator metadataGenerator;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            LOG.debug("Attempting to refresh WA application context");
            if (!this.waRestClient.isReady()) {
                LOG.debug("Syncope client is not yet ready");
                throw new IllegalStateException("Syncope core is not yet ready to access requests");
            }
            this.contextRefresher.refresh();
            LOG.info("Refreshed application context to bootstrap property sources, etc...");
            LOG.info("Generating SAML2 IdP metadata metadata");
            SamlIdPMetadataDocument document = this.metadataGenerator.generate(Optional.empty());
            LOG.info("Generated SAML2 IdP metadata for {}", (Object)document.getAppliesTo());
            WARefreshContextJob.advertiseReady();
        }
        catch (Exception e) {
            throw new JobExecutionException("While generating SAML2 IdP metadata", (Throwable)e);
        }
    }

    private static void advertiseReady() {
        AsciiArtUtils.printAsciiArtReady((Logger)LOG, (String)"");
        LOG.info("Ready to process requests");
    }
}

