/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.util.ObjectUtils;
import org.springmodules.cache.CacheAttribute;
import org.springmodules.cache.annotations.Cacheable;
import org.springmodules.cache.interceptor.MetadataCacheAttributeSource;
import org.springmodules.cache.interceptor.caching.Cached;
import org.springmodules.cache.interceptor.caching.CachingAttributeSource;
import org.springmodules.cache.interceptor.caching.CachingUtils;

public class AnnotationCachingAttributeSource
implements CachingAttributeSource {
    private final MetadataCacheAttributeSource.MetadataFinder finder = new MetadataCacheAttributeSource.MetadataFinder(){

        public CacheAttribute find(Method m) {
            return this.find(m.getAnnotations());
        }

        private CacheAttribute attribute(Cacheable a) {
            return new Cached(a.modelId());
        }

        private CacheAttribute find(Annotation[] annotations) {
            if (ObjectUtils.isEmpty((Object[])annotations)) {
                return null;
            }
            for (Annotation a : annotations) {
                if (!(a instanceof Cacheable)) continue;
                return this.attribute((Cacheable)a);
            }
            return null;
        }
    };
    private final MetadataCacheAttributeSource source = new MetadataCacheAttributeSource(this.finder);

    public Cached attribute(Method m, Class t) {
        if (CachingUtils.isCacheable(m)) {
            return (Cached)this.source.attribute(m, t);
        }
        return null;
    }
}

