/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.apache.syncope.core.workflow.java.AbstractWorkflowAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
public abstract class AbstractUserWorkflowAdapter
extends AbstractWorkflowAdapter
implements UserWorkflowAdapter {
    protected static final Logger LOG = LoggerFactory.getLogger(UserWorkflowAdapter.class);
    protected final UserDataBinder dataBinder;
    protected final UserDAO userDAO;
    protected final EntityFactory entityFactory;

    public AbstractUserWorkflowAdapter(UserDataBinder dataBinder, UserDAO userDAO, EntityFactory entityFactory) {
        this.dataBinder = dataBinder;
        this.userDAO = userDAO;
        this.entityFactory = entityFactory;
    }

    public String getPrefix() {
        return null;
    }

    public UserWorkflowResult<Pair<String, Boolean>> create(UserCR userCR, String creator, String context) {
        return this.create(userCR, false, null, creator, context);
    }

    protected abstract UserWorkflowResult<Pair<String, Boolean>> doCreate(UserCR var1, boolean var2, Boolean var3, String var4, String var5);

    public UserWorkflowResult<Pair<String, Boolean>> create(UserCR userCR, boolean disablePwdPolicyCheck, Boolean enabled, String creator, String context) {
        return this.doCreate(userCR, disablePwdPolicyCheck, enabled, creator, context);
    }

    protected abstract UserWorkflowResult<String> doActivate(User var1, String var2, String var3, String var4);

    public UserWorkflowResult<String> activate(String key, String token, String updater, String context) {
        return this.doActivate((User)this.userDAO.authFind(key), token, updater, context);
    }

    protected abstract UserWorkflowResult<Pair<UserUR, Boolean>> doUpdate(User var1, UserUR var2, String var3, String var4);

    public UserWorkflowResult<Pair<UserUR, Boolean>> update(UserUR userUR, String updater, String context) {
        UserWorkflowResult<Pair<UserUR, Boolean>> result = this.doUpdate((User)this.userDAO.authFind(userUR.getKey()), userUR, updater, context);
        User user = (User)this.userDAO.find(userUR.getKey());
        if (!AuthContextUtils.getUsername().equals(user.getUsername())) {
            HashSet authRealms = new HashSet();
            authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault("USER_READ", Set.of()));
            authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault("USER_UPDATE", Set.of()));
            this.userDAO.securityChecks(authRealms, user.getKey(), user.getRealm().getFullPath(), this.userDAO.findAllGroupKeys(user));
        }
        return result;
    }

    protected abstract UserWorkflowResult<String> doSuspend(User var1, String var2, String var3);

    public UserWorkflowResult<String> suspend(String key, String updater, String context) {
        User user = (User)this.userDAO.authFind(key);
        user.setSuspended(Boolean.TRUE);
        return this.doSuspend(user, updater, context);
    }

    public Pair<UserWorkflowResult<String>, Boolean> internalSuspend(String key, String updater, String context) {
        User user = (User)this.userDAO.authFind(key);
        Pair result = null;
        Pair enforce = this.userDAO.enforcePolicies(user);
        if (((Boolean)enforce.getKey()).booleanValue()) {
            LOG.debug("User {} {} is over the max failed logins", (Object)user.getKey(), (Object)user.getUsername());
            user.setFailedLogins(Integer.valueOf(user.getFailedLogins() - 1));
            user.setSuspended(Boolean.TRUE);
            result = Pair.of(this.doSuspend(user, updater, context), (Object)((Boolean)enforce.getValue()));
        }
        return result;
    }

    protected abstract UserWorkflowResult<String> doReactivate(User var1, String var2, String var3);

    public UserWorkflowResult<String> reactivate(String key, String updater, String context) {
        User user = (User)this.userDAO.authFind(key);
        user.setFailedLogins(Integer.valueOf(0));
        user.setSuspended(Boolean.FALSE);
        return this.doReactivate(user, updater, context);
    }

    protected abstract void doRequestPasswordReset(User var1, String var2, String var3);

    public void requestPasswordReset(String key, String updater, String context) {
        this.doRequestPasswordReset((User)this.userDAO.authFind(key), updater, context);
    }

    protected abstract UserWorkflowResult<Pair<UserUR, Boolean>> doConfirmPasswordReset(User var1, String var2, String var3, String var4, String var5);

    public UserWorkflowResult<Pair<UserUR, Boolean>> confirmPasswordReset(String key, String token, String password, String updater, String context) {
        return this.doConfirmPasswordReset((User)this.userDAO.authFind(key), token, password, updater, context);
    }

    protected abstract void doDelete(User var1, String var2, String var3);

    public void delete(String userKey, String eraser, String context) {
        this.doDelete((User)this.userDAO.authFind(userKey), eraser, context);
    }
}

