/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.serialization;

import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.versioning.Version;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface SerializationHandle<T> {
    public <I> T deserialize(DeserializationAdapter<I> var1, I var2, Version var3) throws IOException;

    public <O> void serialize(SerializationAdapter<O> var1, O var2, T var3, Version var4) throws IOException;

    public int getTypeId();

    public Class<T> getSerializedType();

    public T fromJsonCompatibleSnapshot(Map<String, Object> var1, Version var2) throws IOException;

    public Map<String, Object> toJsonCompatibleSnapshot(T var1, Version var2) throws IOException;

    public String getTypeName();

    default public double[] readDoubleArray(Map<String, Object> snapshot, String fieldName) {
        Object object = snapshot.get(fieldName);
        if (object instanceof double[]) {
            return (double[])object;
        }
        if (object instanceof Number[]) {
            Number[] array = (Number[])object;
            double[] result = new double[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i].doubleValue();
            }
            return result;
        }
        List list = (List)object;
        double[] result = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = ((Number)list.get(i)).doubleValue();
        }
        return result;
    }

    default public long[] readLongArray(Map<String, Object> snapshot, String fieldName) {
        Object object = snapshot.get(fieldName);
        if (object instanceof long[]) {
            return (long[])object;
        }
        if (object instanceof Number[]) {
            Number[] array = (Number[])object;
            long[] result = new long[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i].longValue();
            }
            return result;
        }
        List list = (List)object;
        long[] result = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = ((Number)list.get(i)).longValue();
        }
        return result;
    }

    default public Long readLongValue(Map<String, Object> snapshot, String fieldName) {
        Object object = snapshot.get(fieldName);
        if (object instanceof Long) {
            return (Long)object;
        }
        Number number = (Number)object;
        return number.longValue();
    }

    default public Integer readIntegerValue(Map<String, Object> snapshot, String fieldName) {
        Object object = snapshot.get(fieldName);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        Number number = (Number)object;
        return number.intValue();
    }

    default public int readIntValue(Map<String, Object> snapshot, String fieldName) {
        Object object = snapshot.get(fieldName);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        Number number = (Number)object;
        return number.intValue();
    }
}

