/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.ui.commons.DateOps;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.common.lib.policy.AccessPolicyTO;
import org.apache.syncope.common.lib.policy.DefaultAccessPolicyConf;
import org.apache.syncope.common.lib.policy.HttpRequestAccessPolicyConf;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.policy.RemoteEndpointAccessPolicyConf;
import org.apache.syncope.common.lib.policy.TimeBasedAccessPolicyConf;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;

public class AccessPolicyModalPanel
extends AbstractModalPanel<AccessPolicyTO> {
    private static final long serialVersionUID = -6446551344059681908L;
    private final IModel<AccessPolicyTO> model;

    public AccessPolicyModalPanel(BaseModal<AccessPolicyTO> modal, IModel<AccessPolicyTO> model, PageReference pageRef) {
        super(modal, pageRef);
        this.model = model;
        ArrayList<Object> fields = new ArrayList<Object>();
        if (((AccessPolicyTO)model.getObject()).getConf() instanceof DefaultAccessPolicyConf) {
            fields.add(new AjaxSpinnerFieldPanel.Builder().build("field", "order", Integer.class, (IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "order")));
            fields.add(new AjaxCheckBoxPanel("field", "enabled", (IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "enabled"), false));
            fields.add(new AjaxCheckBoxPanel("field", "ssoEnabled", (IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "ssoEnabled"), false));
            fields.add(new AjaxCheckBoxPanel("field", "requireAllAttributes", (IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "requireAllAttributes"), false));
            fields.add(new AjaxCheckBoxPanel("field", "caseInsensitive", (IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "caseInsensitive"), false));
            AjaxTextFieldPanel unauthorizedRedirectUrl = new AjaxTextFieldPanel("field", "unauthorizedRedirectUrl", (IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "unauthorizedRedirectUrl"), false);
            unauthorizedRedirectUrl.getField().add((IValidator)new UrlValidator(new String[]{"http", "https"}));
            fields.add(unauthorizedRedirectUrl);
        } else if (((AccessPolicyTO)model.getObject()).getConf() instanceof HttpRequestAccessPolicyConf) {
            fields.add(new AjaxTextFieldPanel("field", "ipAddress", (IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "ipAddress"), false));
            fields.add(new AjaxTextFieldPanel("field", "userAgent", (IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "userAgent"), false));
        } else if (((AccessPolicyTO)model.getObject()).getConf() instanceof RemoteEndpointAccessPolicyConf) {
            AjaxTextFieldPanel endpointUrl = new AjaxTextFieldPanel("field", "endpointUrl", (IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "endpointUrl"), false);
            endpointUrl.getField().add((IValidator)new UrlValidator(new String[]{"http", "https"}));
            fields.add(endpointUrl.setRequired(true));
            AjaxTextFieldPanel panel = new AjaxTextFieldPanel("panel", "acceptableResponseCodes", (IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "acceptableResponseCodes"));
            fields.add(new MultiFieldPanel.Builder((IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "acceptableResponseCodes")).build("field", "acceptableResponseCodes", (FieldPanel)panel));
        } else if (((AccessPolicyTO)model.getObject()).getConf() instanceof TimeBasedAccessPolicyConf) {
            fields.add(new AjaxDateTimeFieldPanel("field", "start", (IModel)new DateOps.WrappedDateModel((IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "start")), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT));
            fields.add(new AjaxDateTimeFieldPanel("field", "end", (IModel)new DateOps.WrappedDateModel((IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "end")), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT));
            fields.add(new AjaxTextFieldPanel("field", "zoneId", (IModel)new PropertyModel((Object)((AccessPolicyTO)model.getObject()).getConf(), "zoneId"), false));
        }
        this.add(new Component[]{new ListView<Component>("fields", fields){
            private static final long serialVersionUID = -9180479401817023838L;

            protected void populateItem(ListItem<Component> item) {
                item.add(new Component[]{(Component)item.getModelObject()});
            }
        }});
    }

    public void onSubmit(AjaxRequestTarget target) {
        try {
            PolicyRestClient.update((PolicyType)PolicyType.ACCESS, (PolicyTO)((AccessPolicyTO)this.model.getObject()));
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While updating Access Policy {}", (Object)((AccessPolicyTO)this.model.getObject()).getKey(), (Object)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

