/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.annotations.AMPage;
import org.apache.syncope.client.console.authprofiles.AuthProfileDirectoryPanel;
import org.apache.syncope.client.console.clientapps.ClientApps;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.panels.AMSessionPanel;
import org.apache.syncope.client.console.panels.AttrRepoDirectoryPanel;
import org.apache.syncope.client.console.panels.AuthModuleDirectoryPanel;
import org.apache.syncope.client.console.panels.OIDC;
import org.apache.syncope.client.console.panels.SAML2;
import org.apache.syncope.client.console.panels.WAConfigDirectoryPanel;
import org.apache.syncope.client.console.rest.WAConfigRestClient;
import org.apache.syncope.client.console.rest.WASessionRestClient;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AMPage(label="WA", icon="fas fa-id-card", listEntitlement="", priority=200)
public class WA
extends BasePage {
    private static final long serialVersionUID = 9200112197134882164L;
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    @SpringBean
    protected ServiceOps serviceOps;
    protected String waPrefix = "";

    public WA(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build((String)"dashboard", (String)"dashboardBr", Dashboard.class)});
        this.body.setOutputMarkupId(true);
        List instances = this.serviceOps.list(NetworkService.Type.WA);
        AjaxLink<Object> push = new AjaxLink<Object>("push"){
            private static final long serialVersionUID = -817438685948164787L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    WAConfigRestClient.push();
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While pushing to WA", (Throwable)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)WA.this.getPageReference().getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        push.setEnabled(!instances.isEmpty() && SyncopeConsoleSession.get().owns("WA_CONFIG_PUSH", new String[0]));
        this.body.add(new Component[]{push});
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        AjaxBootstrapTabbedPanel tabbedPanel = new AjaxBootstrapTabbedPanel("tabbedPanel", this.buildTabList(instances));
        content.add(new Component[]{tabbedPanel});
        this.body.add(new Component[]{content});
        if (!instances.isEmpty()) {
            String actuatorEndpoint = ((NetworkService)instances.get(0)).getAddress() + "actuator/env";
            try {
                JsonNode env;
                Response response = WebClient.create((String)actuatorEndpoint, (String)SyncopeWebApplication.get().getAnonymousUser(), (String)SyncopeWebApplication.get().getAnonymousKey(), null).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
                if (response.getStatus() == Response.Status.OK.getStatusCode() && (env = MAPPER.readTree((InputStream)response.getEntity())).has("propertySources")) {
                    for (JsonNode propertySource : env.get("propertySources")) {
                        JsonNode prefix;
                        JsonNode properties;
                        if (!propertySource.has("properties") || !(properties = propertySource.get("properties")).has("cas.server.prefix") || !(prefix = properties.get("cas.server.prefix")).has("value")) continue;
                        this.waPrefix = StringUtils.removeEnd((String)prefix.get("value").asText(), (String)"/");
                    }
                }
            }
            catch (Exception e) {
                LOG.error("While contacting {}", (Object)actuatorEndpoint, (Object)e);
            }
            if (StringUtils.isBlank((CharSequence)this.waPrefix)) {
                this.waPrefix = StringUtils.removeEnd((String)((NetworkService)instances.get(0)).getAddress(), (String)"/");
            }
        }
    }

    protected List<ITab> buildTabList(final List<NetworkService> instances) {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        if (SyncopeConsoleSession.get().owns("AUTH_MODULE_LIST", new String[0])) {
            tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("authModules")){
                private static final long serialVersionUID = 5211692813425391144L;

                public Panel getPanel(String panelId) {
                    return new AuthModuleDirectoryPanel(panelId, WA.this.getPageReference());
                }
            });
        }
        if (SyncopeConsoleSession.get().owns("ATTR_REPO_LIST", new String[0])) {
            tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("attrRepos")){
                private static final long serialVersionUID = 5211692813425391144L;

                public Panel getPanel(String panelId) {
                    return new AttrRepoDirectoryPanel(panelId, WA.this.getPageReference());
                }
            });
        }
        if (SyncopeConsoleSession.get().owns("CLIENTAPP_LIST", new String[0])) {
            tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("clientApps")){
                private static final long serialVersionUID = 5211692813425391144L;

                public Panel getPanel(String panelId) {
                    return new ClientApps(panelId, WA.this.getPageReference());
                }
            });
        }
        tabs.add((ITab)new AbstractTab((IModel)Model.of((Serializable)((Object)"SAML 2.0"))){
            private static final long serialVersionUID = 5211692813425391144L;

            public Panel getPanel(String panelId) {
                return new SAML2(panelId, WA.this.waPrefix, WA.this.getPageReference());
            }
        });
        tabs.add((ITab)new AbstractTab((IModel)Model.of((Serializable)((Object)"OIDC 1.0"))){
            private static final long serialVersionUID = 5211692813425391144L;

            public Panel getPanel(String panelId) {
                return new OIDC(panelId, WA.this.waPrefix, WA.this.getPageReference());
            }
        });
        if (SyncopeConsoleSession.get().owns("WA_CONFIG_LIST", new String[0])) {
            tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("config")){
                private static final long serialVersionUID = 5211692813425391144L;

                public Panel getPanel(String panelId) {
                    return new WAConfigDirectoryPanel(panelId, WA.this.getPageReference());
                }
            });
        }
        if (SyncopeConsoleSession.get().owns("AUTH_PROFILE_LIST", new String[0])) {
            tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("authProfiles")){
                private static final long serialVersionUID = 5211692813425391144L;

                public Panel getPanel(String panelId) {
                    return new AuthProfileDirectoryPanel(panelId, WA.this.getPageReference());
                }
            });
        }
        if (!instances.isEmpty() && SyncopeConsoleSession.get().owns("WA_SESSION_LIST", new String[0])) {
            tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("sessions")){
                private static final long serialVersionUID = 5211692813425391144L;

                public Panel getPanel(String panelId) {
                    return new AMSessionPanel(panelId, new WASessionRestClient(instances), "WA_SESSION_LIST", "WA_SESSION_DELETE", WA.this.getPageReference());
                }
            });
        }
        return tabs;
    }
}

