/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.syncope.common.rest.api.service.ClientAppService;
import org.apache.syncope.core.logic.ClientAppLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.stereotype.Service;

@Service
public class ClientAppServiceImpl
extends AbstractService
implements ClientAppService {
    protected final ClientAppLogic logic;

    public ClientAppServiceImpl(ClientAppLogic logic) {
        this.logic = logic;
    }

    public Response create(ClientAppType type, ClientAppTO clientAppTO) {
        ClientAppTO created = this.logic.create(type, clientAppTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created.getKey()).build();
    }

    public <T extends ClientAppTO> List<T> list(ClientAppType type) {
        return this.logic.list(type);
    }

    public <T extends ClientAppTO> T read(ClientAppType type, String key) {
        return (T)this.logic.read(type, key);
    }

    public void update(ClientAppType type, ClientAppTO clientAppTO) {
        this.logic.update(type, clientAppTO);
    }

    public void delete(ClientAppType type, String key) {
        this.logic.delete(type, key);
    }

    public void pushToWA() {
        this.logic.pushToWA();
    }
}

