/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.spring.JAXRSServerFactoryBeanDefinitionParser;
import org.apache.cxf.jaxrs.validation.JAXRSBeanValidationInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.SCIMDataBinder;
import org.apache.syncope.core.logic.SCIMLogic;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.ext.scimv2.api.service.GroupService;
import org.apache.syncope.ext.scimv2.api.service.SCIMService;
import org.apache.syncope.ext.scimv2.api.service.UserService;
import org.apache.syncope.ext.scimv2.cxf.AddETagFilter;
import org.apache.syncope.ext.scimv2.cxf.SCIMExceptionMapper;
import org.apache.syncope.ext.scimv2.cxf.service.GroupServiceImpl;
import org.apache.syncope.ext.scimv2.cxf.service.SCIMServiceImpl;
import org.apache.syncope.ext.scimv2.cxf.service.UserServiceImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class SCIMv2RESTCXFContext {
    @ConditionalOnMissingBean
    @Bean
    public JacksonJsonProvider scimJacksonJsonProvider() {
        return new JacksonJsonProvider(((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build());
    }

    @ConditionalOnMissingBean
    @Bean
    public SCIMExceptionMapper scimExceptionMapper() {
        return new SCIMExceptionMapper();
    }

    @ConditionalOnMissingBean(name={"scimAddETagFilter"})
    @Bean
    public AddETagFilter scimAddETagFilter() {
        return new AddETagFilter();
    }

    @ConditionalOnMissingBean(name={"scimv2Container"})
    @Bean
    public Server scimv2Container(ApplicationContext ctx, Bus bus, JacksonJsonProvider scimJacksonJsonProvider, SCIMExceptionMapper scimExceptionMapper, AddETagFilter scimAddETagFilter) {
        JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean scimv2Container = new JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean();
        scimv2Container.setBus(bus);
        scimv2Container.setAddress("/scim");
        scimv2Container.setStaticSubresourceResolution(true);
        scimv2Container.setBasePackages(List.of("org.apache.syncope.ext.scimv2.api.service", "org.apache.syncope.ext.scimv2.cxf.service"));
        scimv2Container.setProperties(Map.of("convert.wadl.resources.to.dom", "false"));
        scimv2Container.setInInterceptors(List.of((Interceptor)ctx.getBean(GZIPInInterceptor.class), (Interceptor)ctx.getBean(JAXRSBeanValidationInInterceptor.class)));
        scimv2Container.setOutInterceptors(List.of((Interceptor)ctx.getBean(GZIPOutInterceptor.class)));
        scimv2Container.setProviders(List.of(scimJacksonJsonProvider, scimExceptionMapper, scimAddETagFilter));
        scimv2Container.setApplicationContext(ctx);
        return scimv2Container.create();
    }

    @ConditionalOnMissingBean
    @Bean
    public SCIMService scimService(UserDAO userDAO, GroupDAO groupDAO, UserLogic userLogic, GroupLogic groupLogic, SCIMDataBinder binder, SCIMConfManager confManager, SCIMLogic scimLogic) {
        return new SCIMServiceImpl(userDAO, groupDAO, userLogic, groupLogic, binder, confManager, scimLogic);
    }

    @ConditionalOnMissingBean
    @Bean
    public GroupService scimv2GroupService(UserDAO userDAO, GroupDAO groupDAO, UserLogic userLogic, GroupLogic groupLogic, SCIMDataBinder binder, SCIMConfManager confManager) {
        return new GroupServiceImpl(userDAO, groupDAO, userLogic, groupLogic, binder, confManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public UserService scimv2UserService(UserDAO userDAO, GroupDAO groupDAO, UserLogic userLogic, GroupLogic groupLogic, SCIMDataBinder binder, SCIMConfManager confManager) {
        return new UserServiceImpl(userDAO, groupDAO, userLogic, groupLogic, binder, confManager);
    }
}

