/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.OdnoklassnikiApi;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.ok.OkConfiguration;
import org.pac4j.oauth.profile.ok.OkProfileDefinition;

public final class OkClient
extends OAuth20Client {
    public OkClient() {
        this.configuration = new OkConfiguration();
    }

    public OkClient(String key, String secret, String publicKey) {
        this.configuration = new OkConfiguration();
        this.setKey(key);
        this.setSecret(secret);
        this.setPublicKey(publicKey);
    }

    @Override
    public OkConfiguration getConfiguration() {
        return (OkConfiguration)this.configuration;
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"publicKey", (String)this.getConfiguration().getPublicKey());
        this.configuration.setApi(OdnoklassnikiApi.instance());
        this.configuration.setProfileDefinition(new OkProfileDefinition());
        super.internalInit(forceReinit);
    }

    public String getPublicKey() {
        return this.getConfiguration().getPublicKey();
    }

    public void setPublicKey(String publicKey) {
        this.getConfiguration().setPublicKey(publicKey);
    }
}

