/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.audit.BaseAuditableExecution;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.inspektr.audit.annotation.Audit;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;

public class AccessTokenGrantAuditableRequestExtractor
extends BaseAuditableExecution {
    private final Collection<AccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;

    @Audit(action="OAUTH2_ACCESS_TOKEN_REQUEST", actionResolverName="OAUTH2_ACCESS_TOKEN_REQUEST_ACTION_RESOLVER", resourceResolverName="OAUTH2_ACCESS_TOKEN_REQUEST_RESOURCE_RESOLVER")
    public AuditableExecutionResult execute(AuditableContext auditableContext) {
        HttpServletRequest request = (HttpServletRequest)auditableContext.getRequest().orElseThrow();
        HttpServletResponse response = (HttpServletResponse)auditableContext.getResponse().orElseThrow();
        JEEContext context = new JEEContext(request, response);
        AccessTokenRequestContext result = this.accessTokenGrantRequestExtractors.stream().filter(ext -> ext.supports((WebContext)context)).findFirst().orElseThrow(() -> new UnsupportedOperationException("Access token request is not supported")).extract((WebContext)context);
        return AuditableExecutionResult.builder().authentication(result.getAuthentication()).service(result.getService()).registeredService((RegisteredService)result.getRegisteredService()).executionResult((Object)result).build();
    }

    @Generated
    public AccessTokenGrantAuditableRequestExtractor(Collection<AccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors) {
        this.accessTokenGrantRequestExtractors = accessTokenGrantRequestExtractors;
    }
}

