/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.resultset;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.ibatis.annotations.AutomapConstructor;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.cursor.defaults.DefaultCursor;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.loader.ResultLoader;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.executor.result.DefaultResultHandler;
import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetWrapper;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.util.MapUtil;

public class DefaultResultSetHandler
implements ResultSetHandler {
    private static final Object DEFERRED = new Object();
    private final Executor executor;
    private final Configuration configuration;
    private final MappedStatement mappedStatement;
    private final RowBounds rowBounds;
    private final ParameterHandler parameterHandler;
    private final ResultHandler<?> resultHandler;
    private final BoundSql boundSql;
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final ObjectFactory objectFactory;
    private final ReflectorFactory reflectorFactory;
    private final Map<CacheKey, Object> nestedResultObjects = new HashMap<CacheKey, Object>();
    private final Map<String, Object> ancestorObjects = new HashMap<String, Object>();
    private Object previousRowValue;
    private final Map<String, ResultMapping> nextResultMaps = new HashMap<String, ResultMapping>();
    private final Map<CacheKey, List<PendingRelation>> pendingRelations = new HashMap<CacheKey, List<PendingRelation>>();
    private final Map<String, List<UnMappedColumnAutoMapping>> autoMappingsCache = new HashMap<String, List<UnMappedColumnAutoMapping>>();
    private final Map<String, List<String>> constructorAutoMappingColumns = new HashMap<String, List<String>>();
    private boolean useConstructorMappings;

    public DefaultResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler<?> resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        this.executor = executor;
        this.configuration = mappedStatement.getConfiguration();
        this.mappedStatement = mappedStatement;
        this.rowBounds = rowBounds;
        this.parameterHandler = parameterHandler;
        this.boundSql = boundSql;
        this.typeHandlerRegistry = this.configuration.getTypeHandlerRegistry();
        this.objectFactory = this.configuration.getObjectFactory();
        this.reflectorFactory = this.configuration.getReflectorFactory();
        this.resultHandler = resultHandler;
    }

    @Override
    public void handleOutputParameters(CallableStatement cs) throws SQLException {
        Object parameterObject = this.parameterHandler.getParameterObject();
        MetaObject metaParam = this.configuration.newMetaObject(parameterObject);
        List<ParameterMapping> parameterMappings = this.boundSql.getParameterMappings();
        for (int i = 0; i < parameterMappings.size(); ++i) {
            ParameterMapping parameterMapping = parameterMappings.get(i);
            if (parameterMapping.getMode() != ParameterMode.OUT && parameterMapping.getMode() != ParameterMode.INOUT) continue;
            if (ResultSet.class.equals(parameterMapping.getJavaType())) {
                this.handleRefCursorOutputParameter((ResultSet)cs.getObject(i + 1), parameterMapping, metaParam);
                continue;
            }
            TypeHandler<?> typeHandler = parameterMapping.getTypeHandler();
            metaParam.setValue(parameterMapping.getProperty(), typeHandler.getResult(cs, i + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRefCursorOutputParameter(ResultSet rs, ParameterMapping parameterMapping, MetaObject metaParam) throws SQLException {
        if (rs == null) {
            return;
        }
        try {
            String resultMapId = parameterMapping.getResultMapId();
            ResultMap resultMap = this.configuration.getResultMap(resultMapId);
            ResultSetWrapper rsw = new ResultSetWrapper(rs, this.configuration);
            if (this.resultHandler == null) {
                DefaultResultHandler resultHandler = new DefaultResultHandler(this.objectFactory);
                this.handleRowValues(rsw, resultMap, resultHandler, new RowBounds(), null);
                metaParam.setValue(parameterMapping.getProperty(), resultHandler.getResultList());
            } else {
                this.handleRowValues(rsw, resultMap, this.resultHandler, new RowBounds(), null);
            }
        }
        finally {
            this.closeResultSet(rs);
        }
    }

    public List<Object> handleResultSets(Statement stmt) throws SQLException {
        int resultSetCount;
        ErrorContext.instance().activity("handling results").object(this.mappedStatement.getId());
        ArrayList<Object> multipleResults = new ArrayList<Object>();
        ResultSetWrapper rsw = this.getFirstResultSet(stmt);
        List<ResultMap> resultMaps = this.mappedStatement.getResultMaps();
        int resultMapCount = resultMaps.size();
        this.validateResultMapsCount(rsw, resultMapCount);
        for (resultSetCount = 0; rsw != null && resultMapCount > resultSetCount; ++resultSetCount) {
            ResultMap resultMap = resultMaps.get(resultSetCount);
            this.handleResultSet(rsw, resultMap, multipleResults, null);
            rsw = this.getNextResultSet(stmt);
            this.cleanUpAfterHandlingResultSet();
        }
        String[] resultSets = this.mappedStatement.getResultSets();
        if (resultSets != null) {
            while (rsw != null && resultSetCount < resultSets.length) {
                ResultMapping parentMapping = this.nextResultMaps.get(resultSets[resultSetCount]);
                if (parentMapping != null) {
                    String nestedResultMapId = parentMapping.getNestedResultMapId();
                    ResultMap resultMap = this.configuration.getResultMap(nestedResultMapId);
                    this.handleResultSet(rsw, resultMap, null, parentMapping);
                }
                rsw = this.getNextResultSet(stmt);
                this.cleanUpAfterHandlingResultSet();
                ++resultSetCount;
            }
        }
        return this.collapseSingleResultList(multipleResults);
    }

    @Override
    public <E> Cursor<E> handleCursorResultSets(Statement stmt) throws SQLException {
        ErrorContext.instance().activity("handling cursor results").object(this.mappedStatement.getId());
        ResultSetWrapper rsw = this.getFirstResultSet(stmt);
        List<ResultMap> resultMaps = this.mappedStatement.getResultMaps();
        int resultMapCount = resultMaps.size();
        this.validateResultMapsCount(rsw, resultMapCount);
        if (resultMapCount != 1) {
            throw new ExecutorException("Cursor results cannot be mapped to multiple resultMaps");
        }
        ResultMap resultMap = resultMaps.get(0);
        return new DefaultCursor(this, resultMap, rsw, this.rowBounds);
    }

    private ResultSetWrapper getFirstResultSet(Statement stmt) throws SQLException {
        ResultSet rs = stmt.getResultSet();
        while (rs == null) {
            if (stmt.getMoreResults()) {
                rs = stmt.getResultSet();
                continue;
            }
            if (stmt.getUpdateCount() != -1) continue;
        }
        return rs != null ? new ResultSetWrapper(rs, this.configuration) : null;
    }

    private ResultSetWrapper getNextResultSet(Statement stmt) {
        try {
            if (stmt.getConnection().getMetaData().supportsMultipleResultSets() && (stmt.getMoreResults() || stmt.getUpdateCount() != -1)) {
                ResultSet rs = stmt.getResultSet();
                if (rs == null) {
                    return this.getNextResultSet(stmt);
                }
                return new ResultSetWrapper(rs, this.configuration);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void cleanUpAfterHandlingResultSet() {
        this.nestedResultObjects.clear();
    }

    private void validateResultMapsCount(ResultSetWrapper rsw, int resultMapCount) {
        if (rsw != null && resultMapCount < 1) {
            throw new ExecutorException("A query was run and no Result Maps were found for the Mapped Statement '" + this.mappedStatement.getId() + "'.  It's likely that neither a Result Type nor a Result Map was specified.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResultSet(ResultSetWrapper rsw, ResultMap resultMap, List<Object> multipleResults, ResultMapping parentMapping) throws SQLException {
        try {
            if (parentMapping != null) {
                this.handleRowValues(rsw, resultMap, null, RowBounds.DEFAULT, parentMapping);
            } else if (this.resultHandler == null) {
                DefaultResultHandler defaultResultHandler = new DefaultResultHandler(this.objectFactory);
                this.handleRowValues(rsw, resultMap, defaultResultHandler, this.rowBounds, null);
                multipleResults.add(defaultResultHandler.getResultList());
            } else {
                this.handleRowValues(rsw, resultMap, this.resultHandler, this.rowBounds, null);
            }
        }
        finally {
            this.closeResultSet(rsw.getResultSet());
        }
    }

    private List<Object> collapseSingleResultList(List<Object> multipleResults) {
        return multipleResults.size() == 1 ? (List)multipleResults.get(0) : multipleResults;
    }

    public void handleRowValues(ResultSetWrapper rsw, ResultMap resultMap, ResultHandler<?> resultHandler, RowBounds rowBounds, ResultMapping parentMapping) throws SQLException {
        if (resultMap.hasNestedResultMaps()) {
            this.ensureNoRowBounds();
            this.checkResultHandler();
            this.handleRowValuesForNestedResultMap(rsw, resultMap, resultHandler, rowBounds, parentMapping);
        } else {
            this.handleRowValuesForSimpleResultMap(rsw, resultMap, resultHandler, rowBounds, parentMapping);
        }
    }

    private void ensureNoRowBounds() {
        if (this.configuration.isSafeRowBoundsEnabled() && this.rowBounds != null && (this.rowBounds.getLimit() < Integer.MAX_VALUE || this.rowBounds.getOffset() > 0)) {
            throw new ExecutorException("Mapped Statements with nested result mappings cannot be safely constrained by RowBounds. Use safeRowBoundsEnabled=false setting to bypass this check.");
        }
    }

    protected void checkResultHandler() {
        if (this.resultHandler != null && this.configuration.isSafeResultHandlerEnabled() && !this.mappedStatement.isResultOrdered()) {
            throw new ExecutorException("Mapped Statements with nested result mappings cannot be safely used with a custom ResultHandler. Use safeResultHandlerEnabled=false setting to bypass this check or ensure your statement returns ordered data and set resultOrdered=true on it.");
        }
    }

    private void handleRowValuesForSimpleResultMap(ResultSetWrapper rsw, ResultMap resultMap, ResultHandler<?> resultHandler, RowBounds rowBounds, ResultMapping parentMapping) throws SQLException {
        DefaultResultContext<Object> resultContext = new DefaultResultContext<Object>();
        ResultSet resultSet = rsw.getResultSet();
        this.skipRows(resultSet, rowBounds);
        while (this.shouldProcessMoreRows(resultContext, rowBounds) && !resultSet.isClosed() && resultSet.next()) {
            ResultMap discriminatedResultMap = this.resolveDiscriminatedResultMap(resultSet, resultMap, null);
            Object rowValue = this.getRowValue(rsw, discriminatedResultMap, null);
            this.storeObject(resultHandler, resultContext, rowValue, parentMapping, resultSet);
        }
    }

    private void storeObject(ResultHandler<?> resultHandler, DefaultResultContext<Object> resultContext, Object rowValue, ResultMapping parentMapping, ResultSet rs) throws SQLException {
        if (parentMapping != null) {
            this.linkToParents(rs, parentMapping, rowValue);
        } else {
            this.callResultHandler(resultHandler, resultContext, rowValue);
        }
    }

    private void callResultHandler(ResultHandler<?> resultHandler, DefaultResultContext<Object> resultContext, Object rowValue) {
        resultContext.nextResultObject(rowValue);
        resultHandler.handleResult(resultContext);
    }

    private boolean shouldProcessMoreRows(ResultContext<?> context, RowBounds rowBounds) {
        return !context.isStopped() && context.getResultCount() < rowBounds.getLimit();
    }

    private void skipRows(ResultSet rs, RowBounds rowBounds) throws SQLException {
        if (rs.getType() != 1003) {
            if (rowBounds.getOffset() != 0) {
                rs.absolute(rowBounds.getOffset());
            }
        } else {
            for (int i = 0; i < rowBounds.getOffset() && rs.next(); ++i) {
            }
        }
    }

    private Object getRowValue(ResultSetWrapper rsw, ResultMap resultMap, String columnPrefix) throws SQLException {
        ResultLoaderMap lazyLoader = new ResultLoaderMap();
        Object rowValue = this.createResultObject(rsw, resultMap, lazyLoader, columnPrefix);
        if (rowValue != null && !this.hasTypeHandlerForResultObject(rsw, resultMap.getType())) {
            MetaObject metaObject = this.configuration.newMetaObject(rowValue);
            boolean foundValues = this.useConstructorMappings;
            if (this.shouldApplyAutomaticMappings(resultMap, false)) {
                foundValues = this.applyAutomaticMappings(rsw, resultMap, metaObject, columnPrefix) || foundValues;
            }
            foundValues = this.applyPropertyMappings(rsw, resultMap, metaObject, lazyLoader, columnPrefix) || foundValues;
            foundValues = lazyLoader.size() > 0 || foundValues;
            rowValue = foundValues || this.configuration.isReturnInstanceForEmptyRow() ? rowValue : null;
        }
        return rowValue;
    }

    private Object getRowValue(ResultSetWrapper rsw, ResultMap resultMap, CacheKey combinedKey, String columnPrefix, Object partialObject) throws SQLException {
        String resultMapId = resultMap.getId();
        Object rowValue = partialObject;
        if (rowValue != null) {
            MetaObject metaObject = this.configuration.newMetaObject(rowValue);
            this.putAncestor(rowValue, resultMapId);
            this.applyNestedResultMappings(rsw, resultMap, metaObject, columnPrefix, combinedKey, false);
            this.ancestorObjects.remove(resultMapId);
        } else {
            ResultLoaderMap lazyLoader = new ResultLoaderMap();
            rowValue = this.createResultObject(rsw, resultMap, lazyLoader, columnPrefix);
            if (rowValue != null && !this.hasTypeHandlerForResultObject(rsw, resultMap.getType())) {
                MetaObject metaObject = this.configuration.newMetaObject(rowValue);
                boolean foundValues = this.useConstructorMappings;
                if (this.shouldApplyAutomaticMappings(resultMap, true)) {
                    foundValues = this.applyAutomaticMappings(rsw, resultMap, metaObject, columnPrefix) || foundValues;
                }
                foundValues = this.applyPropertyMappings(rsw, resultMap, metaObject, lazyLoader, columnPrefix) || foundValues;
                this.putAncestor(rowValue, resultMapId);
                foundValues = this.applyNestedResultMappings(rsw, resultMap, metaObject, columnPrefix, combinedKey, true) || foundValues;
                this.ancestorObjects.remove(resultMapId);
                foundValues = lazyLoader.size() > 0 || foundValues;
                Object object = rowValue = foundValues || this.configuration.isReturnInstanceForEmptyRow() ? rowValue : null;
            }
            if (combinedKey != CacheKey.NULL_CACHE_KEY) {
                this.nestedResultObjects.put(combinedKey, rowValue);
            }
        }
        return rowValue;
    }

    private void putAncestor(Object resultObject, String resultMapId) {
        this.ancestorObjects.put(resultMapId, resultObject);
    }

    private boolean shouldApplyAutomaticMappings(ResultMap resultMap, boolean isNested) {
        if (resultMap.getAutoMapping() != null) {
            return resultMap.getAutoMapping();
        }
        if (isNested) {
            return AutoMappingBehavior.FULL == this.configuration.getAutoMappingBehavior();
        }
        return AutoMappingBehavior.NONE != this.configuration.getAutoMappingBehavior();
    }

    private boolean applyPropertyMappings(ResultSetWrapper rsw, ResultMap resultMap, MetaObject metaObject, ResultLoaderMap lazyLoader, String columnPrefix) throws SQLException {
        List<String> mappedColumnNames = rsw.getMappedColumnNames(resultMap, columnPrefix);
        boolean foundValues = false;
        List<ResultMapping> propertyMappings = resultMap.getPropertyResultMappings();
        for (ResultMapping propertyMapping : propertyMappings) {
            String column = this.prependPrefix(propertyMapping.getColumn(), columnPrefix);
            if (propertyMapping.getNestedResultMapId() != null) {
                column = null;
            }
            if (!propertyMapping.isCompositeResult() && (column == null || !mappedColumnNames.contains(column.toUpperCase(Locale.ENGLISH))) && propertyMapping.getResultSet() == null) continue;
            Object value = this.getPropertyMappingValue(rsw.getResultSet(), metaObject, propertyMapping, lazyLoader, columnPrefix);
            String property = propertyMapping.getProperty();
            if (property == null) continue;
            if (value == DEFERRED) {
                foundValues = true;
                continue;
            }
            if (value != null) {
                foundValues = true;
            }
            if (value == null && (!this.configuration.isCallSettersOnNulls() || metaObject.getSetterType(property).isPrimitive())) continue;
            metaObject.setValue(property, value);
        }
        return foundValues;
    }

    private Object getPropertyMappingValue(ResultSet rs, MetaObject metaResultObject, ResultMapping propertyMapping, ResultLoaderMap lazyLoader, String columnPrefix) throws SQLException {
        if (propertyMapping.getNestedQueryId() != null) {
            return this.getNestedQueryMappingValue(rs, metaResultObject, propertyMapping, lazyLoader, columnPrefix);
        }
        if (propertyMapping.getResultSet() != null) {
            this.addPendingChildRelation(rs, metaResultObject, propertyMapping);
            return DEFERRED;
        }
        TypeHandler<?> typeHandler = propertyMapping.getTypeHandler();
        String column = this.prependPrefix(propertyMapping.getColumn(), columnPrefix);
        return typeHandler.getResult(rs, column);
    }

    private List<UnMappedColumnAutoMapping> createAutomaticMappings(ResultSetWrapper rsw, ResultMap resultMap, MetaObject metaObject, String columnPrefix) throws SQLException {
        String mapKey = resultMap.getId() + ":" + columnPrefix;
        List<UnMappedColumnAutoMapping> autoMapping = this.autoMappingsCache.get(mapKey);
        if (autoMapping == null) {
            autoMapping = new ArrayList<UnMappedColumnAutoMapping>();
            List<String> unmappedColumnNames = rsw.getUnmappedColumnNames(resultMap, columnPrefix);
            List<String> mappedInConstructorAutoMapping = this.constructorAutoMappingColumns.remove(mapKey);
            if (mappedInConstructorAutoMapping != null) {
                unmappedColumnNames.removeAll(mappedInConstructorAutoMapping);
            }
            Iterator<String> iterator = unmappedColumnNames.iterator();
            while (iterator.hasNext()) {
                String property;
                String columnName;
                String propertyName = columnName = iterator.next();
                if (columnPrefix != null && !columnPrefix.isEmpty()) {
                    if (!columnName.toUpperCase(Locale.ENGLISH).startsWith(columnPrefix)) continue;
                    propertyName = columnName.substring(columnPrefix.length());
                }
                if ((property = metaObject.findProperty(propertyName, this.configuration.isMapUnderscoreToCamelCase())) != null && metaObject.hasSetter(property)) {
                    if (resultMap.getMappedProperties().contains(property)) continue;
                    Class<?> propertyType = metaObject.getSetterType(property);
                    if (this.typeHandlerRegistry.hasTypeHandler(propertyType, rsw.getJdbcType(columnName))) {
                        TypeHandler<?> typeHandler = rsw.getTypeHandler(propertyType, columnName);
                        autoMapping.add(new UnMappedColumnAutoMapping(columnName, property, typeHandler, propertyType.isPrimitive()));
                        continue;
                    }
                    this.configuration.getAutoMappingUnknownColumnBehavior().doAction(this.mappedStatement, columnName, property, propertyType);
                    continue;
                }
                this.configuration.getAutoMappingUnknownColumnBehavior().doAction(this.mappedStatement, columnName, property != null ? property : propertyName, null);
            }
            this.autoMappingsCache.put(mapKey, autoMapping);
        }
        return autoMapping;
    }

    private boolean applyAutomaticMappings(ResultSetWrapper rsw, ResultMap resultMap, MetaObject metaObject, String columnPrefix) throws SQLException {
        List<UnMappedColumnAutoMapping> autoMapping = this.createAutomaticMappings(rsw, resultMap, metaObject, columnPrefix);
        boolean foundValues = false;
        if (!autoMapping.isEmpty()) {
            for (UnMappedColumnAutoMapping mapping : autoMapping) {
                Object value = mapping.typeHandler.getResult(rsw.getResultSet(), mapping.column);
                if (value != null) {
                    foundValues = true;
                }
                if (value == null && (!this.configuration.isCallSettersOnNulls() || mapping.primitive)) continue;
                metaObject.setValue(mapping.property, value);
            }
        }
        return foundValues;
    }

    private void linkToParents(ResultSet rs, ResultMapping parentMapping, Object rowValue) throws SQLException {
        CacheKey parentKey = this.createKeyForMultipleResults(rs, parentMapping, parentMapping.getColumn(), parentMapping.getForeignColumn());
        List<PendingRelation> parents = this.pendingRelations.get(parentKey);
        if (parents != null) {
            for (PendingRelation parent : parents) {
                if (parent == null || rowValue == null) continue;
                this.linkObjects(parent.metaObject, parent.propertyMapping, rowValue);
            }
        }
    }

    private void addPendingChildRelation(ResultSet rs, MetaObject metaResultObject, ResultMapping parentMapping) throws SQLException {
        CacheKey cacheKey = this.createKeyForMultipleResults(rs, parentMapping, parentMapping.getColumn(), parentMapping.getColumn());
        PendingRelation deferLoad = new PendingRelation();
        deferLoad.metaObject = metaResultObject;
        deferLoad.propertyMapping = parentMapping;
        List relations = MapUtil.computeIfAbsent(this.pendingRelations, cacheKey, k -> new ArrayList());
        relations.add(deferLoad);
        ResultMapping previous = this.nextResultMaps.get(parentMapping.getResultSet());
        if (previous == null) {
            this.nextResultMaps.put(parentMapping.getResultSet(), parentMapping);
        } else if (!previous.equals(parentMapping)) {
            throw new ExecutorException("Two different properties are mapped to the same resultSet");
        }
    }

    private CacheKey createKeyForMultipleResults(ResultSet rs, ResultMapping resultMapping, String names, String columns) throws SQLException {
        CacheKey cacheKey = new CacheKey();
        cacheKey.update(resultMapping);
        if (columns != null && names != null) {
            String[] columnsArray = columns.split(",");
            String[] namesArray = names.split(",");
            for (int i = 0; i < columnsArray.length; ++i) {
                String value = rs.getString(columnsArray[i]);
                if (value == null) continue;
                cacheKey.update(namesArray[i]);
                cacheKey.update(value);
            }
        }
        return cacheKey;
    }

    private Object createResultObject(ResultSetWrapper rsw, ResultMap resultMap, ResultLoaderMap lazyLoader, String columnPrefix) throws SQLException {
        this.useConstructorMappings = false;
        ArrayList constructorArgTypes = new ArrayList();
        ArrayList<Object> constructorArgs = new ArrayList<Object>();
        Object resultObject = this.createResultObject(rsw, resultMap, constructorArgTypes, constructorArgs, columnPrefix);
        if (resultObject != null && !this.hasTypeHandlerForResultObject(rsw, resultMap.getType())) {
            List<ResultMapping> propertyMappings = resultMap.getPropertyResultMappings();
            for (ResultMapping propertyMapping : propertyMappings) {
                if (propertyMapping.getNestedQueryId() == null || !propertyMapping.isLazy()) continue;
                resultObject = this.configuration.getProxyFactory().createProxy(resultObject, lazyLoader, this.configuration, this.objectFactory, constructorArgTypes, constructorArgs);
                break;
            }
        }
        this.useConstructorMappings = resultObject != null && !constructorArgTypes.isEmpty();
        return resultObject;
    }

    private Object createResultObject(ResultSetWrapper rsw, ResultMap resultMap, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, String columnPrefix) throws SQLException {
        Class<?> resultType = resultMap.getType();
        MetaClass metaType = MetaClass.forClass(resultType, this.reflectorFactory);
        List<ResultMapping> constructorMappings = resultMap.getConstructorResultMappings();
        if (this.hasTypeHandlerForResultObject(rsw, resultType)) {
            return this.createPrimitiveResultObject(rsw, resultMap, columnPrefix);
        }
        if (!constructorMappings.isEmpty()) {
            return this.createParameterizedResultObject(rsw, resultType, constructorMappings, constructorArgTypes, constructorArgs, columnPrefix);
        }
        if (resultType.isInterface() || metaType.hasDefaultConstructor()) {
            return this.objectFactory.create(resultType);
        }
        if (this.shouldApplyAutomaticMappings(resultMap, false)) {
            return this.createByConstructorSignature(rsw, resultMap, columnPrefix, resultType, constructorArgTypes, constructorArgs);
        }
        throw new ExecutorException("Do not know how to create an instance of " + resultType);
    }

    Object createParameterizedResultObject(ResultSetWrapper rsw, Class<?> resultType, List<ResultMapping> constructorMappings, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, String columnPrefix) {
        boolean foundValues = false;
        for (ResultMapping constructorMapping : constructorMappings) {
            Object value;
            Class<?> parameterType = constructorMapping.getJavaType();
            String column = constructorMapping.getColumn();
            try {
                if (constructorMapping.getNestedQueryId() != null) {
                    value = this.getNestedQueryConstructorValue(rsw.getResultSet(), constructorMapping, columnPrefix);
                } else if (constructorMapping.getNestedResultMapId() != null) {
                    ResultMap resultMap = this.configuration.getResultMap(constructorMapping.getNestedResultMapId());
                    value = this.getRowValue(rsw, resultMap, this.getColumnPrefix(columnPrefix, constructorMapping));
                } else {
                    TypeHandler<?> typeHandler = constructorMapping.getTypeHandler();
                    value = typeHandler.getResult(rsw.getResultSet(), this.prependPrefix(column, columnPrefix));
                }
            }
            catch (SQLException | ResultMapException e) {
                throw new ExecutorException("Could not process result for mapping: " + constructorMapping, e);
            }
            constructorArgTypes.add(parameterType);
            constructorArgs.add(value);
            foundValues = value != null || foundValues;
        }
        return foundValues ? this.objectFactory.create(resultType, constructorArgTypes, constructorArgs) : null;
    }

    private Object createByConstructorSignature(ResultSetWrapper rsw, ResultMap resultMap, String columnPrefix, Class<?> resultType, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) throws SQLException {
        return this.applyConstructorAutomapping(rsw, resultMap, columnPrefix, resultType, constructorArgTypes, constructorArgs, this.findConstructorForAutomapping(resultType, rsw).orElseThrow(() -> new ExecutorException("No constructor found in " + resultType.getName() + " matching " + rsw.getClassNames())));
    }

    private Optional<Constructor<?>> findConstructorForAutomapping(Class<?> resultType, ResultSetWrapper rsw) {
        Constructor<?>[] constructors = resultType.getDeclaredConstructors();
        if (constructors.length == 1) {
            return Optional.of(constructors[0]);
        }
        for (Constructor<?> constructor : constructors) {
            if (!constructor.isAnnotationPresent(AutomapConstructor.class)) continue;
            return Optional.of(constructor);
        }
        if (this.configuration.isArgNameBasedConstructorAutoMapping()) {
            throw new ExecutorException(MessageFormat.format("'argNameBasedConstructorAutoMapping' is enabled and the class ''{0}'' has multiple constructors, so @AutomapConstructor must be added to one of the constructors.", resultType.getName()));
        }
        return Arrays.stream(constructors).filter(x -> this.findUsableConstructorByArgTypes((Constructor<?>)x, rsw.getJdbcTypes())).findAny();
    }

    private boolean findUsableConstructorByArgTypes(Constructor<?> constructor, List<JdbcType> jdbcTypes) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length != jdbcTypes.size()) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (this.typeHandlerRegistry.hasTypeHandler(parameterTypes[i], jdbcTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    private Object applyConstructorAutomapping(ResultSetWrapper rsw, ResultMap resultMap, String columnPrefix, Class<?> resultType, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, Constructor<?> constructor) throws SQLException {
        boolean foundValues = false;
        foundValues = this.configuration.isArgNameBasedConstructorAutoMapping() ? this.applyArgNameBasedConstructorAutoMapping(rsw, resultMap, columnPrefix, resultType, constructorArgTypes, constructorArgs, constructor, foundValues) : this.applyColumnOrderBasedConstructorAutomapping(rsw, constructorArgTypes, constructorArgs, constructor, foundValues);
        return foundValues ? this.objectFactory.create(resultType, constructorArgTypes, constructorArgs) : null;
    }

    private boolean applyColumnOrderBasedConstructorAutomapping(ResultSetWrapper rsw, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, Constructor<?> constructor, boolean foundValues) throws SQLException {
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            Class<?> parameterType = constructor.getParameterTypes()[i];
            String columnName = rsw.getColumnNames().get(i);
            TypeHandler<?> typeHandler = rsw.getTypeHandler(parameterType, columnName);
            Object value = typeHandler.getResult(rsw.getResultSet(), columnName);
            constructorArgTypes.add(parameterType);
            constructorArgs.add(value);
            foundValues = value != null || foundValues;
        }
        return foundValues;
    }

    private boolean applyArgNameBasedConstructorAutoMapping(ResultSetWrapper rsw, ResultMap resultMap, String columnPrefix, Class<?> resultType, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, Constructor<?> constructor, boolean foundValues) throws SQLException {
        Parameter[] params;
        ArrayList<String> missingArgs = null;
        for (Parameter param : params = constructor.getParameters()) {
            boolean columnNotFound = true;
            Param paramAnno = param.getAnnotation(Param.class);
            String paramName = paramAnno == null ? param.getName() : paramAnno.value();
            for (String columnName : rsw.getColumnNames()) {
                if (!this.columnMatchesParam(columnName, paramName, columnPrefix)) continue;
                Class<?> paramType = param.getType();
                TypeHandler<?> typeHandler = rsw.getTypeHandler(paramType, columnName);
                Object value = typeHandler.getResult(rsw.getResultSet(), columnName);
                constructorArgTypes.add(paramType);
                constructorArgs.add(value);
                String mapKey = resultMap.getId() + ":" + columnPrefix;
                if (!this.autoMappingsCache.containsKey(mapKey)) {
                    MapUtil.computeIfAbsent(this.constructorAutoMappingColumns, mapKey, k -> new ArrayList()).add(columnName);
                }
                columnNotFound = false;
                foundValues = value != null || foundValues;
            }
            if (!columnNotFound) continue;
            if (missingArgs == null) {
                missingArgs = new ArrayList<String>();
            }
            missingArgs.add(paramName);
        }
        if (foundValues && constructorArgs.size() < params.length) {
            throw new ExecutorException(MessageFormat.format("Constructor auto-mapping of ''{1}'' failed because ''{0}'' were not found in the result set; Available columns are ''{2}'' and mapUnderscoreToCamelCase is ''{3}''.", missingArgs, constructor, rsw.getColumnNames(), this.configuration.isMapUnderscoreToCamelCase()));
        }
        return foundValues;
    }

    private boolean columnMatchesParam(String columnName, String paramName, String columnPrefix) {
        if (columnPrefix != null) {
            if (!columnName.toUpperCase(Locale.ENGLISH).startsWith(columnPrefix)) {
                return false;
            }
            columnName = columnName.substring(columnPrefix.length());
        }
        return paramName.equalsIgnoreCase(this.configuration.isMapUnderscoreToCamelCase() ? columnName.replace("_", "") : columnName);
    }

    private Object createPrimitiveResultObject(ResultSetWrapper rsw, ResultMap resultMap, String columnPrefix) throws SQLException {
        String columnName;
        Class<?> resultType = resultMap.getType();
        if (!resultMap.getResultMappings().isEmpty()) {
            List<ResultMapping> resultMappingList = resultMap.getResultMappings();
            ResultMapping mapping = resultMappingList.get(0);
            columnName = this.prependPrefix(mapping.getColumn(), columnPrefix);
        } else {
            columnName = rsw.getColumnNames().get(0);
        }
        TypeHandler<?> typeHandler = rsw.getTypeHandler(resultType, columnName);
        return typeHandler.getResult(rsw.getResultSet(), columnName);
    }

    private Object getNestedQueryConstructorValue(ResultSet rs, ResultMapping constructorMapping, String columnPrefix) throws SQLException {
        String nestedQueryId = constructorMapping.getNestedQueryId();
        MappedStatement nestedQuery = this.configuration.getMappedStatement(nestedQueryId);
        Class<?> nestedQueryParameterType = nestedQuery.getParameterMap().getType();
        Object nestedQueryParameterObject = this.prepareParameterForNestedQuery(rs, constructorMapping, nestedQueryParameterType, columnPrefix);
        Object value = null;
        if (nestedQueryParameterObject != null) {
            BoundSql nestedBoundSql = nestedQuery.getBoundSql(nestedQueryParameterObject);
            CacheKey key = this.executor.createCacheKey(nestedQuery, nestedQueryParameterObject, RowBounds.DEFAULT, nestedBoundSql);
            Class<?> targetType = constructorMapping.getJavaType();
            ResultLoader resultLoader = new ResultLoader(this.configuration, this.executor, nestedQuery, nestedQueryParameterObject, targetType, key, nestedBoundSql);
            value = resultLoader.loadResult();
        }
        return value;
    }

    private Object getNestedQueryMappingValue(ResultSet rs, MetaObject metaResultObject, ResultMapping propertyMapping, ResultLoaderMap lazyLoader, String columnPrefix) throws SQLException {
        String nestedQueryId = propertyMapping.getNestedQueryId();
        String property = propertyMapping.getProperty();
        MappedStatement nestedQuery = this.configuration.getMappedStatement(nestedQueryId);
        Class<?> nestedQueryParameterType = nestedQuery.getParameterMap().getType();
        Object nestedQueryParameterObject = this.prepareParameterForNestedQuery(rs, propertyMapping, nestedQueryParameterType, columnPrefix);
        Object value = null;
        if (nestedQueryParameterObject != null) {
            BoundSql nestedBoundSql = nestedQuery.getBoundSql(nestedQueryParameterObject);
            CacheKey key = this.executor.createCacheKey(nestedQuery, nestedQueryParameterObject, RowBounds.DEFAULT, nestedBoundSql);
            Class<?> targetType = propertyMapping.getJavaType();
            if (this.executor.isCached(nestedQuery, key)) {
                this.executor.deferLoad(nestedQuery, metaResultObject, property, key, targetType);
                value = DEFERRED;
            } else {
                ResultLoader resultLoader = new ResultLoader(this.configuration, this.executor, nestedQuery, nestedQueryParameterObject, targetType, key, nestedBoundSql);
                if (propertyMapping.isLazy()) {
                    lazyLoader.addLoader(property, metaResultObject, resultLoader);
                    value = DEFERRED;
                } else {
                    value = resultLoader.loadResult();
                }
            }
        }
        return value;
    }

    private Object prepareParameterForNestedQuery(ResultSet rs, ResultMapping resultMapping, Class<?> parameterType, String columnPrefix) throws SQLException {
        if (resultMapping.isCompositeResult()) {
            return this.prepareCompositeKeyParameter(rs, resultMapping, parameterType, columnPrefix);
        }
        return this.prepareSimpleKeyParameter(rs, resultMapping, parameterType, columnPrefix);
    }

    private Object prepareSimpleKeyParameter(ResultSet rs, ResultMapping resultMapping, Class<?> parameterType, String columnPrefix) throws SQLException {
        TypeHandler<Object> typeHandler = this.typeHandlerRegistry.hasTypeHandler(parameterType) ? this.typeHandlerRegistry.getTypeHandler(parameterType) : this.typeHandlerRegistry.getUnknownTypeHandler();
        return typeHandler.getResult(rs, this.prependPrefix(resultMapping.getColumn(), columnPrefix));
    }

    private Object prepareCompositeKeyParameter(ResultSet rs, ResultMapping resultMapping, Class<?> parameterType, String columnPrefix) throws SQLException {
        Object parameterObject = this.instantiateParameterObject(parameterType);
        MetaObject metaObject = this.configuration.newMetaObject(parameterObject);
        boolean foundValues = false;
        for (ResultMapping innerResultMapping : resultMapping.getComposites()) {
            Class<?> propType = metaObject.getSetterType(innerResultMapping.getProperty());
            TypeHandler<?> typeHandler = this.typeHandlerRegistry.getTypeHandler(propType);
            Object propValue = typeHandler.getResult(rs, this.prependPrefix(innerResultMapping.getColumn(), columnPrefix));
            if (propValue == null) continue;
            metaObject.setValue(innerResultMapping.getProperty(), propValue);
            foundValues = true;
        }
        return foundValues ? parameterObject : null;
    }

    private Object instantiateParameterObject(Class<?> parameterType) {
        if (parameterType == null) {
            return new HashMap();
        }
        if (MapperMethod.ParamMap.class.equals(parameterType)) {
            return new HashMap();
        }
        return this.objectFactory.create(parameterType);
    }

    public ResultMap resolveDiscriminatedResultMap(ResultSet rs, ResultMap resultMap, String columnPrefix) throws SQLException {
        Object value;
        String discriminatedMapId;
        HashSet<String> pastDiscriminators = new HashSet<String>();
        Discriminator discriminator = resultMap.getDiscriminator();
        while (discriminator != null && this.configuration.hasResultMap(discriminatedMapId = discriminator.getMapIdFor(String.valueOf(value = this.getDiscriminatorValue(rs, discriminator, columnPrefix))))) {
            resultMap = this.configuration.getResultMap(discriminatedMapId);
            Discriminator lastDiscriminator = discriminator;
            discriminator = resultMap.getDiscriminator();
            if (discriminator != lastDiscriminator && pastDiscriminators.add(discriminatedMapId)) continue;
            break;
        }
        return resultMap;
    }

    private Object getDiscriminatorValue(ResultSet rs, Discriminator discriminator, String columnPrefix) throws SQLException {
        ResultMapping resultMapping = discriminator.getResultMapping();
        TypeHandler<?> typeHandler = resultMapping.getTypeHandler();
        return typeHandler.getResult(rs, this.prependPrefix(resultMapping.getColumn(), columnPrefix));
    }

    private String prependPrefix(String columnName, String prefix) {
        if (columnName == null || columnName.length() == 0 || prefix == null || prefix.length() == 0) {
            return columnName;
        }
        return prefix + columnName;
    }

    private void handleRowValuesForNestedResultMap(ResultSetWrapper rsw, ResultMap resultMap, ResultHandler<?> resultHandler, RowBounds rowBounds, ResultMapping parentMapping) throws SQLException {
        DefaultResultContext<Object> resultContext = new DefaultResultContext<Object>();
        ResultSet resultSet = rsw.getResultSet();
        this.skipRows(resultSet, rowBounds);
        Object rowValue = this.previousRowValue;
        while (this.shouldProcessMoreRows(resultContext, rowBounds) && !resultSet.isClosed() && resultSet.next()) {
            ResultMap discriminatedResultMap = this.resolveDiscriminatedResultMap(resultSet, resultMap, null);
            CacheKey rowKey = this.createRowKey(discriminatedResultMap, rsw, null);
            Object partialObject = this.nestedResultObjects.get(rowKey);
            if (this.mappedStatement.isResultOrdered()) {
                if (partialObject == null && rowValue != null) {
                    this.nestedResultObjects.clear();
                    this.storeObject(resultHandler, resultContext, rowValue, parentMapping, resultSet);
                }
                rowValue = this.getRowValue(rsw, discriminatedResultMap, rowKey, null, partialObject);
                continue;
            }
            rowValue = this.getRowValue(rsw, discriminatedResultMap, rowKey, null, partialObject);
            if (partialObject != null) continue;
            this.storeObject(resultHandler, resultContext, rowValue, parentMapping, resultSet);
        }
        if (rowValue != null && this.mappedStatement.isResultOrdered() && this.shouldProcessMoreRows(resultContext, rowBounds)) {
            this.storeObject(resultHandler, resultContext, rowValue, parentMapping, resultSet);
            this.previousRowValue = null;
        } else if (rowValue != null) {
            this.previousRowValue = rowValue;
        }
    }

    private boolean applyNestedResultMappings(ResultSetWrapper rsw, ResultMap resultMap, MetaObject metaObject, String parentPrefix, CacheKey parentRowKey, boolean newObject) {
        boolean foundValues = false;
        for (ResultMapping resultMapping : resultMap.getPropertyResultMappings()) {
            String nestedResultMapId = resultMapping.getNestedResultMapId();
            if (nestedResultMapId == null || resultMapping.getResultSet() != null) continue;
            try {
                Object ancestorObject;
                String columnPrefix = this.getColumnPrefix(parentPrefix, resultMapping);
                ResultMap nestedResultMap = this.getNestedResultMap(rsw.getResultSet(), nestedResultMapId, columnPrefix);
                if (resultMapping.getColumnPrefix() == null && (ancestorObject = this.ancestorObjects.get(nestedResultMapId)) != null) {
                    if (!newObject) continue;
                    this.linkObjects(metaObject, resultMapping, ancestorObject);
                    continue;
                }
                CacheKey rowKey = this.createRowKey(nestedResultMap, rsw, columnPrefix);
                CacheKey combinedKey = this.combineKeys(rowKey, parentRowKey);
                Object rowValue = this.nestedResultObjects.get(combinedKey);
                boolean knownValue = rowValue != null;
                this.instantiateCollectionPropertyIfAppropriate(resultMapping, metaObject);
                if (!this.anyNotNullColumnHasValue(resultMapping, columnPrefix, rsw) || (rowValue = this.getRowValue(rsw, nestedResultMap, combinedKey, columnPrefix, rowValue)) == null || knownValue) continue;
                this.linkObjects(metaObject, resultMapping, rowValue);
                foundValues = true;
            }
            catch (SQLException e) {
                throw new ExecutorException("Error getting nested result map values for '" + resultMapping.getProperty() + "'.  Cause: " + e, e);
            }
        }
        return foundValues;
    }

    private String getColumnPrefix(String parentPrefix, ResultMapping resultMapping) {
        StringBuilder columnPrefixBuilder = new StringBuilder();
        if (parentPrefix != null) {
            columnPrefixBuilder.append(parentPrefix);
        }
        if (resultMapping.getColumnPrefix() != null) {
            columnPrefixBuilder.append(resultMapping.getColumnPrefix());
        }
        return columnPrefixBuilder.length() == 0 ? null : columnPrefixBuilder.toString().toUpperCase(Locale.ENGLISH);
    }

    private boolean anyNotNullColumnHasValue(ResultMapping resultMapping, String columnPrefix, ResultSetWrapper rsw) throws SQLException {
        Set<String> notNullColumns = resultMapping.getNotNullColumns();
        if (notNullColumns != null && !notNullColumns.isEmpty()) {
            ResultSet rs = rsw.getResultSet();
            for (String column : notNullColumns) {
                rs.getObject(this.prependPrefix(column, columnPrefix));
                if (rs.wasNull()) continue;
                return true;
            }
            return false;
        }
        if (columnPrefix != null) {
            for (String columnName : rsw.getColumnNames()) {
                if (!columnName.toUpperCase(Locale.ENGLISH).startsWith(columnPrefix.toUpperCase(Locale.ENGLISH))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private ResultMap getNestedResultMap(ResultSet rs, String nestedResultMapId, String columnPrefix) throws SQLException {
        ResultMap nestedResultMap = this.configuration.getResultMap(nestedResultMapId);
        return this.resolveDiscriminatedResultMap(rs, nestedResultMap, columnPrefix);
    }

    private CacheKey createRowKey(ResultMap resultMap, ResultSetWrapper rsw, String columnPrefix) throws SQLException {
        CacheKey cacheKey = new CacheKey();
        cacheKey.update(resultMap.getId());
        List<ResultMapping> resultMappings = this.getResultMappingsForRowKey(resultMap);
        if (resultMappings.isEmpty()) {
            if (Map.class.isAssignableFrom(resultMap.getType())) {
                this.createRowKeyForMap(rsw, cacheKey);
            } else {
                this.createRowKeyForUnmappedProperties(resultMap, rsw, cacheKey, columnPrefix);
            }
        } else {
            this.createRowKeyForMappedProperties(resultMap, rsw, cacheKey, resultMappings, columnPrefix);
        }
        if (cacheKey.getUpdateCount() < 2) {
            return CacheKey.NULL_CACHE_KEY;
        }
        return cacheKey;
    }

    private CacheKey combineKeys(CacheKey rowKey, CacheKey parentRowKey) {
        if (rowKey.getUpdateCount() > 1 && parentRowKey.getUpdateCount() > 1) {
            CacheKey combinedKey;
            try {
                combinedKey = rowKey.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new ExecutorException("Error cloning cache key.  Cause: " + e, e);
            }
            combinedKey.update(parentRowKey);
            return combinedKey;
        }
        return CacheKey.NULL_CACHE_KEY;
    }

    private List<ResultMapping> getResultMappingsForRowKey(ResultMap resultMap) {
        List<ResultMapping> resultMappings = resultMap.getIdResultMappings();
        if (resultMappings.isEmpty()) {
            resultMappings = resultMap.getPropertyResultMappings();
        }
        return resultMappings;
    }

    private void createRowKeyForMappedProperties(ResultMap resultMap, ResultSetWrapper rsw, CacheKey cacheKey, List<ResultMapping> resultMappings, String columnPrefix) throws SQLException {
        for (ResultMapping resultMapping : resultMappings) {
            Object value;
            if (!resultMapping.isSimple()) continue;
            String column = this.prependPrefix(resultMapping.getColumn(), columnPrefix);
            TypeHandler<?> th = resultMapping.getTypeHandler();
            List<String> mappedColumnNames = rsw.getMappedColumnNames(resultMap, columnPrefix);
            if (column == null || !mappedColumnNames.contains(column.toUpperCase(Locale.ENGLISH)) || (value = th.getResult(rsw.getResultSet(), column)) == null && !this.configuration.isReturnInstanceForEmptyRow()) continue;
            cacheKey.update(column);
            cacheKey.update(value);
        }
    }

    private void createRowKeyForUnmappedProperties(ResultMap resultMap, ResultSetWrapper rsw, CacheKey cacheKey, String columnPrefix) throws SQLException {
        MetaClass metaType = MetaClass.forClass(resultMap.getType(), this.reflectorFactory);
        List<String> unmappedColumnNames = rsw.getUnmappedColumnNames(resultMap, columnPrefix);
        Iterator<String> iterator = unmappedColumnNames.iterator();
        while (iterator.hasNext()) {
            String value;
            String column;
            String property = column = iterator.next();
            if (columnPrefix != null && !columnPrefix.isEmpty()) {
                if (!column.toUpperCase(Locale.ENGLISH).startsWith(columnPrefix)) continue;
                property = column.substring(columnPrefix.length());
            }
            if (metaType.findProperty(property, this.configuration.isMapUnderscoreToCamelCase()) == null || (value = rsw.getResultSet().getString(column)) == null) continue;
            cacheKey.update(column);
            cacheKey.update(value);
        }
    }

    private void createRowKeyForMap(ResultSetWrapper rsw, CacheKey cacheKey) throws SQLException {
        List<String> columnNames = rsw.getColumnNames();
        for (String columnName : columnNames) {
            String value = rsw.getResultSet().getString(columnName);
            if (value == null) continue;
            cacheKey.update(columnName);
            cacheKey.update(value);
        }
    }

    private void linkObjects(MetaObject metaObject, ResultMapping resultMapping, Object rowValue) {
        Object collectionProperty = this.instantiateCollectionPropertyIfAppropriate(resultMapping, metaObject);
        if (collectionProperty != null) {
            MetaObject targetMetaObject = this.configuration.newMetaObject(collectionProperty);
            targetMetaObject.add(rowValue);
        } else {
            metaObject.setValue(resultMapping.getProperty(), rowValue);
        }
    }

    private Object instantiateCollectionPropertyIfAppropriate(ResultMapping resultMapping, MetaObject metaObject) {
        block6: {
            String propertyName = resultMapping.getProperty();
            Object propertyValue = metaObject.getValue(propertyName);
            if (propertyValue == null) {
                Class<?> type = resultMapping.getJavaType();
                if (type == null) {
                    type = metaObject.getSetterType(propertyName);
                }
                try {
                    if (this.objectFactory.isCollection(type)) {
                        propertyValue = this.objectFactory.create(type);
                        metaObject.setValue(propertyName, propertyValue);
                        return propertyValue;
                    }
                    break block6;
                }
                catch (Exception e) {
                    throw new ExecutorException("Error instantiating collection property for result '" + resultMapping.getProperty() + "'.  Cause: " + e, e);
                }
            }
            if (this.objectFactory.isCollection(propertyValue.getClass())) {
                return propertyValue;
            }
        }
        return null;
    }

    private boolean hasTypeHandlerForResultObject(ResultSetWrapper rsw, Class<?> resultType) {
        if (rsw.getColumnNames().size() == 1) {
            return this.typeHandlerRegistry.hasTypeHandler(resultType, rsw.getJdbcType(rsw.getColumnNames().get(0)));
        }
        return this.typeHandlerRegistry.hasTypeHandler(resultType);
    }

    private static class UnMappedColumnAutoMapping {
        private final String column;
        private final String property;
        private final TypeHandler<?> typeHandler;
        private final boolean primitive;

        public UnMappedColumnAutoMapping(String column, String property, TypeHandler<?> typeHandler, boolean primitive) {
            this.column = column;
            this.property = property;
            this.typeHandler = typeHandler;
            this.primitive = primitive;
        }
    }

    private static class PendingRelation {
        public MetaObject metaObject;
        public ResultMapping propertyMapping;

        private PendingRelation() {
        }
    }
}

