/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import lombok.Generated;
import org.apereo.cas.support.oauth.authenticator.OAuth20AccessTokenAuthenticator;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.LoggingUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcClientConfigurationAccessTokenAuthenticator
extends OAuth20AccessTokenAuthenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcClientConfigurationAccessTokenAuthenticator.class);

    public OidcClientConfigurationAccessTokenAuthenticator(TicketRegistry ticketRegistry, JwtBuilder accessTokenJwtBuilder) {
        super(ticketRegistry, accessTokenJwtBuilder);
    }

    protected CommonProfile buildUserProfile(TokenCredentials tokenCredentials, WebContext webContext, OAuth20AccessToken accessToken) {
        try {
            CommonProfile profile = super.buildUserProfile(tokenCredentials, webContext, accessToken);
            LOGGER.trace("Examining access token [{}] for required scope [{}]", (Object)accessToken, (Object)"client_configuration_scope");
            if (accessToken.getScopes().contains("client_configuration_scope")) {
                return profile;
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return null;
    }
}

