/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;

public final class SyncopeUserTOConverterUtils {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    public static Map<String, List<Object>> convert(JsonNode user, Map<String, String> attributeMappings) {
        String attrName;
        String name;
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
        if (user.has("securityQuestion") && !user.get("securityQuestion").isNull()) {
            name = attributeMappings.getOrDefault("securityQuestion", "syncopeUserSecurityQuestion");
            attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("securityQuestion").asText()}));
        }
        name = attributeMappings.getOrDefault("key", "syncopeUserKey");
        attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("key").asText()}));
        name = attributeMappings.getOrDefault("status", "syncopeUserStatus");
        attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("status").asText()}));
        name = attributeMappings.getOrDefault("realm", "syncopeUserRealm");
        attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("realm").asText()}));
        name = attributeMappings.getOrDefault("creator", "syncopeUserCreator");
        attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("creator").asText()}));
        name = attributeMappings.getOrDefault("creationDate", "syncopeUserCreationDate");
        attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("creationDate").asText()}));
        if (user.has("changePwdDate") && !user.get("changePwdDate").isNull()) {
            name = attributeMappings.getOrDefault("changePwdDate", "syncopeUserChangePwdDate");
            attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("changePwdDate").asText()}));
        }
        if (user.has("lastLoginDate") && !user.get("lastLoginDate").isNull()) {
            name = attributeMappings.getOrDefault("lastLoginDate", "syncopeUserLastLoginDate");
            attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("lastLoginDate").asText()}));
        }
        SyncopeUserTOConverterUtils.collectListableAttribute(attributes, user, "roles", "syncopeUserRoles", attributeMappings);
        SyncopeUserTOConverterUtils.collectListableAttribute(attributes, user, "dynRoles", "syncopeUserDynRoles", attributeMappings);
        SyncopeUserTOConverterUtils.collectListableAttribute(attributes, user, "dynRealms", "syncopeUserDynRealms", attributeMappings);
        if (user.has("memberships")) {
            ArrayList memberships = new ArrayList();
            user.get("memberships").forEach(member -> memberships.add(member.get("groupName").asText()));
            if (!memberships.isEmpty()) {
                name = attributeMappings.getOrDefault("memberships", "syncopeUserMemberships");
                attributes.put(name, memberships);
            }
        }
        if (user.has("dynMemberships")) {
            ArrayList dynMemberships = new ArrayList();
            user.get("dynMemberships").forEach(m -> dynMemberships.add(m.get("groupName").asText()));
            if (!dynMemberships.isEmpty()) {
                name = attributeMappings.getOrDefault("dynMemberships", "syncopeUserDynMemberships");
                attributes.put(name, dynMemberships);
            }
        }
        if (user.has("relationships")) {
            ArrayList relationships = new ArrayList();
            user.get("relationships").forEach(r -> relationships.add(r.get("type").asText() + ";" + r.get("otherEndName").asText()));
            if (!relationships.isEmpty()) {
                name = attributeMappings.getOrDefault("relationships", "syncopeUserRelationships");
                attributes.put(name, relationships);
            }
        }
        if (user.has("plainAttrs")) {
            attrName = attributeMappings.getOrDefault("plainAttrs", "syncopeUserAttr_");
            user.get("plainAttrs").forEach(attr -> attributes.put(attrName + attr.get("schema").asText(), (List)MAPPER.convertValue((Object)attr.get("values"), ArrayList.class)));
        }
        if (user.has("derAttrs")) {
            attrName = attributeMappings.getOrDefault("derAttrs", "syncopeUserAttr_");
            user.get("derAttrs").forEach(a -> attributes.put(attrName + a.get("schema").asText(), (List)MAPPER.convertValue((Object)a.get("values"), ArrayList.class)));
        }
        if (user.has("virAttrs")) {
            attrName = attributeMappings.getOrDefault("virAttrs", "syncopeUserAttr_");
            user.get("virAttrs").forEach(a -> attributes.put(attrName + a.get("schema").asText(), (List)MAPPER.convertValue((Object)a.get("values"), ArrayList.class)));
        }
        return attributes;
    }

    private static void collectListableAttribute(Map<String, List<Object>> attributes, JsonNode user, String syncopeAttribute, String casAttribute, Map<String, String> attributeMappings) {
        List values;
        List list = values = user.has(syncopeAttribute) ? (List)MAPPER.convertValue((Object)user.get(syncopeAttribute), ArrayList.class) : CollectionUtils.wrapList((Object[])new Object[0]);
        if (!values.isEmpty()) {
            String name = attributeMappings.getOrDefault(syncopeAttribute, casAttribute);
            attributes.put(name, values);
        }
    }

    @Generated
    private SyncopeUserTOConverterUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

