/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.soap.cxf;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.identityconnectors.common.StringUtil;

public class ForceSoapActionOutInterceptor
extends AbstractSoapInterceptor {
    private final String SOAPActionUriPrefix;

    public ForceSoapActionOutInterceptor(String SOAPActionUriPrefix) {
        super("post-logical");
        this.SOAPActionUriPrefix = SOAPActionUriPrefix == null ? null : (SOAPActionUriPrefix.endsWith("/") ? SOAPActionUriPrefix : SOAPActionUriPrefix + "/");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        this.setSoapAction(message);
    }

    private void setSoapAction(SoapMessage message) {
        String contentType;
        BindingOperationInfo boi = message.getExchange().getBindingOperationInfo();
        if (boi != null && boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
        }
        String action = this.getSoapAction(message, boi);
        if (message.getVersion() instanceof Soap11) {
            TreeMap<String, List<String>> reqHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
            if (reqHeaders == null) {
                reqHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            }
            if (reqHeaders.isEmpty()) {
                message.put(Message.PROTOCOL_HEADERS, reqHeaders);
            }
            if (!reqHeaders.containsKey("SOAPAction")) {
                reqHeaders.put("SOAPAction", Collections.singletonList(action));
            }
        } else if (message.getVersion() instanceof Soap12 && !"\"\"".equals(action) && !(contentType = (String)message.get((Object)"Content-Type")).contains("action=\"")) {
            contentType = contentType + "; action=" + action;
            message.put("Content-Type", (Object)contentType);
        }
    }

    private String getSoapAction(SoapMessage message, BindingOperationInfo boi) {
        String action = (String)message.get((Object)"SOAPAction");
        if (action == null) {
            if (boi == null) {
                action = "\"\"";
            } else {
                SoapOperationInfo soi;
                BindingOperationInfo dboi = (BindingOperationInfo)boi.getProperty("dispatchToOperation");
                if (null != dboi) {
                    boi = dboi;
                }
                String string = action = (soi = (SoapOperationInfo)boi.getExtensor(SoapOperationInfo.class)) == null || StringUtil.isBlank((String)soi.getAction()) || StringUtil.isBlank((String)this.SOAPActionUriPrefix) ? "\"\"" : this.SOAPActionUriPrefix + soi.getAction();
            }
        }
        if (!action.startsWith("\"")) {
            action = "\"" + action + "\"";
        }
        return action;
    }
}

