/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.syncope.common.lib.types.EntitlementsHolder;
import org.apache.syncope.common.lib.types.ImplementationTypesHolder;
import org.apache.syncope.common.lib.types.SAML2SP4UIEntitlement;
import org.apache.syncope.common.lib.types.SAML2SP4UIImplementationType;
import org.apache.syncope.core.logic.SAML2SP4UIProperties;
import org.apache.syncope.core.logic.saml2.NoOpLogoutHandler;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.keystore.BaseSAML2KeystoreGenerator;
import org.pac4j.saml.metadata.keystore.SAML2KeystoreGenerator;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class SAML2SP4UILoader
implements SyncopeCoreLoader {
    protected final SAML2SP4UIProperties props;
    protected final ResourcePatternResolver resourceResolver;

    public SAML2SP4UILoader(SAML2SP4UIProperties props, ResourcePatternResolver resourceResolver) {
        this.props = props;
        this.resourceResolver = resourceResolver;
    }

    public int getOrder() {
        return 1000;
    }

    public void load() {
        EntitlementsHolder.getInstance().addAll((Collection)SAML2SP4UIEntitlement.values());
        ImplementationTypesHolder.getInstance().putAll(SAML2SP4UIImplementationType.values());
    }

    public SAML2Configuration newSAML2Configuration() {
        final SAML2Configuration cfg = new SAML2Configuration(this.resourceResolver.getResource(this.props.getKeystore()), this.props.getKeystoreStorepass(), this.props.getKeystoreKeypass(), null);
        cfg.setKeystoreType(this.props.getKeystoreType());
        if (cfg.getKeystoreResource() instanceof FileUrlResource) {
            cfg.setKeystoreGenerator((SAML2KeystoreGenerator)new BaseSAML2KeystoreGenerator(cfg){

                protected void store(KeyStore ks, X509Certificate certificate, PrivateKey privateKey) throws Exception {
                }

                public InputStream retrieve() throws Exception {
                    return cfg.getKeystoreResource().getInputStream();
                }
            });
        }
        cfg.setWantsAssertionsSigned(true);
        cfg.setAuthnRequestSigned(true);
        cfg.setSpLogoutRequestSigned(true);
        cfg.setAcceptedSkew(this.props.getSkew());
        cfg.setLogoutHandler((LogoutHandler)new NoOpLogoutHandler());
        return cfg;
    }
}

