/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.resources.ObjectTypeTogglePanel;
import org.apache.syncope.client.console.wizards.resources.ProvisionWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ResourceProvision;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class ResourceProvisionPanel
extends AbstractModalPanel<Serializable> {
    private static final long serialVersionUID = -7982691107029848579L;
    private final ResourceTO resourceTO;
    private final List<ResourceProvision> provisions;
    private final ObjectTypeTogglePanel objectTypeTogglePanel;
    private final WizardMgtPanel<ResourceProvision> list;
    private final ProvisionWizardBuilder wizard;
    private final AjaxLink<ResourceProvision> addAjaxLink;
    protected ActionLinksTogglePanel<ResourceProvision> actionTogglePanel;

    public ResourceProvisionPanel(BaseModal<Serializable> modal, final ResourceTO resourceTO, final String adminRealm, final PageReference pageRef) {
        super(modal, pageRef);
        this.resourceTO = resourceTO;
        this.setOutputMarkupId(true);
        this.actionTogglePanel = new ActionLinksTogglePanel("toggle", pageRef);
        this.add(new Component[]{this.actionTogglePanel});
        this.wizard = new ProvisionWizardBuilder(resourceTO, adminRealm, pageRef);
        ListViewPanel.Builder<ResourceProvision> builder = new ListViewPanel.Builder<ResourceProvision>(ResourceProvision.class, pageRef){
            private static final long serialVersionUID = 4907732721283972943L;

            protected ResourceProvision getActualItem(ResourceProvision item, List<ResourceProvision> list) {
                return Optional.ofNullable(item).flatMap(resourceProvision -> list.stream().filter(in -> (resourceProvision.getKey() == null && in.getKey() == null || in.getKey() != null && in.getKey().equals(resourceProvision.getKey())) && (resourceProvision.getAnyType() == null && in.getAnyType() == null || in.getAnyType() != null && in.getAnyType().equals(resourceProvision.getAnyType()))).findAny()).orElse(null);
            }

            protected void customActionCallback(AjaxRequestTarget target) {
                ResourceProvisionPanel.this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
            }

            protected void customActionOnCancelCallback(AjaxRequestTarget target) {
                ResourceProvisionPanel.this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
            }

            protected void customActionOnFinishCallback(AjaxRequestTarget target) {
                ResourceProvisionPanel.this.checkAddButton(adminRealm);
                ResourceProvisionPanel.this.sortProvisions();
                ResourceProvisionPanel.this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
            }

            protected ActionLinksTogglePanel<ResourceProvision> getTogglePanel() {
                return ResourceProvisionPanel.this.actionTogglePanel;
            }
        };
        this.provisions = new ArrayList<ResourceProvision>();
        if (resourceTO.getOrgUnit() != null) {
            this.provisions.add(new ResourceProvision(resourceTO.getOrgUnit()));
        }
        resourceTO.getProvisions().forEach(provision -> this.provisions.add(new ResourceProvision((Provision)provision)));
        this.sortProvisions();
        builder.setItems(this.provisions);
        builder.includes(new String[]{"anyType", "objectClass", "auxClasses"});
        builder.setReuseItem(false);
        builder.addAction((ActionLink)new ActionLink<ResourceProvision>(){
            private static final long serialVersionUID = -3722207913631435504L;

            public void onClick(AjaxRequestTarget target, ResourceProvision provision) {
                try {
                    ResourceProvisionPanel.this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.DEPTH, new AjaxWizard.NewItemActionEvent((Serializable)((Object)provision), 1, target).setTitleModel((IModel)new StringResourceModel("inner.provision.mapping", (Component)ResourceProvisionPanel.this, (IModel)Model.of((Serializable)((Object)provision)))));
                }
                catch (SyncopeClientException e) {
                    LOG.error("While contacting resource", (Throwable)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                    ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }
        }, ActionLink.ActionType.MAPPING, "RESOURCE_READ").addAction((ActionLink)new ActionLink<ResourceProvision>(){
            private static final long serialVersionUID = -7780999687733432439L;

            public void onClick(AjaxRequestTarget target, ResourceProvision provision) {
                try {
                    ResourceRestClient.setLatestSyncToken(resourceTO.getKey(), provision.getAnyType());
                    SyncopeConsoleSession.get().success((Serializable)((Object)ResourceProvisionPanel.this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While setting latest sync token for {}/{}", new Object[]{resourceTO.getKey(), provision.getAnyType(), e});
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.SET_LATEST_SYNC_TOKEN, "RESOURCE_UPDATE").addAction((ActionLink)new ActionLink<ResourceProvision>(){
            private static final long serialVersionUID = -7780999687733432439L;

            public void onClick(AjaxRequestTarget target, ResourceProvision provision) {
                try {
                    ResourceRestClient.removeSyncToken(resourceTO.getKey(), provision.getAnyType());
                    SyncopeConsoleSession.get().success((Serializable)((Object)ResourceProvisionPanel.this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While removing sync token for {}/{}", new Object[]{resourceTO.getKey(), provision.getAnyType(), e});
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.REMOVE_SYNC_TOKEN, "RESOURCE_UPDATE").addAction((ActionLink)new ActionLink<ResourceProvision>(){
            private static final long serialVersionUID = -3722207913631435544L;

            public void onClick(AjaxRequestTarget target, ResourceProvision provision) {
                if (provision.getOrgUnitTO() != null) {
                    resourceTO.setOrgUnit(null);
                } else if (provision.getProvisionTO() != null) {
                    resourceTO.getProvisions().remove(provision.getProvisionTO());
                }
                ResourceProvisionPanel.this.provisions.remove(provision);
                ResourceProvisionPanel.this.checkAddButton(adminRealm);
                ResourceProvisionPanel.this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.DEPTH, new ListViewPanel.ListViewReload(target));
            }
        }, ActionLink.ActionType.DELETE, "RESOURCE_UPDATE", true);
        builder.addNewItemPanelBuilder((ModalPanelBuilder)this.wizard);
        this.list = builder.build("provision");
        this.list.setReadOnly(!SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", new String[]{adminRealm}));
        this.addAjaxLink = new AjaxLink<ResourceProvision>("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
                ResourceProvisionPanel.this.objectTypeTogglePanel.setHeaderLabel(target);
                ResourceProvisionPanel.this.objectTypeTogglePanel.toggle(target, true);
            }
        };
        this.list.addOrReplaceInnerObject(new Component[]{this.addAjaxLink});
        this.add(new Component[]{this.list});
        final ResourceProvision provision2 = new ResourceProvision();
        provision2.setAnyType("");
        this.objectTypeTogglePanel = new ObjectTypeTogglePanel("objectTypeToggle", provision2, this.getAnyTypes(), pageRef){
            private static final long serialVersionUID = 7878063325027015067L;

            @Override
            protected void onSubmit(String type, AjaxRequestTarget target) {
                provision2.setAnyType(type);
                this.send((IEventSink)ResourceProvisionPanel.this.list, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
                this.send((IEventSink)ResourceProvisionPanel.this.list, Broadcast.DEPTH, new AjaxWizard.NewItemActionEvent((Serializable)((Object)provision2), target));
                ResourceProvisionPanel.this.wizard.setObjectClassModelObject(type);
            }
        };
        this.checkAddButton(adminRealm);
        this.add(new Component[]{this.objectTypeTogglePanel});
    }

    private void checkConnObjectKeyCount(String anyType, List<Item> items) {
        long connObjectKeyCount = items.stream().filter(Item::isConnObjectKey).count();
        if (connObjectKeyCount != 1L) {
            throw new IllegalArgumentException(anyType + ": " + new StringResourceModel("connObjectKeyValidation", (Component)this).getString());
        }
    }

    public void onSubmit(AjaxRequestTarget target) {
        try {
            if (this.resourceTO.getOrgUnit() != null) {
                this.checkConnObjectKeyCount("REALM", this.resourceTO.getOrgUnit().getItems());
            }
            new ArrayList(this.resourceTO.getProvisions()).stream().filter(Objects::nonNull).forEachOrdered(provision -> {
                if (provision.getMapping() == null || provision.getMapping().getItems().isEmpty()) {
                    this.resourceTO.getProvisions().remove(provision);
                } else {
                    this.checkConnObjectKeyCount(provision.getAnyType(), provision.getMapping().getItems());
                }
            });
            ResourceRestClient.update(this.resourceTO);
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While creating or updating {}", (Object)this.resourceTO, (Object)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    private void sortProvisions() {
        this.provisions.sort((o1, o2) -> AnyTypeRestClient.KEY_COMPARATOR.compare(o1.getAnyType(), o2.getAnyType()));
    }

    private LoadableDetachableModel<List<String>> getAnyTypes() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                List<String> anyTypes = AnyTypeRestClient.list().stream().filter(anyType -> ResourceProvisionPanel.this.resourceTO.getProvision(anyType).isEmpty()).collect(Collectors.toList());
                if (ResourceProvisionPanel.this.resourceTO.getOrgUnit() == null) {
                    anyTypes.add("REALM");
                }
                anyTypes.sort(AnyTypeRestClient.KEY_COMPARATOR);
                return anyTypes;
            }
        };
    }

    private void checkAddButton(String adminRealm) {
        boolean enabled = SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", new String[]{adminRealm}) && !((List)this.getAnyTypes().getObject()).isEmpty();
        this.addAjaxLink.setVisible(enabled);
        this.objectTypeTogglePanel.setEnabled(enabled);
    }
}

