/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.Serializable;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BaseExtPage;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.panels.SCIMConfPanel;
import org.apache.syncope.client.console.rest.SCIMConfRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wizards.any.ResultPanel;
import org.apache.syncope.client.ui.commons.annotations.ExtPage;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.request.mapper.parameter.PageParameters;

@ExtPage(label="SCIM 2.0", icon="fa fa-cloud", listEntitlement="SCIM_CONF_GET", priority=500)
public class SCIMConfPage
extends BaseExtPage {
    private static final long serialVersionUID = -8156063343062111770L;
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    private final WebMarkupContainer content;

    public SCIMConfPage(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build((String)"dashboard", (String)"dashboardBr", Dashboard.class)});
        this.content = new WebMarkupContainer("content");
        this.content.add(new Component[]{new Label("body", (Serializable)((Object)"General"))});
        this.content.setOutputMarkupId(true);
        this.body.add(new Component[]{this.content});
        this.updateSCIMGeneralConfContent(SCIMConfRestClient.get());
    }

    private WebMarkupContainer updateSCIMGeneralConfContent(SCIMConf scimConf) {
        if (scimConf == null) {
            return this.content;
        }
        this.content.addOrReplace(new Component[]{new SCIMConfPanel("body", scimConf, this.getPageReference()){
            private static final long serialVersionUID = 8221398624379357183L;

            protected void setWindowClosedReloadCallback(BaseModal<?> modal) {
                modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
                    if (modal.getContent() instanceof ResultPanel) {
                        Serializable result = ((ResultPanel)ResultPanel.class.cast(modal.getContent())).getResult();
                        try {
                            SCIMConfRestClient.set((SCIMConf)MAPPER.readValue(result.toString(), SCIMConf.class));
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                            modal.show(false);
                            target.add(new Component[]{SCIMConfPage.this.content});
                        }
                        catch (Exception e) {
                            LOG.error("While setting SCIM configuration", (Throwable)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                });
            }
        }});
        return this.content;
    }
}

