/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Set;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.http.HttpStatus;

@Endpoint(id="multifactorTrustedDevices", enableByDefault=false)
public class MultifactorAuthenticationTrustReportEndpoint
extends BaseCasActuatorEndpoint {
    private final ObjectProvider<MultifactorAuthenticationTrustStorage> mfaTrustEngine;

    public MultifactorAuthenticationTrustReportEndpoint(CasConfigurationProperties casProperties, ObjectProvider<MultifactorAuthenticationTrustStorage> mfaTrustEngine) {
        super(casProperties);
        this.mfaTrustEngine = mfaTrustEngine;
    }

    @ReadOperation
    @Operation(summary="Get collection of trusted devices")
    public Set<? extends MultifactorAuthenticationTrustRecord> devices() {
        this.expireRecords();
        return ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).getAll();
    }

    @ReadOperation
    @Operation(summary="Get collection of trusted devices for the user", parameters={@Parameter(name="username", required=true)})
    public Set<? extends MultifactorAuthenticationTrustRecord> devicesForUser(@Selector String username) {
        this.expireRecords();
        return ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).get(username);
    }

    @Operation(summary="Remove trusted device using its key", parameters={@Parameter(name="key", required=true)})
    @DeleteOperation
    public Integer revoke(@Selector String key) {
        ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).remove(key);
        return HttpStatus.OK.value();
    }

    private void expireRecords() {
        ((MultifactorAuthenticationTrustStorage)this.mfaTrustEngine.getObject()).remove();
    }
}

