/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PullMatch;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.policy.ProvisioningPolicy;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ProvisionSorter;
import org.apache.syncope.core.provisioning.api.pushpull.AnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.UserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractProvisioningJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultAnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultGroupPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultRealmPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultUserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.PullResultHandlerDispatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class PullJobDelegate
extends AbstractProvisioningJobDelegate<PullTask>
implements SyncopePullExecutor {
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected PlainSchemaDAO plainSchemaDAO;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected InboundMatcher inboundMatcher;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;
    @Autowired
    protected PlainAttrValidationManager validator;
    protected final Map<String, SyncToken> latestSyncTokens = Collections.synchronizedMap(new HashMap());
    protected ProvisioningProfile<PullTask, PullActions> profile;
    protected final Map<String, MutablePair<Integer, String>> handled = new HashMap<String, MutablePair<Integer, String>>();
    protected final Map<String, PullActions> perContextActions = new ConcurrentHashMap<String, PullActions>();
    protected Optional<ReconFilterBuilder> perContextReconFilterBuilder = Optional.empty();

    public void setLatestSyncToken(String objectClass, SyncToken latestSyncToken) {
        this.latestSyncTokens.put(objectClass, latestSyncToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportHandled(String objectClass, Name name) {
        Map<String, MutablePair<Integer, String>> map = this.handled;
        synchronized (map) {
            MutablePair pair = Optional.ofNullable(this.handled.get(objectClass)).orElseGet(() -> {
                MutablePair p = MutablePair.of((Object)0, null);
                this.handled.put(objectClass, (MutablePair<Integer, String>)p);
                return p;
            });
            pair.setLeft((Object)((Integer)pair.getLeft() + 1));
            pair.setRight((Object)name.getNameValue());
            if (!this.handled.isEmpty()) {
                StringBuilder builder = new StringBuilder("Processed:\n");
                this.handled.forEach((k, v) -> builder.append(' ').append(v.getLeft()).append('\t').append((String)k).append(" / latest: ").append((String)v.getRight()).append('\n'));
                this.setStatus(builder.toString());
            }
        }
    }

    public boolean wasInterruptRequested() {
        return this.interrupt;
    }

    public void setInterrupted() {
        this.interrupted = true;
    }

    protected void setGroupOwners(GroupPullResultHandler ghandler) {
        ghandler.getGroupOwnerMap().forEach((groupKey, ownerKey) -> {
            Group group = (Group)this.groupDAO.find(groupKey);
            if (group == null) {
                throw new NotFoundException("Group " + groupKey);
            }
            if (StringUtils.isBlank((CharSequence)ownerKey)) {
                group.setGroupOwner(null);
                group.setUserOwner(null);
            } else {
                Optional<PullMatch> match = this.inboundMatcher.match(this.anyTypeDAO.findUser(), (String)ownerKey, ((PullTask)this.profile.getTask()).getResource(), this.profile.getConnector());
                if (match.isPresent()) {
                    group.setUserOwner((User)match.get().getAny());
                } else {
                    this.inboundMatcher.match(this.anyTypeDAO.findGroup(), (String)ownerKey, ((PullTask)this.profile.getTask()).getResource(), this.profile.getConnector()).ifPresent(groupMatch -> group.setGroupOwner((Group)groupMatch.getAny()));
                }
            }
            this.groupDAO.save((Any)group);
        });
    }

    protected List<PullActions> getPullActions(List<? extends Implementation> impls) {
        ArrayList<PullActions> result = new ArrayList<PullActions>();
        impls.forEach(impl -> {
            try {
                result.add((PullActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (PullActions)instance)));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    protected ReconFilterBuilder getReconFilterBuilder(PullTask pullTask) throws ClassNotFoundException {
        return (ReconFilterBuilder)ImplementationManager.build((Implementation)pullTask.getReconFilterBuilder(), () -> this.perContextReconFilterBuilder.orElse(null), instance -> {
            this.perContextReconFilterBuilder = Optional.of(instance);
        });
    }

    protected RealmPullResultHandler buildRealmHandler() {
        return (RealmPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultRealmPullResultHandler.class, 1, false);
    }

    protected AnyObjectPullResultHandler buildAnyObjectHandler() {
        return (AnyObjectPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultAnyObjectPullResultHandler.class, 1, false);
    }

    protected UserPullResultHandler buildUserHandler() {
        return (UserPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultUserPullResultHandler.class, 1, false);
    }

    protected GroupPullResultHandler buildGroupHandler() {
        return (GroupPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultGroupPullResultHandler.class, 1, false);
    }

    @Override
    protected String doExecuteProvisioning(PullTask pullTask, Connector connector, boolean dryRun, String executor, JobExecutionContext context) throws JobExecutionException {
        LOG.debug("Executing pull on {}", (Object)pullTask.getResource());
        this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pullTask);
        this.profile.getActions().addAll(this.getPullActions(pullTask.getActions()));
        this.profile.setDryRun(dryRun);
        this.profile.setConflictResolutionAction(Optional.ofNullable(pullTask.getResource().getPullPolicy()).map(ProvisioningPolicy::getConflictResolutionAction).orElse(ConflictResolutionAction.IGNORE));
        this.profile.setExecutor(executor);
        PullResultHandlerDispatcher dispatcher = new PullResultHandlerDispatcher(this.profile, this);
        this.latestSyncTokens.clear();
        if (!this.profile.isDryRun()) {
            for (PullActions action : this.profile.getActions()) {
                action.beforeAll(this.profile);
            }
        }
        this.setStatus("Initialization completed");
        if (pullTask.getResource().getOrgUnit() != null) {
            this.setStatus("Pulling " + pullTask.getResource().getOrgUnit().getObjectClass());
            OrgUnit orgUnit = pullTask.getResource().getOrgUnit();
            HashSet moreAttrsToGet = new HashSet();
            this.profile.getActions().forEach(a -> moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, orgUnit)));
            OperationOptions options = MappingUtils.buildOperationOptions(MappingUtils.getPullItems(orgUnit.getItems().stream()), (String[])moreAttrsToGet.toArray(String[]::new));
            dispatcher.addHandlerSupplier(orgUnit.getObjectClass(), () -> {
                RealmPullResultHandler handler = this.buildRealmHandler();
                handler.setProfile(this.profile);
                return handler;
            });
            try {
                switch (pullTask.getPullMode()) {
                    case INCREMENTAL: {
                        if (!dryRun) {
                            this.latestSyncTokens.put(orgUnit.getObjectClass(), ConnObjectUtils.toSyncToken(orgUnit.getSyncToken()));
                        }
                        connector.sync(new ObjectClass(orgUnit.getObjectClass()), ConnObjectUtils.toSyncToken(orgUnit.getSyncToken()), (SyncResultsHandler)dispatcher, options);
                        if (!dryRun) {
                            orgUnit.setSyncToken(ConnObjectUtils.toString(this.latestSyncTokens.get(orgUnit.getObjectClass())));
                            this.resourceDAO.save(pullTask.getResource());
                        }
                        break;
                    }
                    case FILTERED_RECONCILIATION: {
                        connector.filteredReconciliation(new ObjectClass(orgUnit.getObjectClass()), this.getReconFilterBuilder(pullTask), (SyncResultsHandler)dispatcher, options);
                        break;
                    }
                    default: {
                        connector.fullReconciliation(new ObjectClass(orgUnit.getObjectClass()), (SyncResultsHandler)dispatcher, options);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                throw new JobExecutionException("While pulling from connector", t);
            }
        }
        ProvisionSorter provisionSorter = this.getProvisionSorter(pullTask);
        GroupPullResultHandler ghandler = this.buildGroupHandler();
        for (Provision provision2 : pullTask.getResource().getProvisions().stream().filter(provision -> provision.getMapping() != null).sorted((Comparator<Provision>)provisionSorter).collect(Collectors.toList())) {
            this.setStatus("Pulling " + provision2.getObjectClass());
            AnyType anyType = this.anyTypeDAO.find(provision2.getAnyType());
            dispatcher.addHandlerSupplier(provision2.getObjectClass(), () -> {
                GroupPullResultHandler handler;
                switch (anyType.getKind()) {
                    case USER: {
                        handler = this.buildUserHandler();
                        break;
                    }
                    case GROUP: {
                        handler = ghandler;
                        break;
                    }
                    default: {
                        handler = this.buildAnyObjectHandler();
                    }
                }
                handler.setProfile(this.profile);
                return handler;
            });
            boolean setSyncTokens = false;
            try {
                HashSet moreAttrsToGet = new HashSet();
                this.profile.getActions().forEach(a -> moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, provision2)));
                Stream<Item> mapItems = Stream.concat(MappingUtils.getPullItems(provision2.getMapping().getItems().stream()), this.virSchemaDAO.find(pullTask.getResource().getKey(), anyType.getKey()).stream().map(VirSchema::asLinkingMappingItem));
                OperationOptions options = MappingUtils.buildOperationOptions(mapItems, (String[])moreAttrsToGet.toArray(String[]::new));
                switch (pullTask.getPullMode()) {
                    case INCREMENTAL: {
                        if (!dryRun) {
                            this.latestSyncTokens.put(provision2.getObjectClass(), ConnObjectUtils.toSyncToken(provision2.getSyncToken()));
                        }
                        connector.sync(new ObjectClass(provision2.getObjectClass()), ConnObjectUtils.toSyncToken(provision2.getSyncToken()), (SyncResultsHandler)dispatcher, options);
                        if (dryRun) break;
                        setSyncTokens = true;
                        break;
                    }
                    case FILTERED_RECONCILIATION: {
                        connector.filteredReconciliation(new ObjectClass(provision2.getObjectClass()), this.getReconFilterBuilder(pullTask), (SyncResultsHandler)dispatcher, options);
                        break;
                    }
                    default: {
                        connector.fullReconciliation(new ObjectClass(provision2.getObjectClass()), (SyncResultsHandler)dispatcher, options);
                    }
                }
                if (provision2.getUidOnCreate() == null) continue;
                AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
                this.profile.getResults().stream().filter(result -> result.getUidValue() != null && result.getKey() != null && result.getOperation() == ResourceOperation.CREATE && result.getAnyType().equals(provision2.getAnyType())).forEach(result -> anyUtils.addAttr(this.validator, result.getKey(), (PlainSchema)this.plainSchemaDAO.find(provision2.getUidOnCreate()), result.getUidValue()));
            }
            catch (Throwable t) {
                throw new JobExecutionException("While pulling from connector", t);
            }
            finally {
                if (!setSyncTokens) continue;
                this.latestSyncTokens.forEach((objectClass, syncToken) -> pullTask.getResource().getProvisionByObjectClass(objectClass).ifPresent(p -> p.setSyncToken(ConnObjectUtils.toString(syncToken))));
                this.resourceDAO.save(pullTask.getResource());
            }
        }
        try {
            this.setGroupOwners(ghandler);
        }
        catch (Exception e) {
            LOG.error("While setting group owners", (Throwable)e);
        }
        if (!this.profile.isDryRun()) {
            for (PullActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
        }
        dispatcher.cleanup();
        this.setStatus("Pull done");
        String result2 = this.createReport(this.profile.getResults(), pullTask.getResource(), dryRun);
        LOG.debug("Pull result: {}", (Object)result2);
        return result2;
    }
}

