/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.time.temporal.TemporalAccessor;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.report.StaticReportletConf;
import org.apache.syncope.core.persistence.api.dao.ReportletConfClass;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.apache.syncope.core.provisioning.java.job.report.AbstractReportlet;
import org.apache.syncope.core.provisioning.java.job.report.ReportException;
import org.springframework.util.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@ReportletConfClass(value=StaticReportletConf.class)
public class StaticReportlet
extends AbstractReportlet {
    private StaticReportletConf conf;

    private static void doExtractConf(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        handler.startElement("", "", "configurations", null);
        handler.startElement("", "", "staticAttributes", atts);
        handler.startElement("", "", "string", atts);
        handler.characters("string".toCharArray(), 0, "string".length());
        handler.endElement("", "", "string");
        handler.startElement("", "", "long", atts);
        handler.characters("long".toCharArray(), 0, "long".length());
        handler.endElement("", "", "long");
        handler.startElement("", "", "double", atts);
        handler.characters("double".toCharArray(), 0, "double".length());
        handler.endElement("", "", "double");
        handler.startElement("", "", "date", atts);
        handler.characters("date".toCharArray(), 0, "date".length());
        handler.endElement("", "", "date");
        handler.startElement("", "", "double", atts);
        handler.characters("double".toCharArray(), 0, "double".length());
        handler.endElement("", "", "double");
        handler.startElement("", "", "enum", atts);
        handler.characters("enum".toCharArray(), 0, "enum".length());
        handler.endElement("", "", "enum");
        handler.startElement("", "", "list", atts);
        handler.characters("list".toCharArray(), 0, "list".length());
        handler.endElement("", "", "list");
        handler.endElement("", "", "staticAttributes");
        handler.endElement("", "", "configurations");
    }

    @Override
    protected void doExtract(ReportletConf conf, ContentHandler handler, String refDesc) throws SAXException {
        String printed;
        if (!(conf instanceof StaticReportletConf)) {
            throw new ReportException(new IllegalArgumentException("Invalid configuration provided"));
        }
        this.conf = (StaticReportletConf)StaticReportletConf.class.cast(conf);
        StaticReportlet.doExtractConf(handler);
        if (StringUtils.hasText((String)this.conf.getStringField())) {
            handler.startElement("", "", "string", null);
            handler.characters(this.conf.getStringField().toCharArray(), 0, this.conf.getStringField().length());
            handler.endElement("", "", "string");
        }
        if (this.conf.getLongField() != null) {
            handler.startElement("", "", "long", null);
            printed = String.valueOf(this.conf.getLongField());
            handler.characters(printed.toCharArray(), 0, printed.length());
            handler.endElement("", "", "long");
        }
        if (this.conf.getDoubleField() != null) {
            handler.startElement("", "", "double", null);
            printed = String.valueOf(this.conf.getDoubleField());
            handler.characters(printed.toCharArray(), 0, printed.length());
            handler.endElement("", "", "double");
        }
        if (this.conf.getDateField() != null) {
            handler.startElement("", "", "date", null);
            printed = FormatUtils.format((TemporalAccessor)this.conf.getDateField());
            handler.characters(printed.toCharArray(), 0, printed.length());
            handler.endElement("", "", "date");
        }
        if (this.conf.getTraceLevel() != null) {
            handler.startElement("", "", "enum", null);
            printed = this.conf.getTraceLevel().name();
            handler.characters(printed.toCharArray(), 0, printed.length());
            handler.endElement("", "", "enum");
        }
        if (this.conf.getListField() != null && !this.conf.getListField().isEmpty()) {
            handler.startElement("", "", "list", null);
            for (String item : this.conf.getListField()) {
                if (!StringUtils.hasText((String)item)) continue;
                handler.startElement("", "", "string", null);
                handler.characters(item.toCharArray(), 0, item.length());
                handler.endElement("", "", "string");
            }
            handler.endElement("", "", "list");
        }
    }
}

