/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ApplicationDAO;
import org.apache.syncope.core.persistence.api.dao.AttrRepoDAO;
import org.apache.syncope.core.persistence.api.dao.AuditConfDAO;
import org.apache.syncope.core.persistence.api.dao.AuthModuleDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.dao.MailTemplateDAO;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.dao.ReportTemplateDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.WAConfigDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.api.data.AnyTypeClassDataBinder;
import org.apache.syncope.core.provisioning.api.data.AnyTypeDataBinder;
import org.apache.syncope.core.provisioning.api.data.ApplicationDataBinder;
import org.apache.syncope.core.provisioning.api.data.AttrRepoDataBinder;
import org.apache.syncope.core.provisioning.api.data.AuditDataBinder;
import org.apache.syncope.core.provisioning.api.data.AuthModuleDataBinder;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;
import org.apache.syncope.core.provisioning.api.data.ClientAppDataBinder;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.apache.syncope.core.provisioning.api.data.DelegationDataBinder;
import org.apache.syncope.core.provisioning.api.data.DynRealmDataBinder;
import org.apache.syncope.core.provisioning.api.data.FIQLQueryDataBinder;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.data.ImplementationDataBinder;
import org.apache.syncope.core.provisioning.api.data.NotificationDataBinder;
import org.apache.syncope.core.provisioning.api.data.OIDCJWKSDataBinder;
import org.apache.syncope.core.provisioning.api.data.PolicyDataBinder;
import org.apache.syncope.core.provisioning.api.data.RealmDataBinder;
import org.apache.syncope.core.provisioning.api.data.RelationshipTypeDataBinder;
import org.apache.syncope.core.provisioning.api.data.RemediationDataBinder;
import org.apache.syncope.core.provisioning.api.data.ReportDataBinder;
import org.apache.syncope.core.provisioning.api.data.ResourceDataBinder;
import org.apache.syncope.core.provisioning.api.data.RoleDataBinder;
import org.apache.syncope.core.provisioning.api.data.SAML2IdPEntityDataBinder;
import org.apache.syncope.core.provisioning.api.data.SAML2SPEntityDataBinder;
import org.apache.syncope.core.provisioning.api.data.SRARouteDataBinder;
import org.apache.syncope.core.provisioning.api.data.SchemaDataBinder;
import org.apache.syncope.core.provisioning.api.data.SecurityQuestionDataBinder;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.data.WAConfigDataBinder;
import org.apache.syncope.core.provisioning.api.data.wa.WAClientAppDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.job.report.ReportJobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationJobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.AsyncConnectorFacade;
import org.apache.syncope.core.provisioning.java.ConnectorLoader;
import org.apache.syncope.core.provisioning.java.DefaultAnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.java.DefaultAuditManager;
import org.apache.syncope.core.provisioning.java.DefaultConnIdBundleManager;
import org.apache.syncope.core.provisioning.java.DefaultConnectorManager;
import org.apache.syncope.core.provisioning.java.DefaultDerAttrHandler;
import org.apache.syncope.core.provisioning.java.DefaultGroupProvisioningManager;
import org.apache.syncope.core.provisioning.java.DefaultMappingManager;
import org.apache.syncope.core.provisioning.java.DefaultUserProvisioningManager;
import org.apache.syncope.core.provisioning.java.DefaultVirAttrHandler;
import org.apache.syncope.core.provisioning.java.ProvisioningProperties;
import org.apache.syncope.core.provisioning.java.cache.CaffeineVirAttrCache;
import org.apache.syncope.core.provisioning.java.data.AccessTokenDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AnyObjectDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AnyTypeClassDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AnyTypeDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.ApplicationDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AttrRepoDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AuditDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AuthModuleDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.AuthProfileDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.ClientAppDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.ConnInstanceDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.DelegationDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.DynRealmDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.FIQLQueryDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.GroupDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.ImplementationDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.NotificationDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.OIDCJWKSDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.PolicyDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.RealmDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.RelationshipTypeDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.RemediationDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.ReportDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.ResourceDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.RoleDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.SAML2IdPEntityDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.SAML2SPEntityDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.SRARouteDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.SchemaDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.SecurityQuestionDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.TaskDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.UserDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.WAConfigDataBinderImpl;
import org.apache.syncope.core.provisioning.java.data.wa.WAClientAppDataBinderImpl;
import org.apache.syncope.core.provisioning.java.job.DefaultJobManager;
import org.apache.syncope.core.provisioning.java.job.JobStatusUpdater;
import org.apache.syncope.core.provisioning.java.job.SchedulerDBInit;
import org.apache.syncope.core.provisioning.java.job.SyncopeSpringBeanJobFactory;
import org.apache.syncope.core.provisioning.java.job.SystemLoadReporterJob;
import org.apache.syncope.core.provisioning.java.job.notification.DefaultNotificationJobDelegate;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.apache.syncope.core.provisioning.java.job.report.DefaultReportJobDelegate;
import org.apache.syncope.core.provisioning.java.notification.DefaultNotificationManager;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationManager;
import org.apache.syncope.core.provisioning.java.propagation.PriorityPropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.jws.AccessTokenJWSSigner;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.apache.syncope.core.workflow.api.GroupWorkflowAdapter;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.support.TaskExecutorAdapter;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@EnableAsync
@EnableConfigurationProperties(value={ProvisioningProperties.class})
@Configuration(proxyBeanMethods=false)
public class ProvisioningContext {
    @Resource(name="MasterDataSource")
    private DataSource masterDataSource;
    @Resource(name="MasterTransactionManager")
    private PlatformTransactionManager masterTransactionManager;

    @ConditionalOnMissingBean
    @Bean
    public AsyncConnectorFacade asyncConnectorFacade() {
        return new AsyncConnectorFacade();
    }

    @Bean
    @Primary
    public ThreadPoolTaskExecutor asyncConnectorFacadeExecutor(ProvisioningProperties props) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(props.getAsyncConnectorFacadeExecutor().getCorePoolSize());
        executor.setMaxPoolSize(props.getAsyncConnectorFacadeExecutor().getMaxPoolSize());
        executor.setQueueCapacity(props.getAsyncConnectorFacadeExecutor().getQueueCapacity());
        executor.setAwaitTerminationSeconds(props.getAsyncConnectorFacadeExecutor().getAwaitTerminationSeconds());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setThreadNamePrefix("AsyncConnectorFacadeExecutor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        executor.initialize();
        return executor;
    }

    @Bean
    public AsyncConfigurer asyncConfigurer(final @Qualifier(value="asyncConnectorFacadeExecutor") ThreadPoolTaskExecutor asyncConnectorFacadeExecutor) {
        return new AsyncConfigurer(){

            public Executor getAsyncExecutor() {
                return asyncConnectorFacadeExecutor;
            }
        };
    }

    @Bean
    public AsyncTaskExecutor jobStatusUpdaterThreadExecutor() {
        return new TaskExecutorAdapter((Executor)Executors.newSingleThreadExecutor());
    }

    @Bean
    public ThreadPoolTaskExecutor propagationTaskExecutorAsyncExecutor(ProvisioningProperties props) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(props.getPropagationTaskExecutorAsyncExecutor().getCorePoolSize());
        executor.setMaxPoolSize(props.getPropagationTaskExecutorAsyncExecutor().getMaxPoolSize());
        executor.setQueueCapacity(props.getPropagationTaskExecutorAsyncExecutor().getQueueCapacity());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setAwaitTerminationSeconds(props.getPropagationTaskExecutorAsyncExecutor().getAwaitTerminationSeconds());
        executor.setThreadNamePrefix("PropagationTaskExecutor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        executor.initialize();
        return executor;
    }

    @Bean
    public SchedulerDBInit quartzDataSourceInit(ProvisioningProperties provisioningProperties) {
        SchedulerDBInit init = new SchedulerDBInit();
        init.setDataSource(this.masterDataSource);
        ResourceDatabasePopulator databasePopulator = new ResourceDatabasePopulator();
        databasePopulator.setContinueOnError(true);
        databasePopulator.setIgnoreFailedDrops(true);
        databasePopulator.setSqlScriptEncoding(StandardCharsets.UTF_8.name());
        databasePopulator.setScripts(new org.springframework.core.io.Resource[]{new ClassPathResource("/quartz/" + provisioningProperties.getQuartz().getSql())});
        init.setDatabasePopulator((DatabasePopulator)databasePopulator);
        return init;
    }

    @DependsOn(value={"quartzDataSourceInit"})
    @Lazy(value=false)
    @Bean
    public SchedulerFactoryBean scheduler(ApplicationContext ctx, ProvisioningProperties props) {
        SchedulerFactoryBean scheduler = new SchedulerFactoryBean();
        scheduler.setAutoStartup(true);
        scheduler.setApplicationContext(ctx);
        scheduler.setWaitForJobsToCompleteOnShutdown(props.getQuartz().isWaitForJobsToCompleteOnShutdown());
        scheduler.setOverwriteExistingJobs(true);
        scheduler.setDataSource(this.masterDataSource);
        scheduler.setTransactionManager(this.masterTransactionManager);
        scheduler.setJobFactory((JobFactory)new SyncopeSpringBeanJobFactory());
        Properties quartzProperties = new Properties();
        quartzProperties.setProperty("org.quartz.scheduler.idleWaitTime", String.valueOf(props.getQuartz().getIdleWaitTime()));
        quartzProperties.setProperty("org.quartz.jobStore.misfireThreshold", String.valueOf(props.getQuartz().getMisfireThreshold()));
        quartzProperties.setProperty("org.quartz.jobStore.driverDelegateClass", props.getQuartz().getDelegate().getName());
        quartzProperties.setProperty("org.quartz.jobStore.class", "org.springframework.scheduling.quartz.LocalDataSourceJobStore");
        quartzProperties.setProperty("org.quartz.threadPool.makeThreadsDaemons", "true");
        quartzProperties.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
        quartzProperties.setProperty("org.quartz.jobStore.isClustered", "true");
        quartzProperties.setProperty("org.quartz.jobStore.clusterCheckinInterval", "20000");
        quartzProperties.setProperty("org.quartz.scheduler.instanceName", "SyncopeClusteredScheduler");
        quartzProperties.setProperty("org.quartz.scheduler.instanceId", "AUTO");
        quartzProperties.setProperty("org.quartz.scheduler.jmx.export", "true");
        scheduler.setQuartzProperties(quartzProperties);
        return scheduler;
    }

    @ConditionalOnMissingBean
    @Bean
    public JobManager jobManager(ProvisioningProperties provisioningProperties, DomainHolder domainHolder, SecurityProperties securityProperties, SchedulerFactoryBean scheduler, TaskDAO taskDAO, ReportDAO reportDAO, ImplementationDAO implementationDAO, TaskUtilsFactory taskUtilsFactory, ConfParamOps confParamOps) {
        DefaultJobManager jobManager = new DefaultJobManager(domainHolder, scheduler, taskDAO, reportDAO, implementationDAO, taskUtilsFactory, confParamOps, securityProperties);
        jobManager.setDisableQuartzInstance(provisioningProperties.getQuartz().isDisableInstance());
        return jobManager;
    }

    @ConditionalOnMissingBean
    @Bean
    public JobStatusUpdater jobStatusUpdater(JobStatusDAO jobStatusDAO, EntityFactory entityFactory) {
        return new JobStatusUpdater(jobStatusDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnectorManager connectorManager(EntityFactory entityFactory, ConnIdBundleManager connIdBundleManager, RealmDAO realmDAO, ExternalResourceDAO resourceDAO, ConnInstanceDataBinder connInstanceDataBinder, AsyncConnectorFacade asyncConnectorFacade) {
        return new DefaultConnectorManager(connIdBundleManager, realmDAO, resourceDAO, connInstanceDataBinder, asyncConnectorFacade, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnectorLoader connectorLoader(ConnectorManager connectorManager) {
        return new ConnectorLoader(connectorManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public InboundMatcher inboundMatcher(AnyUtilsFactory anyUtilsFactory, UserDAO userDAO, AnyObjectDAO anyObjectDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, RealmDAO realmDAO, VirSchemaDAO virSchemaDAO, ImplementationDAO implementationDAO, VirAttrHandler virAttrHandler, IntAttrNameParser intAttrNameParser) {
        return new InboundMatcher(userDAO, anyObjectDAO, groupDAO, anySearchDAO, realmDAO, virSchemaDAO, implementationDAO, virAttrHandler, intAttrNameParser, anyUtilsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public OutboundMatcher outboundMatcher(AnyUtilsFactory anyUtilsFactory, MappingManager mappingManager, UserDAO userDAO, VirSchemaDAO virSchemaDAO, VirAttrHandler virAttrHandler) {
        return new OutboundMatcher(mappingManager, userDAO, anyUtilsFactory, virSchemaDAO, virAttrHandler);
    }

    @ConditionalOnMissingBean
    @Bean
    public DerAttrHandler derAttrHandler(AnyUtilsFactory anyUtilsFactory) {
        return new DefaultDerAttrHandler(anyUtilsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public VirAttrHandler virAttrHandler(AnyUtilsFactory anyUtilsFactory, ConnectorManager connectorManager, VirAttrCache virAttrCache, @Lazy OutboundMatcher outboundMatcher) {
        return new DefaultVirAttrHandler(connectorManager, virAttrCache, outboundMatcher, anyUtilsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public MappingManager mappingManager(PasswordGenerator passwordGenerator, AnyUtilsFactory anyUtilsFactory, AnyTypeDAO anyTypeDAO, UserDAO userDAO, AnyObjectDAO anyObjectDAO, GroupDAO groupDAO, RelationshipTypeDAO relationshipTypeDAO, RealmDAO realmDAO, ApplicationDAO applicationDAO, ImplementationDAO implementationDAO, DerAttrHandler derAttrHandler, VirAttrHandler virAttrHandler, VirAttrCache virAttrCache, IntAttrNameParser intAttrNameParser) {
        return new DefaultMappingManager(anyTypeDAO, userDAO, anyObjectDAO, groupDAO, relationshipTypeDAO, realmDAO, applicationDAO, implementationDAO, derAttrHandler, virAttrHandler, virAttrCache, passwordGenerator, anyUtilsFactory, intAttrNameParser);
    }

    @ConditionalOnMissingBean
    @Bean
    public TemplateUtils templateUtils(UserDAO userDAO, GroupDAO groupDAO) {
        return new TemplateUtils(userDAO, groupDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnObjectUtils connObjectUtils(PasswordGenerator passwordGenerator, AnyUtilsFactory anyUtilsFactory, MappingManager mappingManager, TemplateUtils templateUtils, RealmDAO realmDAO, UserDAO userDAO, ExternalResourceDAO resourceDAO) {
        return new ConnObjectUtils(templateUtils, realmDAO, userDAO, resourceDAO, passwordGenerator, mappingManager, anyUtilsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public PropagationManager propagationManager(EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, VirSchemaDAO virSchemaDAO, ExternalResourceDAO resourceDAO, ConnObjectUtils connObjectUtils, MappingManager mappingManager, DerAttrHandler derAttrHandler) {
        return new DefaultPropagationManager(virSchemaDAO, resourceDAO, entityFactory, connObjectUtils, mappingManager, derAttrHandler, anyUtilsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnIdBundleManager connIdBundleManager(ProvisioningProperties provisioningProperties) {
        return new DefaultConnIdBundleManager(provisioningProperties.getConnIdLocation());
    }

    @ConditionalOnMissingBean
    @Bean
    public IntAttrNameParser intAttrNameParser(AnyUtilsFactory anyUtilsFactory, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO) {
        return new IntAttrNameParser(plainSchemaDAO, derSchemaDAO, virSchemaDAO, anyUtilsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public PropagationTaskExecutor propagationTaskExecutor(@Qualifier(value="propagationTaskExecutorAsyncExecutor") ThreadPoolTaskExecutor propagationTaskExecutorAsyncExecutor, TaskUtilsFactory taskUtilsFactory, AnyUtilsFactory anyUtilsFactory, ConnectorManager connectorManager, ConnObjectUtils connObjectUtils, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, TaskDAO taskDAO, ExternalResourceDAO resourceDAO, PlainSchemaDAO plainSchemaDAO, NotificationManager notificationManager, AuditManager auditManager, TaskDataBinder taskDataBinder, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator) {
        return new PriorityPropagationTaskExecutor(connectorManager, connObjectUtils, userDAO, groupDAO, anyObjectDAO, taskDAO, resourceDAO, plainSchemaDAO, notificationManager, auditManager, taskDataBinder, anyUtilsFactory, taskUtilsFactory, outboundMatcher, validator, propagationTaskExecutorAsyncExecutor);
    }

    @ConditionalOnMissingBean
    @Bean
    public UserProvisioningManager userProvisioningManager(UserWorkflowAdapter uwfAdapter, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor, UserDAO userDAO, VirAttrHandler virtAttrHandler) {
        return new DefaultUserProvisioningManager(uwfAdapter, propagationManager, taskExecutor, userDAO, virtAttrHandler);
    }

    @ConditionalOnMissingBean
    @Bean
    public GroupProvisioningManager groupProvisioningManager(GroupWorkflowAdapter gwfAdapter, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor, GroupDataBinder groupDataBinder, GroupDAO groupDAO, VirAttrHandler virtAttrHandler) {
        return new DefaultGroupProvisioningManager(gwfAdapter, propagationManager, taskExecutor, groupDataBinder, groupDAO, virtAttrHandler);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyObjectProvisioningManager anyObjectProvisioningManager(AnyObjectWorkflowAdapter awfAdapter, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor, AnyObjectDAO anyObjectDAO, VirAttrHandler virtAttrHandler) {
        return new DefaultAnyObjectProvisioningManager(awfAdapter, propagationManager, taskExecutor, anyObjectDAO, virtAttrHandler);
    }

    @ConditionalOnMissingBean
    @Bean
    public VirAttrCache virAttrCache(ProvisioningProperties provisioningProperties) {
        CaffeineVirAttrCache virAttrCache = new CaffeineVirAttrCache();
        virAttrCache.setCacheSpec(provisioningProperties.getVirAttrCacheSpec());
        return virAttrCache;
    }

    @ConditionalOnMissingBean
    @Bean
    public NotificationManager notificationManager(EntityFactory entityFactory, SearchCondVisitor searchCondVisitor, DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, NotificationDAO notificationDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, AnyMatchDAO anyMatchDAO, TaskDAO taskDAO, UserDataBinder userDataBinder, GroupDataBinder groupDataBinder, AnyObjectDataBinder anyObjectDataBinder, ConfParamOps confParamOps, DerAttrHandler derAttrHandler, VirAttrHandler virAttrHandler, IntAttrNameParser intAttrNameParser) {
        return new DefaultNotificationManager(derSchemaDAO, virSchemaDAO, notificationDAO, anyObjectDAO, userDAO, groupDAO, anySearchDAO, anyMatchDAO, taskDAO, derAttrHandler, virAttrHandler, userDataBinder, groupDataBinder, anyObjectDataBinder, confParamOps, entityFactory, intAttrNameParser, searchCondVisitor);
    }

    @ConditionalOnMissingBean
    @Bean
    public AuditManager auditManager(AuditConfDAO auditConfDAO) {
        return new DefaultAuditManager(auditConfDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public SystemLoadReporterJob systemLoadReporterJob(ApplicationContext ctx) {
        return new SystemLoadReporterJob((ApplicationEventPublisher)ctx);
    }

    @ConditionalOnMissingBean
    @Bean
    public NotificationJobDelegate notificationJobDelegate(TaskUtilsFactory taskUtilsFactory, TaskDAO taskDAO, JavaMailSender mailSender, AuditManager auditManager, NotificationManager notificationManager, ApplicationEventPublisher publisher) {
        return new DefaultNotificationJobDelegate(taskDAO, mailSender, taskUtilsFactory, auditManager, notificationManager, publisher);
    }

    @ConditionalOnMissingBean
    @Bean
    public NotificationJob notificationJob(NotificationJobDelegate delegate, DomainHolder domainHolder, SecurityProperties securityProperties) {
        return new NotificationJob(securityProperties, domainHolder, delegate);
    }

    @ConditionalOnMissingBean
    @Bean
    public ReportJobDelegate reportJobDelegate(ReportDAO reportDAO, ReportExecDAO reportExecDAO, EntityFactory entityFactory, ReportDataBinder reportDataBinder, ApplicationEventPublisher publisher) {
        return new DefaultReportJobDelegate(reportDAO, reportExecDAO, entityFactory, reportDataBinder, publisher);
    }

    @ConditionalOnMissingBean
    @Bean
    public AccessTokenDataBinder accessTokenDataBinder(EntityFactory entityFactory, SecurityProperties securityProperties, AccessTokenJWSSigner jwsSigner, AccessTokenDAO accessTokenDAO, ConfParamOps confParamOps, DefaultCredentialChecker credentialChecker) {
        return new AccessTokenDataBinderImpl(securityProperties, jwsSigner, accessTokenDAO, confParamOps, entityFactory, credentialChecker);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyObjectDataBinder anyObjectDataBinder(EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, AnyTypeDAO anyTypeDAO, RealmDAO realmDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, PlainAttrDAO plainAttrDAO, PlainAttrValueDAO plainAttrValueDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, DerAttrHandler derAttrHandler, VirAttrHandler virAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator) {
        return new AnyObjectDataBinderImpl(anyTypeDAO, realmDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, plainAttrDAO, plainAttrValueDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, virAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, validator);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyTypeClassDataBinder anyTypeClassDataBinder(EntityFactory entityFactory, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, AnyTypeDAO anyTypeDAO) {
        return new AnyTypeClassDataBinderImpl(plainSchemaDAO, derSchemaDAO, virSchemaDAO, anyTypeDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyTypeDataBinder anyTypeDataBinder(EntityFactory entityFactory, SecurityProperties securityProperties, AnyTypeDAO anyTypeDAO, AnyTypeClassDAO anyTypeClassDAO, AccessTokenDAO accessTokenDAO) {
        return new AnyTypeDataBinderImpl(securityProperties, anyTypeDAO, anyTypeClassDAO, accessTokenDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public ApplicationDataBinder applicationDataBinder(ApplicationDAO applicationDAO, EntityFactory entityFactory) {
        return new ApplicationDataBinderImpl(applicationDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public AuditDataBinder auditDataBinder() {
        return new AuditDataBinderImpl();
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthModuleDataBinder authModuleDataBinder(EntityFactory entityFactory) {
        return new AuthModuleDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public AttrRepoDataBinder attrRepoDataBinder(EntityFactory entityFactory) {
        return new AttrRepoDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthProfileDataBinder authProfileDataBinder(EntityFactory entityFactory) {
        return new AuthProfileDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public ClientAppDataBinder clientAppDataBinder(PolicyDAO policyDAO, RealmDAO realmDAO, EntityFactory entityFactory) {
        return new ClientAppDataBinderImpl(policyDAO, realmDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConnInstanceDataBinder connInstanceDataBinder(EntityFactory entityFactory, ConnIdBundleManager connIdBundleManager, ConnInstanceDAO connInstanceDAO, RealmDAO realmDAO) {
        return new ConnInstanceDataBinderImpl(connIdBundleManager, connInstanceDAO, realmDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public DelegationDataBinder delegationDataBinder(UserDAO userDAO, RoleDAO roleDAO, EntityFactory entityFactory) {
        return new DelegationDataBinderImpl(userDAO, roleDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public FIQLQueryDataBinder fiqlQueryDataBinder(SearchCondVisitor searchCondVisitor, UserDAO userDAO, EntityFactory entityFactory) {
        return new FIQLQueryDataBinderImpl(searchCondVisitor, userDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public DynRealmDataBinder dynRealmDataBinder(AnyTypeDAO anyTypeDAO, DynRealmDAO dynRealmDAO, SearchCondVisitor searchCondVisitor, EntityFactory entityFactory) {
        return new DynRealmDataBinderImpl(anyTypeDAO, dynRealmDAO, entityFactory, searchCondVisitor);
    }

    @ConditionalOnMissingBean
    @Bean
    public GroupDataBinder groupDataBinder(EntityFactory entityFactory, SearchCondVisitor searchCondVisitor, AnyUtilsFactory anyUtilsFactory, AnyTypeDAO anyTypeDAO, RealmDAO realmDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, PlainAttrDAO plainAttrDAO, PlainAttrValueDAO plainAttrValueDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, DerAttrHandler derAttrHandler, VirAttrHandler virAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator) {
        return new GroupDataBinderImpl(anyTypeDAO, realmDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, plainAttrDAO, plainAttrValueDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, virAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, searchCondVisitor, validator);
    }

    @ConditionalOnMissingBean
    @Bean
    public ImplementationDataBinder implementationDataBinder(EntityFactory entityFactory) {
        return new ImplementationDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public NotificationDataBinder notificationDataBinder(EntityFactory entityFactory, MailTemplateDAO mailTemplateDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, IntAttrNameParser intAttrNameParser) {
        return new NotificationDataBinderImpl(mailTemplateDAO, anyTypeDAO, implementationDAO, entityFactory, intAttrNameParser);
    }

    @ConditionalOnMissingBean
    @Bean
    public OIDCJWKSDataBinder oidcJWKSDataBinder(EntityFactory entityFactory) {
        return new OIDCJWKSDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public PolicyDataBinder policyDataBinder(EntityFactory entityFactory, ExternalResourceDAO resourceDAO, RealmDAO realmDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO) {
        return new PolicyDataBinderImpl(resourceDAO, realmDAO, anyTypeDAO, implementationDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public RealmDataBinder realmDataBinder(EntityFactory entityFactory, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, RealmDAO realmDAO, PolicyDAO policyDAO, ExternalResourceDAO resourceDAO) {
        return new RealmDataBinderImpl(anyTypeDAO, implementationDAO, realmDAO, policyDAO, resourceDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public RelationshipTypeDataBinder relationshipTypeDataBinder(EntityFactory entityFactory) {
        return new RelationshipTypeDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public RemediationDataBinder remediationDataBinder() {
        return new RemediationDataBinderImpl();
    }

    @ConditionalOnMissingBean
    @Bean
    public ReportDataBinder reportDataBinder(ReportTemplateDAO reportTemplateDAO, ReportExecDAO reportExecDAO, ImplementationDAO implementationDAO, SchedulerFactoryBean scheduler) {
        return new ReportDataBinderImpl(reportTemplateDAO, reportExecDAO, implementationDAO, scheduler);
    }

    @ConditionalOnMissingBean
    @Bean
    public ResourceDataBinder resourceDataBinder(EntityFactory entityFactory, AnyTypeDAO anyTypeDAO, ConnInstanceDAO connInstanceDAO, PolicyDAO policyDAO, VirSchemaDAO virSchemaDAO, AnyTypeClassDAO anyTypeClassDAO, ImplementationDAO implementationDAO, PlainSchemaDAO plainSchemaDAO, IntAttrNameParser intAttrNameParser, PropagationTaskExecutor propagationTaskExecutor) {
        return new ResourceDataBinderImpl(anyTypeDAO, connInstanceDAO, policyDAO, virSchemaDAO, anyTypeClassDAO, implementationDAO, plainSchemaDAO, entityFactory, intAttrNameParser, propagationTaskExecutor);
    }

    @ConditionalOnMissingBean
    @Bean
    public RoleDataBinder roleDataBinder(EntityFactory entityFactory, SearchCondVisitor searchCondVisitor, RealmDAO realmDAO, DynRealmDAO dynRealmDAO, RoleDAO roleDAO, ApplicationDAO applicationDAO) {
        return new RoleDataBinderImpl(realmDAO, dynRealmDAO, roleDAO, applicationDAO, entityFactory, searchCondVisitor);
    }

    @ConditionalOnMissingBean
    @Bean
    public SAML2IdPEntityDataBinder saml2IdPEntityDataBinder(EntityFactory entityFactory) {
        return new SAML2IdPEntityDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public SAML2SPEntityDataBinder saml2SPEntityDataBinder(EntityFactory entityFactory) {
        return new SAML2SPEntityDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public SRARouteDataBinder sraRouteDataBinder() {
        return new SRARouteDataBinderImpl();
    }

    @ConditionalOnMissingBean
    @Bean
    public SchemaDataBinder schemaDataBinder(EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, AnyTypeClassDAO anyTypeClassDAO, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, ExternalResourceDAO resourceDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO) {
        return new SchemaDataBinderImpl(anyTypeClassDAO, plainSchemaDAO, derSchemaDAO, virSchemaDAO, resourceDAO, anyTypeDAO, implementationDAO, entityFactory, anyUtilsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public SecurityQuestionDataBinder securityQuestionDataBinder(EntityFactory entityFactory) {
        return new SecurityQuestionDataBinderImpl(entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public TaskDataBinder taskDataBinder(EntityFactory entityFactory, TaskUtilsFactory taskUtilsFactory, RealmDAO realmDAO, ExternalResourceDAO resourceDAO, TaskExecDAO taskExecDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, SchedulerFactoryBean scheduler) {
        return new TaskDataBinderImpl(realmDAO, resourceDAO, taskExecDAO, anyTypeDAO, implementationDAO, entityFactory, scheduler, taskUtilsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public UserDataBinder userDataBinder(EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, SecurityProperties securityProperties, AnyTypeDAO anyTypeDAO, RealmDAO realmDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, PlainAttrDAO plainAttrDAO, PlainAttrValueDAO plainAttrValueDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, DerAttrHandler derAttrHandler, VirAttrHandler virAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, RoleDAO roleDAO, SecurityQuestionDAO securityQuestionDAO, ApplicationDAO applicationDAO, AccessTokenDAO accessTokenDAO, DelegationDAO delegationDAO, ConfParamOps confParamOps) {
        return new UserDataBinderImpl(anyTypeDAO, realmDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, plainAttrDAO, plainAttrValueDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, virAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, validator, roleDAO, securityQuestionDAO, applicationDAO, accessTokenDAO, delegationDAO, confParamOps, securityProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    public WAConfigDataBinder waConfigDataBinder(WAConfigDAO waConfigDAO, EntityFactory entityFactory) {
        return new WAConfigDataBinderImpl(waConfigDAO, entityFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public WAClientAppDataBinder waClientAppDataBinder(ClientAppDataBinder clientAppDataBinder, PolicyDataBinder policyDataBinder, AuthModuleDataBinder authModuleDataBinder, AuthModuleDAO authModuleDAO, AttrRepoDAO attrRepoDAO) {
        return new WAClientAppDataBinderImpl(clientAppDataBinder, policyDataBinder, authModuleDataBinder, authModuleDAO, attrRepoDAO);
    }
}

