/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.AttrRepoRestClient;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxGridFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyTO;
import org.apache.syncope.common.lib.policy.DefaultAttrReleasePolicyConf;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.to.AttrRepoTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class AttrReleasePolicyModalPanel
extends AbstractModalPanel<AttrReleasePolicyTO> {
    private static final long serialVersionUID = 2668291404983623500L;
    @SpringBean
    protected PolicyRestClient policyRestClient;
    @SpringBean
    protected AttrRepoRestClient attrRepoRestClient;
    protected final IModel<List<String>> allAttrRepos = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected List<String> load() {
            return AttrReleasePolicyModalPanel.this.attrRepoRestClient.list().stream().map(AttrRepoTO::getKey).sorted().collect(Collectors.toList());
        }
    };
    protected final IModel<AttrReleasePolicyTO> model;

    public AttrReleasePolicyModalPanel(BaseModal<AttrReleasePolicyTO> modal, IModel<AttrReleasePolicyTO> model, PageReference pageRef) {
        super(modal, pageRef);
        this.model = model;
        this.add(new Component[]{new AjaxGridFieldPanel("releaseAttrs", "releaseAttrs", (IModel)new PropertyModel((Object)((AttrReleasePolicyTO)model.getObject()).getConf(), "releaseAttrs"))});
        AjaxTextFieldPanel allowedAttr = new AjaxTextFieldPanel("panel", "allowedAttrs", (IModel)new Model());
        this.add(new Component[]{new MultiFieldPanel.Builder((IModel)new PropertyModel((Object)((AttrReleasePolicyTO)model.getObject()).getConf(), "allowedAttrs")).build("allowedAttrs", "allowedAttrs", (FieldPanel)allowedAttr)});
        AjaxTextFieldPanel excludedAttr = new AjaxTextFieldPanel("panel", "excludedAttrs", (IModel)new Model());
        this.add(new Component[]{new MultiFieldPanel.Builder((IModel)new PropertyModel((Object)((AttrReleasePolicyTO)model.getObject()).getConf(), "excludedAttrs")).build("excludedAttrs", "excludedAttrs", (FieldPanel)excludedAttr)});
        AjaxTextFieldPanel includeOnlyAttr = new AjaxTextFieldPanel("panel", "includeOnlyAttrs", (IModel)new Model());
        this.add(new Component[]{new MultiFieldPanel.Builder((IModel)new PropertyModel((Object)((AttrReleasePolicyTO)model.getObject()).getConf(), "includeOnlyAttrs")).build("includeOnlyAttrs", "includeOnlyAttrs", (FieldPanel)includeOnlyAttr)});
        this.add(new Component[]{new AjaxTextFieldPanel("principalIdAttr", "principalIdAttr", (IModel)new PropertyModel((Object)((AttrReleasePolicyTO)model.getObject()).getConf(), "principalIdAttr"))});
        AjaxDropDownChoicePanel mergingStrategy = new AjaxDropDownChoicePanel("mergingStrategy", "mergingStrategy", (IModel)new PropertyModel((Object)((AttrReleasePolicyTO)model.getObject()).getConf(), "principalAttrRepoConf.mergingStrategy"));
        mergingStrategy.setChoices(List.of(DefaultAttrReleasePolicyConf.PrincipalAttrRepoMergingStrategy.values()));
        mergingStrategy.addRequiredLabel();
        mergingStrategy.setNullValid(false);
        this.add(new Component[]{mergingStrategy});
        this.add(new Component[]{new AjaxCheckBoxPanel("ignoreResolvedAttributes", "ignoreResolvedAttributes", (IModel)new PropertyModel((Object)((AttrReleasePolicyTO)model.getObject()).getConf(), "principalAttrRepoConf.ignoreResolvedAttributes"), false)});
        this.add(new Component[]{new AjaxNumberFieldPanel.Builder().build("expiration", "expiration", Long.class, (IModel)new PropertyModel((Object)((AttrReleasePolicyTO)model.getObject()).getConf(), "principalAttrRepoConf.expiration"))});
        AjaxDropDownChoicePanel timeUnit = new AjaxDropDownChoicePanel("timeUnit", "timeUnit", (IModel)new PropertyModel((Object)((AttrReleasePolicyTO)model.getObject()).getConf(), "principalAttrRepoConf.timeUnit"));
        timeUnit.setChoices(List.of(TimeUnit.values()));
        timeUnit.addRequiredLabel();
        timeUnit.setNullValid(false);
        this.add(new Component[]{timeUnit});
        this.add(new Component[]{new AjaxPalettePanel.Builder().setName("attrRepos").build("attrRepos", (IModel)new PropertyModel((Object)((AttrReleasePolicyTO)model.getObject()).getConf(), "principalAttrRepoConf.attrRepos"), this.allAttrRepos)});
    }

    public void onSubmit(AjaxRequestTarget target) {
        try {
            this.policyRestClient.update(PolicyType.ATTR_RELEASE, (PolicyTO)((AttrReleasePolicyTO)this.model.getObject()));
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While updating Attribute Release Policy {}", (Object)((AttrReleasePolicyTO)this.model.getObject()).getKey(), (Object)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

