/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.tabs;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.widget.tabs.AjaxTab;
import com.googlecode.wicket.jquery.ui.widget.tabs.ITabsListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;

public abstract class TabsBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "tabs";
    private final ITabsListener listener;
    private JQueryAjaxBehavior onCreateAjaxBehavior = null;
    private JQueryAjaxBehavior onActivateAjaxBehavior = null;
    private JQueryAjaxBehavior onActivatingAjaxBehavior = null;

    public TabsBehavior(String selector, ITabsListener listener) {
        this(selector, new Options(), listener);
    }

    public TabsBehavior(String selector, Options options, ITabsListener listener) {
        super(selector, METHOD, options);
        this.listener = (ITabsListener)Args.notNull((Object)listener, (String)"listener");
    }

    protected abstract List<ITab> getTabs();

    protected List<ITab> getVisibleTabs() {
        ArrayList list = Generics.newArrayList();
        for (ITab tab : this.getTabs()) {
            if (!tab.isVisible()) continue;
            list.add(tab);
        }
        return Collections.unmodifiableList(list);
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isCreateEventEnabled()) {
            this.onCreateAjaxBehavior = this.newOnActivateAjaxBehavior(this);
            component.add(new Behavior[]{this.onCreateAjaxBehavior});
        }
        if (this.listener.isActivateEventEnabled()) {
            this.onActivateAjaxBehavior = this.newOnActivateAjaxBehavior(this);
            component.add(new Behavior[]{this.onActivateAjaxBehavior});
        }
        if (this.listener.isActivatingEventEnabled()) {
            this.onActivatingAjaxBehavior = this.newOnActivatingAjaxBehavior(this);
            component.add(new Behavior[]{this.onActivatingAjaxBehavior});
        }
    }

    public void activate(int index, IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)this.$(new Object[]{"'option'", "'active'", index}));
    }

    public void enable(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)this.$("'enable'"));
    }

    public void enable(int index, IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)this.$(new Object[]{"'enable'", index}));
    }

    public void disable(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)this.$("'disable'"));
    }

    public void disable(int index, IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)this.$(new Object[]{"'disable'", index}));
    }

    @Override
    public void onConfigure(Component component) {
        if (this.onCreateAjaxBehavior != null) {
            this.setOption("create", this.onCreateAjaxBehavior.getCallbackFunction());
        }
        if (this.onActivateAjaxBehavior != null) {
            this.setOption("activate", this.onActivateAjaxBehavior.getCallbackFunction());
        }
        if (this.onActivatingAjaxBehavior != null) {
            this.setOption("beforeActivate", this.onActivatingAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof ActivateEvent) {
            int index = ((ActivateEvent)event).getIndex();
            List<ITab> tabs = this.getVisibleTabs();
            if (-1 < index && index < tabs.size()) {
                ITab tab = tabs.get(index);
                if (tab instanceof AjaxTab) {
                    ((AjaxTab)tab).load(target);
                }
                if (event instanceof ActivatingEvent) {
                    this.listener.onActivating(target, index, tab);
                } else {
                    this.listener.onActivate(target, index, tab);
                }
            }
        }
    }

    protected JQueryAjaxBehavior newOnActivateAjaxBehavior(IJQueryAjaxAware source) {
        return new OnActivateAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnActivatingAjaxBehavior(IJQueryAjaxAware source) {
        return new OnActivatingAjaxBehavior(source);
    }

    protected static class ActivatingEvent
    extends ActivateEvent {
        protected ActivatingEvent() {
        }
    }

    protected static class ActivateEvent
    extends TabEvent {
        protected ActivateEvent() {
        }
    }

    static abstract class TabEvent
    extends JQueryEvent {
        private final int index = RequestCycleUtils.getQueryParameterValue((String)"index").toInt(-1);

        public int getIndex() {
            return this.index;
        }
    }

    protected static class OnActivatingAjaxBehavior
    extends TabAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnActivatingAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        @Override
        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"index", (String)"+ui.newPanel.attr('id').split('-').pop() - 1")};
        }

        protected JQueryEvent newEvent() {
            return new ActivatingEvent();
        }
    }

    protected static class OnActivateAjaxBehavior
    extends TabAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnActivateAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected JQueryEvent newEvent() {
            return new ActivateEvent();
        }
    }

    static abstract class TabAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public TabAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"index", (String)"jQuery(event.target).tabs('option', 'active')")};
        }
    }
}

