/*
 * Decompiled with CFR 0.152.
 */
package com.okta.commons.lang;

import com.okta.commons.lang.Classes;
import com.okta.commons.lang.Strings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationInfo {
    private static final String VERSION_FILE_LOCATION = "META-INF/okta/version.properties";
    private static final String INTEGRATION_RUNTIME_SPRING_ID = "spring";
    private static final String INTEGRATION_RUNTIME_SPRING_CLASS = "org.springframework.context.ApplicationContext";
    private static final String RAPID_PROTOTYPING_SPRING_BOOT_ID = "spring-boot";
    private static final String RAPID_PROTOTYPING_SPRING_BOOT_CLASS = "org.springframework.boot.SpringApplication";
    private static final String JAVA_SDK_RUNTIME_STRING = "java";
    private static final String SECURITY_FRAMEWORK_SHIRO_ID = "shiro";
    private static final String SECURITY_FRAMEWORK_SHIRO_CLASS = "org.apache.shiro.SecurityUtils";
    private static final String SECURITY_FRAMEWORK_SPRING_SECURITY_ID = "spring-security";
    private static final String SECURITY_FRAMEWORK_SPRING_SECURITY_CLASS = "org.springframework.security.core.SpringSecurityCoreVersion";
    private static final String WEB_SERVER_TOMCAT_ID = "tomcat";
    private static final String WEB_SERVER_TOMCAT_BOOTSTRAP_CLASS = "org.apache.catalina.startup.Bootstrap";
    private static final String WEB_SERVER_TOMCAT_EMBEDDED_CLASS = "org.apache.catalina.startup.Tomcat";
    private static final String WEB_SERVER_JETTY_ID = "jetty";
    private static final String WEB_SERVER_JETTY_CLASS = "org.eclipse.jetty.servlet.listener.ELContextCleaner";
    private static final String WEB_SERVER_JBOSS_ID = "jboss";
    private static final String WEB_SERVER_JBOSS_CLASS = "org.jboss.as.security.plugins.AuthenticationCacheEvictionListener";
    private static final String WEB_SERVER_WEBSPHERE_ID = "websphere";
    private static final String WEB_SERVER_WEBSPHERE_CLASS = "com.ibm.websphere.product.VersionInfo";
    private static final String WEB_SERVER_GLASSFISH_ID = "glassfish";
    private static final String WEB_SERVER_GLASSFISH_CLASS = "com.sun.enterprise.glassfish.bootstrap.GlassFishMain";
    private static final String WEB_SERVER_WEBLOGIC_ID = "weblogic";
    private static final String WEB_SERVER_WEBLOGIC_CLASS = "weblogic.version";
    private static final String WEB_SERVER_WILDFLY_ID = "wildfly";
    private static final String WEB_SERVER_WILDFLY_CLASS = "org.jboss.as.security.ModuleName";
    private static final String ANDROID_CLASS = "android.os.Build$VERSION";
    private static final String ANDROID_VERSION_FIELD_NAME = "SDK_INT";
    private static final String ANDROID_ID = "android";
    private static final String UNKNOWN_VERSION = "unknown";
    private static final Logger log = LoggerFactory.getLogger(ApplicationInfo.class);
    private static final Map<String, String> NAME_VERSION_MAP = ApplicationInfo.createNameToVersionMap();

    private ApplicationInfo() {
    }

    public static Map<String, String> get() {
        return NAME_VERSION_MAP;
    }

    private static Map<String, String> createNameToVersionMap() {
        ArrayList<NameAndVersion> nameAndVersions = new ArrayList<NameAndVersion>(ApplicationInfo.oktaComponentsFromVersionMetadata());
        nameAndVersions.add(ApplicationInfo.getShiroInfo());
        nameAndVersions.add(ApplicationInfo.getSpringFrameworkInfo());
        nameAndVersions.add(ApplicationInfo.getSpringBootInfo());
        nameAndVersions.add(ApplicationInfo.getSpringSecurityInfo());
        nameAndVersions.add(ApplicationInfo.getWebServerInfo());
        nameAndVersions.add(ApplicationInfo.getJavaSDKRuntimeInfo());
        nameAndVersions.add(ApplicationInfo.getOSInfo());
        nameAndVersions.add(ApplicationInfo.getAndroidInfo());
        return nameAndVersions.stream().filter(Objects::nonNull).collect(LinkedHashMap::new, (map, info) -> map.put(((NameAndVersion)info).name, ((NameAndVersion)info).version), Map::putAll);
    }

    private static NameAndVersion getSpringFrameworkInfo() {
        return ApplicationInfo.getFullEntryStringUsingManifest(INTEGRATION_RUNTIME_SPRING_CLASS, INTEGRATION_RUNTIME_SPRING_ID);
    }

    private static NameAndVersion getJavaSDKRuntimeInfo() {
        return new NameAndVersion(JAVA_SDK_RUNTIME_STRING, System.getProperty("java.version"));
    }

    private static NameAndVersion getOSInfo() {
        return new NameAndVersion(System.getProperty("os.name"), System.getProperty("os.version"));
    }

    private static NameAndVersion getSpringBootInfo() {
        return ApplicationInfo.getFullEntryStringUsingManifest(RAPID_PROTOTYPING_SPRING_BOOT_CLASS, RAPID_PROTOTYPING_SPRING_BOOT_ID);
    }

    private static NameAndVersion getShiroInfo() {
        return ApplicationInfo.getFullEntryStringUsingManifest(SECURITY_FRAMEWORK_SHIRO_CLASS, SECURITY_FRAMEWORK_SHIRO_ID);
    }

    private static NameAndVersion getSpringSecurityInfo() {
        return ApplicationInfo.getFullEntryStringUsingManifest(SECURITY_FRAMEWORK_SPRING_SECURITY_CLASS, SECURITY_FRAMEWORK_SPRING_SECURITY_ID);
    }

    private static NameAndVersion getWebServerInfo() {
        NameAndVersion webServerInfo = ApplicationInfo.getFullEntryStringUsingManifest(WEB_SERVER_GLASSFISH_CLASS, WEB_SERVER_GLASSFISH_ID);
        if (webServerInfo != null) {
            return webServerInfo;
        }
        webServerInfo = ApplicationInfo.getFullEntryStringUsingManifest(WEB_SERVER_TOMCAT_BOOTSTRAP_CLASS, WEB_SERVER_TOMCAT_ID);
        if (webServerInfo != null) {
            return webServerInfo;
        }
        webServerInfo = ApplicationInfo.getFullEntryStringUsingManifest(WEB_SERVER_TOMCAT_EMBEDDED_CLASS, WEB_SERVER_TOMCAT_ID);
        if (webServerInfo != null) {
            return webServerInfo;
        }
        webServerInfo = ApplicationInfo.getFullEntryStringUsingManifest(WEB_SERVER_JETTY_CLASS, WEB_SERVER_JETTY_ID);
        if (webServerInfo != null) {
            return webServerInfo;
        }
        webServerInfo = ApplicationInfo.getWildFlyEntryInfo();
        if (webServerInfo != null) {
            return webServerInfo;
        }
        webServerInfo = ApplicationInfo.getFullEntryStringUsingManifest(WEB_SERVER_JBOSS_CLASS, WEB_SERVER_JBOSS_ID);
        if (webServerInfo != null) {
            return webServerInfo;
        }
        webServerInfo = ApplicationInfo.getWebSphereEntryInfo();
        if (webServerInfo != null) {
            return webServerInfo;
        }
        webServerInfo = ApplicationInfo.getWebLogicEntryInfo();
        if (webServerInfo != null) {
            return webServerInfo;
        }
        return null;
    }

    private static NameAndVersion getFullEntryStringUsingManifest(String fqcn, String entryId) {
        if (Classes.isAvailable(fqcn)) {
            return new NameAndVersion(entryId, ApplicationInfo.getVersionInfoInManifest(fqcn));
        }
        return null;
    }

    private static NameAndVersion getWebSphereEntryInfo() {
        if (Classes.isAvailable(WEB_SERVER_WEBSPHERE_CLASS)) {
            return new NameAndVersion(WEB_SERVER_WEBSPHERE_ID, ApplicationInfo.getWebSphereVersion());
        }
        return null;
    }

    private static NameAndVersion getWebLogicEntryInfo() {
        if (Classes.isAvailable(WEB_SERVER_WEBLOGIC_CLASS)) {
            return new NameAndVersion(WEB_SERVER_WEBLOGIC_ID, ApplicationInfo.getWebLogicVersion());
        }
        return null;
    }

    private static NameAndVersion getWildFlyEntryInfo() {
        try {
            Package wildFlyPkg;
            if (Classes.isAvailable(WEB_SERVER_WILDFLY_CLASS) && (wildFlyPkg = Classes.forName(WEB_SERVER_WILDFLY_CLASS).getPackage()) != null && Strings.hasText(wildFlyPkg.getImplementationTitle()) && wildFlyPkg.getImplementationTitle().contains("WildFly")) {
                return new NameAndVersion(WEB_SERVER_WILDFLY_ID, wildFlyPkg.getImplementationVersion());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static NameAndVersion getAndroidInfo() {
        try {
            if (Classes.isAvailable(ANDROID_CLASS)) {
                int version = Class.forName(ANDROID_CLASS).getField(ANDROID_VERSION_FIELD_NAME).getInt(null);
                return new NameAndVersion(ANDROID_ID, Integer.toString(version));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getVersionInfoInManifest(String fqcn) {
        String version = null;
        Package thePackage = Classes.forName(fqcn).getPackage();
        if (thePackage != null && !Strings.hasText(version = thePackage.getSpecificationVersion())) {
            version = thePackage.getImplementationVersion();
        }
        if (!Strings.hasText(version)) {
            version = UNKNOWN_VERSION;
        }
        return version;
    }

    private static String getWebSphereVersion() {
        try {
            Class<?> versionClass = Class.forName(WEB_SERVER_WEBSPHERE_CLASS);
            Object versionInfo = versionClass.newInstance();
            Method method = versionClass.getDeclaredMethod("runReport", String.class, PrintWriter.class);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            method.invoke(versionInfo, "", printWriter);
            String version = stringWriter.toString();
            version = version.substring(version.indexOf("Installed Product"));
            version = version.substring(version.indexOf("Version"));
            version = version.substring(version.indexOf(" "), version.indexOf("\n")).trim();
            return version;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            return UNKNOWN_VERSION;
        }
    }

    private static String getWebLogicVersion() {
        try {
            Class<?> versionClass = Class.forName(WEB_SERVER_WEBLOGIC_CLASS);
            Object version = versionClass.newInstance();
            Method method = versionClass.getDeclaredMethod("getReleaseBuildVersion", new Class[0]);
            return (String)method.invoke(version, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            return UNKNOWN_VERSION;
        }
    }

    private static Set<NameAndVersion> oktaComponentsFromVersionMetadata() {
        HashSet<NameAndVersion> results = new HashSet<NameAndVersion>();
        try {
            Collections.list(ApplicationInfo.class.getClassLoader().getResources(VERSION_FILE_LOCATION)).stream().map(ApplicationInfo::loadProps).forEach(properties -> results.addAll(ApplicationInfo.entriesFromOktaVersionMetadata(properties)));
        }
        catch (IOException e) {
            log.warn("Failed to locate okta component version metadata as a resource: {}", (Object)VERSION_FILE_LOCATION);
        }
        return results;
    }

    private static Set<NameAndVersion> entriesFromOktaVersionMetadata(Properties properties) {
        if (properties == null) {
            return Collections.emptySet();
        }
        return properties.entrySet().stream().map(entry -> new NameAndVersion((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toSet());
    }

    private static Properties loadProps(URL resourceUrl) {
        try {
            Properties props = new Properties();
            props.load(resourceUrl.openStream());
            return props;
        }
        catch (IOException e) {
            log.warn("Failed to open properties file: '{}', but this file was detected on your classpath", (Object)resourceUrl);
            return null;
        }
    }

    private static class NameAndVersion {
        private final String name;
        private final String version;

        private NameAndVersion(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }
}

