/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3;

import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.NoSuchUserException;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserManager;

public class Pop3State {
    UserManager manager;
    GreenMailUser user;
    MailFolder inbox;
    private ImapHostManager imapHostManager;

    public Pop3State(UserManager manager) {
        this.manager = manager;
        this.imapHostManager = manager.getImapHostManager();
    }

    public GreenMailUser getUser() {
        return this.user;
    }

    public GreenMailUser getUser(String username) throws UserException {
        GreenMailUser user = this.manager.getUser(username);
        if (null == user) {
            throw new NoSuchUserException("User <" + username + "> doesn't exist");
        }
        return user;
    }

    public void setUser(GreenMailUser user) {
        this.user = user;
    }

    public boolean isAuthenticated() {
        return this.inbox != null;
    }

    public void authenticate(String pass) throws UserException, FolderException {
        if (this.user == null) {
            throw new UserException("No user selected");
        }
        if (this.manager.isAuthRequired()) {
            this.user.authenticate(pass);
        }
        this.inbox = this.imapHostManager.getInbox(this.user);
    }

    public MailFolder getFolder() {
        return this.inbox;
    }

    public GreenMailUser findOrCreateUser(String username) throws UserException {
        if (this.manager.hasUser(username)) {
            return this.manager.getUser(username);
        }
        if (!this.manager.isAuthRequired()) {
            return this.manager.createUser(username, username, username);
        }
        throw new UserException("Unable to find or create user '" + username + "'");
    }
}

