/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.components.progress;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.progress.ProgressBar;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.BackgroundColorBehavior;
import java.time.Duration;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;

public abstract class UpdatableProgressBar
extends ProgressBar {
    private static final long serialVersionUID = 1L;
    Duration updateInterval = Duration.ofSeconds(5L);
    private UpdateBehavior behavior;

    public UpdatableProgressBar(String id) {
        this(id, null);
    }

    public UpdatableProgressBar(String id, IModel<Integer> model) {
        this(id, model, BackgroundColorBehavior.Color.Secondary, false);
    }

    public UpdatableProgressBar(String id, IModel<Integer> model, BackgroundColorBehavior.Color color, boolean labeled) {
        super(id, model, color, labeled);
        this.setOutputMarkupId(true);
        this.active(true);
        this.behavior = new UpdateBehavior(this.updateInterval){
            private static final long serialVersionUID = 1L;

            protected void onPostProcessTarget(AjaxRequestTarget target) {
                super.onPostProcessTarget(target);
                UpdatableProgressBar.this.onPostProcessTarget((IPartialPageRequestHandler)target);
            }
        };
        this.add(new Behavior[]{this.behavior});
    }

    public Duration updateInterval() {
        return this.behavior.updateInterval();
    }

    public UpdatableProgressBar updateInterval(Duration updateInterval) {
        this.behavior.updateInterval(updateInterval);
        return this;
    }

    public UpdatableProgressBar stop(IPartialPageRequestHandler target) {
        this.behavior.stop(target);
        return this;
    }

    public UpdatableProgressBar restart(IPartialPageRequestHandler target) {
        this.behavior.restart(target);
        return this;
    }

    protected void onPostProcessTarget(IPartialPageRequestHandler target) {
        this.value(this.newValue());
        if (this.complete()) {
            this.behavior.stop(target);
            this.onComplete(target);
        }
    }

    protected void onComplete(IPartialPageRequestHandler target) {
        this.active(false);
        this.striped(false);
        target.add(new Component[]{this});
    }

    protected abstract IModel<Integer> newValue();

    private static abstract class UpdateBehavior
    extends AjaxSelfUpdatingTimerBehavior {
        private static final long serialVersionUID = 1L;

        private UpdateBehavior(Duration updateInterval) {
            super(updateInterval);
        }

        private void updateInterval(Duration duration) {
            this.setUpdateInterval(duration);
        }

        private Duration updateInterval() {
            return this.getUpdateInterval();
        }
    }
}

