/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.DeadLetterJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.AbstractJobServiceEngineEntityManager;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntity;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.data.DeadLetterJobDataManager;

public class DeadLetterJobEntityManagerImpl
extends AbstractJobServiceEngineEntityManager<DeadLetterJobEntity, DeadLetterJobDataManager>
implements DeadLetterJobEntityManager {
    public DeadLetterJobEntityManagerImpl(JobServiceConfiguration jobServiceConfiguration, DeadLetterJobDataManager jobDataManager) {
        super(jobServiceConfiguration, jobServiceConfiguration.getEngineName(), jobDataManager);
    }

    @Override
    public DeadLetterJobEntity findJobByCorrelationId(String correlationId) {
        return ((DeadLetterJobDataManager)this.dataManager).findJobByCorrelationId(correlationId);
    }

    @Override
    public List<DeadLetterJobEntity> findJobsByExecutionId(String id) {
        return ((DeadLetterJobDataManager)this.dataManager).findJobsByExecutionId(id);
    }

    @Override
    public List<DeadLetterJobEntity> findJobsByProcessInstanceId(String id) {
        return ((DeadLetterJobDataManager)this.dataManager).findJobsByProcessInstanceId(id);
    }

    @Override
    public List<Job> findJobsByQueryCriteria(DeadLetterJobQueryImpl jobQuery) {
        return ((DeadLetterJobDataManager)this.dataManager).findJobsByQueryCriteria(jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(DeadLetterJobQueryImpl jobQuery) {
        return ((DeadLetterJobDataManager)this.dataManager).findJobCountByQueryCriteria(jobQuery);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        ((DeadLetterJobDataManager)this.dataManager).updateJobTenantIdForDeployment(deploymentId, newTenantId);
    }

    public void insert(DeadLetterJobEntity jobEntity, boolean fireCreateEvent) {
        if (((JobServiceConfiguration)this.getServiceConfiguration()).getInternalJobManager() != null) {
            ((JobServiceConfiguration)this.getServiceConfiguration()).getInternalJobManager().handleJobInsert(jobEntity);
        }
        jobEntity.setCreateTime(((JobServiceConfiguration)this.getServiceConfiguration()).getClock().getCurrentTime());
        if (jobEntity.getCorrelationId() == null) {
            jobEntity.setCorrelationId(((JobServiceConfiguration)this.serviceConfiguration).getIdGenerator().getNextId());
        }
        super.insert((Entity)jobEntity, fireCreateEvent);
    }

    public void insert(DeadLetterJobEntity jobEntity) {
        this.insert(jobEntity, true);
    }

    public void delete(DeadLetterJobEntity jobEntity) {
        super.delete((Entity)jobEntity);
        this.deleteByteArrayRef(jobEntity.getExceptionByteArrayRef());
        this.deleteByteArrayRef(jobEntity.getCustomValuesByteArrayRef());
        if ("historyJob".equals(jobEntity.getJobType()) && jobEntity.getJobHandlerConfiguration() != null) {
            new ByteArrayRef(jobEntity.getJobHandlerConfiguration(), ((JobServiceConfiguration)this.serviceConfiguration).getCommandExecutor()).delete(((JobServiceConfiguration)this.serviceConfiguration).getEngineName());
        }
        if (((JobServiceConfiguration)this.getServiceConfiguration()).getInternalJobManager() != null) {
            ((JobServiceConfiguration)this.getServiceConfiguration()).getInternalJobManager().handleJobDelete(jobEntity);
        }
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, jobEntity), this.engineType);
        }
    }

    protected DeadLetterJobEntity createDeadLetterJob(AbstractRuntimeJobEntity job) {
        DeadLetterJobEntity newJobEntity = (DeadLetterJobEntity)this.create();
        newJobEntity.setJobHandlerConfiguration(job.getJobHandlerConfiguration());
        newJobEntity.setCustomValues(job.getCustomValues());
        newJobEntity.setJobHandlerType(job.getJobHandlerType());
        newJobEntity.setExclusive(job.isExclusive());
        newJobEntity.setRepeat(job.getRepeat());
        newJobEntity.setRetries(job.getRetries());
        newJobEntity.setEndDate(job.getEndDate());
        newJobEntity.setExecutionId(job.getExecutionId());
        newJobEntity.setProcessInstanceId(job.getProcessInstanceId());
        newJobEntity.setProcessDefinitionId(job.getProcessDefinitionId());
        newJobEntity.setScopeId(job.getScopeId());
        newJobEntity.setSubScopeId(job.getSubScopeId());
        newJobEntity.setScopeType(job.getScopeType());
        newJobEntity.setScopeDefinitionId(job.getScopeDefinitionId());
        newJobEntity.setTenantId(job.getTenantId());
        newJobEntity.setJobType(job.getJobType());
        return newJobEntity;
    }
}

