/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.MappingDefaults;
import org.apache.openjpa.jdbc.meta.MappingInfo;
import org.apache.openjpa.jdbc.meta.ValueMappingImpl;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.xml.Commentable;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.util.MetaDataException;

public class FieldMappingInfo
extends MappingInfo
implements Commentable {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(FieldMappingInfo.class);
    private DBIdentifier _tableName = DBIdentifier.NULL;
    private boolean _outer = false;
    private Column _orderCol = null;
    private boolean _canOrderCol = true;
    private String[] _comments = null;
    private List<Unique> _joinTableUniques;

    @Deprecated
    public String getTableName() {
        return this.getTableIdentifier().getName();
    }

    public DBIdentifier getTableIdentifier() {
        return this._tableName == null ? DBIdentifier.NULL : this._tableName;
    }

    @Deprecated
    public void setTableName(String tableName) {
        this.setTableIdentifier(DBIdentifier.newTable(tableName));
    }

    public void setTableIdentifier(DBIdentifier tableName) {
        this._tableName = tableName;
    }

    public boolean isJoinOuter() {
        return this._outer;
    }

    public void setJoinOuter(boolean outer) {
        this._outer = outer;
    }

    public Column getOrderColumn() {
        return this._orderCol;
    }

    public void setOrderColumn(Column order) {
        this._orderCol = order;
    }

    public boolean canOrderColumn() {
        return this._canOrderCol;
    }

    public void setCanOrderColumn(boolean canOrder) {
        this._canOrderCol = canOrder;
    }

    public Table getTable(final FieldMapping field, boolean create, boolean adapt) {
        if (DBIdentifier.isNull(this._tableName) && !create) {
            return null;
        }
        Table table = field.getDefiningMapping().getTable();
        DBIdentifier schemaName = table == null ? DBIdentifier.NULL : table.getSchema().getIdentifier();
        DBIdentifier tableName = this._tableName;
        if (!DBIdentifier.isNull(tableName) && this.getColumns().isEmpty()) {
            tableName = field.getDefiningMapping().getMappingInfo().getSecondaryTableIdentifier(tableName);
        }
        return this.createTable((MetaDataContext)field, new MappingInfo.TableDefaults(){

            @Override
            public String get(Schema schema) {
                return field.getMappingRepository().getMappingDefaults().getTableName(field, schema);
            }

            @Override
            public DBIdentifier getIdentifier(Schema schema) {
                return field.getMappingRepository().getMappingDefaults().getTableIdentifier(field, schema);
            }
        }, schemaName, tableName, adapt);
    }

    public ForeignKey getJoinForeignKey(FieldMapping field, Table table, boolean adapt) {
        if (field.isUni1ToMFK()) {
            List<Column> cols = field.getElementMapping().getValueInfo().getColumns();
            return this.getJoin(field, table, adapt, cols);
        }
        return null;
    }

    public ForeignKey getJoin(FieldMapping field, Table table, boolean adapt) {
        return this.getJoin(field, table, adapt, this.getColumns());
    }

    public ForeignKey getJoin(final FieldMapping field, Table table, boolean adapt, List<Column> cols) {
        if (cols.isEmpty()) {
            ClassMapping mapping = field.isEmbedded() && field.getDeclaringMapping().getEmbeddingMapping() != null ? field.getDeclaringMapping().getEmbeddingMapping().getFieldMapping().getDeclaringMapping() : field.getDefiningMapping();
            cols = mapping.getMappingInfo().getSecondaryTableJoinColumns(this._tableName);
        }
        MappingInfo.ForeignKeyDefaults def = new MappingInfo.ForeignKeyDefaults(){

            @Override
            public ForeignKey get(Table local, Table foreign, boolean inverse) {
                return field.getMappingRepository().getMappingDefaults().getJoinForeignKey(field, local, foreign);
            }

            @Override
            public void populate(Table local, Table foreign, Column col, Object target, boolean inverse, int pos, int cols) {
                field.getMappingRepository().getMappingDefaults().populateJoinColumn(field, local, foreign, col, target, pos, cols);
            }
        };
        ClassMapping cls = this.getDefiningMapping(field);
        return this.createForeignKey(field, "join", cols, def, table, cls, cls, false, adapt);
    }

    private ClassMapping getDefiningMapping(FieldMapping field) {
        ClassMapping clm = field.getDefiningMapping();
        ValueMappingImpl value = (ValueMappingImpl)clm.getEmbeddingMetaData();
        if (value == null) {
            return clm;
        }
        FieldMapping field1 = value.getFieldMapping();
        return this.getDefiningMapping(field1);
    }

    public Unique getJoinUnique(FieldMapping field, boolean def, boolean adapt) {
        ForeignKey fk = field.getJoinForeignKey();
        if (fk == null) {
            return null;
        }
        Unique unq = null;
        if (fk.getColumns().length > 0) {
            unq = field.getMappingRepository().getMappingDefaults().getJoinUnique(field, fk.getTable(), fk.getColumns());
        }
        return this.createUnique(field, "join", unq, fk.getColumns(), adapt);
    }

    public void addJoinTableUnique(Unique u) {
        if (this._joinTableUniques == null) {
            this._joinTableUniques = new ArrayList<Unique>();
        }
        this._joinTableUniques.add(u);
    }

    public Unique[] getJoinTableUniques(FieldMapping field, boolean def, boolean adapt) {
        return this.getUniques(field, this._joinTableUniques, def, adapt);
    }

    private Unique[] getUniques(FieldMapping field, List<Unique> uniques, boolean def, boolean adapt) {
        if (uniques == null || uniques.isEmpty()) {
            return new Unique[0];
        }
        ArrayList<Unique> result = new ArrayList<Unique>();
        for (Unique template : uniques) {
            Column[] templateColumns = template.getColumns();
            Column[] uniqueColumns = new Column[templateColumns.length];
            Table table = this.getTable(field, true, adapt);
            for (int i = 0; i < uniqueColumns.length; ++i) {
                Column uniqueColumn;
                DBIdentifier columnName = templateColumns[i].getIdentifier();
                uniqueColumns[i] = uniqueColumn = table.getColumn(columnName);
            }
            Unique unique = this.createUnique(field, "unique", template, uniqueColumns, adapt);
            if (unique == null) continue;
            result.add(unique);
        }
        return result.toArray(new Unique[result.size()]);
    }

    public Index getJoinIndex(FieldMapping field, boolean adapt) {
        ForeignKey fk = field.getJoinForeignKey();
        if (fk == null) {
            return null;
        }
        Index idx = null;
        if (fk.getColumns().length > 0) {
            idx = field.getMappingRepository().getMappingDefaults().getJoinIndex(field, fk.getTable(), fk.getColumns());
        }
        return this.createIndex(field, "join", idx, fk.getColumns(), adapt);
    }

    public Column getOrderColumn(FieldMapping field, Table table, boolean adapt) {
        if (this._orderCol != null && field.getOrderDeclaration() != null) {
            throw new MetaDataException(_loc.get("order-conflict", (Object)field));
        }
        this.setColumnIO(null);
        if (!this._canOrderCol || field.getOrderDeclaration() != null) {
            return null;
        }
        MappingDefaults def = field.getMappingRepository().getMappingDefaults();
        if (this._orderCol == null && !adapt && !def.defaultMissingInfo()) {
            return null;
        }
        Column tmplate = new Column();
        boolean delimit = field.getMappingRepository().getDBDictionary().delimitAll();
        if (field.getMappingRepository().getConfiguration().getCompatibilityInstance().getUseJPA2DefaultOrderColumnName()) {
            DBIdentifier sName = DBIdentifier.newColumn(field.getName(), delimit);
            sName = DBIdentifier.append(sName, "_ORDER");
            tmplate.setIdentifier(sName);
        } else {
            tmplate.setIdentifier(DBIdentifier.newColumn("ordr", delimit));
        }
        tmplate.setJavaType(5);
        if (!def.populateOrderColumns(field, table, new Column[]{tmplate}) && this._orderCol == null) {
            return null;
        }
        if (this._orderCol != null) {
            ColumnIO io = new ColumnIO();
            io.setNullInsertable(0, !this._orderCol.isNotNull());
            io.setNullUpdatable(0, !this._orderCol.isNotNull());
            io.setInsertable(0, !this._orderCol.getFlag(2));
            io.setUpdatable(0, !this._orderCol.getFlag(4));
            this.setColumnIO(io);
        }
        return FieldMappingInfo.mergeColumn(field, "order", tmplate, true, this._orderCol, table, adapt, def.defaultMissingInfo());
    }

    public void syncWith(FieldMapping field) {
        this.clear(false);
        if (field.getJoinForeignKey() != null) {
            this._tableName = field.getMappingRepository().getDBDictionary().getFullIdentifier(field.getTable(), true);
        }
        ClassMapping def = field.getDefiningMapping();
        this.setColumnIO(field.getJoinColumnIO());
        if (field.getJoinForeignKey() != null && def.getTable() != null) {
            this.syncForeignKey(field, field.getJoinForeignKey(), field.getTable(), def.getTable());
        }
        this._outer = field.isJoinOuter();
        this.syncIndex(field, field.getJoinIndex());
        this.syncUnique(field, field.getJoinUnique());
        this.syncJoinTableUniques(field, field.getJoinTableUniques());
        this.syncOrderColumn(field);
        this.syncStrategy(field);
    }

    public void syncStrategy(FieldMapping field) {
        this.setStrategy(null);
        if (field.getHandler() != null || field.getStrategy() == null) {
            return;
        }
        FieldStrategy strat = field.getMappingRepository().defaultStrategy(field, false);
        if (strat == null || !strat.getAlias().equals(field.getAlias())) {
            this.setStrategy(field.getAlias());
        }
    }

    public void syncOrderColumn(FieldMapping field) {
        this._orderCol = field.getOrderColumn() != null ? FieldMappingInfo.syncColumn(field, field.getOrderColumn(), 1, false, field.getTable(), null, null, false) : null;
    }

    protected void syncJoinTableUniques(MetaDataContext context, Unique[] unqs) {
        if (unqs == null) {
            this._joinTableUniques = null;
            return;
        }
        this._joinTableUniques = new ArrayList<Unique>();
        for (Unique unique : unqs) {
            Unique copy = new Unique();
            copy.setIdentifier(unique.getIdentifier());
            copy.setDeferred(unique.isDeferred());
            this._joinTableUniques.add(unique);
        }
    }

    @Override
    public boolean hasSchemaComponents() {
        return super.hasSchemaComponents() || !DBIdentifier.isNull(this._tableName) || this._orderCol != null;
    }

    @Override
    protected void clear(boolean canFlags) {
        super.clear(canFlags);
        this._tableName = DBIdentifier.NULL;
        this._orderCol = null;
        if (canFlags) {
            this._canOrderCol = true;
        }
    }

    @Override
    public void copy(MappingInfo info) {
        super.copy(info);
        if (!(info instanceof FieldMappingInfo)) {
            return;
        }
        FieldMappingInfo finfo = (FieldMappingInfo)info;
        if (DBIdentifier.isNull(this._tableName)) {
            this._tableName = finfo.getTableIdentifier();
        }
        if (!this._outer) {
            this._outer = finfo.isJoinOuter();
        }
        if (this._canOrderCol && this._orderCol == null) {
            this._canOrderCol = finfo.canOrderColumn();
        }
        if (this._canOrderCol && finfo.getOrderColumn() != null) {
            if (this._orderCol == null) {
                this._orderCol = new Column();
            }
            this._orderCol.copy(finfo.getOrderColumn());
        }
    }

    public String[] getComments() {
        return this._comments == null ? EMPTY_COMMENTS : this._comments;
    }

    public void setComments(String[] comments) {
        this._comments = comments;
    }
}

