/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer.xml;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Base64;
import org.identityconnectors.common.XmlUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.serializer.ObjectDecoder;
import org.identityconnectors.framework.impl.serializer.ObjectSerializationHandler;
import org.identityconnectors.framework.impl.serializer.ObjectSerializerRegistry;
import org.identityconnectors.framework.impl.serializer.ObjectTypeMapper;
import org.identityconnectors.framework.impl.serializer.xml.XmlObjectEncoder;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlObjectDecoder
implements ObjectDecoder {
    private final Element node;
    private final Class<?> expectedClass;

    public XmlObjectDecoder(Element node, Class<?> expectedClass) {
        this.node = node;
        this.expectedClass = expectedClass;
    }

    public Object readObject() {
        return this.readObjectInternal();
    }

    @Override
    public boolean readBooleanContents() {
        return this.decodeBoolean(this.readStringContentsInternal());
    }

    @Override
    public boolean readBooleanField(String fieldName, boolean dflt) {
        return this.decodeBoolean(this.readStringAttributeInternal(fieldName, XmlObjectEncoder.encodeBoolean(dflt)));
    }

    @Override
    public byte readByteContents() {
        return this.decodeByte(this.readStringContentsInternal());
    }

    @Override
    public byte[] readByteArrayContents() {
        return this.decodeByteArray(this.readStringContentsInternal());
    }

    @Override
    public Class<?> readClassContents() {
        return this.decodeClass(this.readStringContentsInternal());
    }

    @Override
    public Class<?> readClassField(String name, Class<?> dflt) {
        String val = this.readStringAttributeInternal(name, null);
        if (val == null) {
            return dflt;
        }
        return this.decodeClass(val);
    }

    @Override
    public double readDoubleContents() {
        return this.decodeDouble(this.readStringContentsInternal());
    }

    @Override
    public double readDoubleField(String fieldName, double dflt) {
        return this.decodeDouble(this.readStringAttributeInternal(fieldName, XmlObjectEncoder.encodeDouble(dflt)));
    }

    @Override
    public float readFloatContents() {
        return this.decodeFloat(this.readStringContentsInternal());
    }

    @Override
    public float readFloatField(String fieldName, float dflt) {
        return this.decodeFloat(this.readStringAttributeInternal(fieldName, XmlObjectEncoder.encodeFloat(dflt)));
    }

    @Override
    public int readIntContents() {
        return this.decodeInt(this.readStringContentsInternal());
    }

    @Override
    public int readIntField(String fieldName, int dflt) {
        return this.decodeInt(this.readStringAttributeInternal(fieldName, XmlObjectEncoder.encodeInt(dflt)));
    }

    @Override
    public long readLongContents() {
        return this.decodeLong(this.readStringContentsInternal());
    }

    @Override
    public long readLongField(String fieldName, long dflt) {
        return this.decodeLong(this.readStringAttributeInternal(fieldName, XmlObjectEncoder.encodeLong(dflt)));
    }

    @Override
    public int getNumSubObjects() {
        int count = 0;
        Element subElement = XmlUtil.getFirstChildElement((Node)this.node);
        while (subElement != null) {
            ++count;
            subElement = XmlUtil.getNextElement((Node)subElement);
        }
        return count;
    }

    @Override
    public Object readObjectContents(int index) {
        Element subElement = XmlUtil.getFirstChildElement((Node)this.node);
        for (int i = 0; i < index; ++i) {
            subElement = XmlUtil.getNextElement((Node)subElement);
        }
        if (subElement == null) {
            throw new ConnectorException("Missing subelement number: " + index);
        }
        return new XmlObjectDecoder(subElement, null).readObject();
    }

    @Override
    public Object readObjectField(String fieldName, Class<?> expected, Object dflt) {
        Element child = XmlUtil.findImmediateChildElement((Node)this.node, (String)fieldName);
        if (child == null) {
            return dflt;
        }
        if (expected != null) {
            return new XmlObjectDecoder(child, expected).readObject();
        }
        Element subElement = XmlUtil.getFirstChildElement((Node)child);
        if (subElement == null) {
            return dflt;
        }
        return new XmlObjectDecoder(subElement, null).readObject();
    }

    @Override
    public String readStringContents() {
        String rv = this.readStringContentsInternal();
        return rv == null ? "" : rv;
    }

    @Override
    public String readStringField(String fieldName, String dflt) {
        return this.readStringAttributeInternal(fieldName, dflt);
    }

    private String readStringContentsInternal() {
        String xml = XmlUtil.getContent((Element)this.node);
        return xml;
    }

    private String readStringAttributeInternal(String name, String dflt) {
        Attr attr = this.node.getAttributeNode(name);
        if (attr == null) {
            return dflt;
        }
        return attr.getValue();
    }

    private boolean decodeBoolean(String v) {
        return Boolean.parseBoolean(v);
    }

    private byte decodeByte(String v) {
        return Byte.decode(v);
    }

    private byte[] decodeByteArray(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    private Class<?> decodeClass(String type) {
        if (type.endsWith("[]")) {
            String componentName = type.substring(0, type.length() - "[]".length());
            Class<?> componentClass = this.decodeClass(componentName);
            Class<?> arrayClass = Array.newInstance(componentClass, 0).getClass();
            return arrayClass;
        }
        ObjectTypeMapper mapper = ObjectSerializerRegistry.getMapperBySerialType(type);
        if (mapper == null) {
            throw new ConnectorException("No deserializer for type: " + type);
        }
        Class<?> clazz = mapper.getHandledObjectType();
        return clazz;
    }

    private double decodeDouble(String val) {
        return Double.parseDouble(val);
    }

    private float decodeFloat(String val) {
        return Float.parseFloat(val);
    }

    private int decodeInt(String val) {
        return Integer.parseInt(val);
    }

    private long decodeLong(String val) {
        return Long.parseLong(val);
    }

    private Object readObjectInternal() {
        if (this.expectedClass != null) {
            ObjectSerializationHandler handler = ObjectSerializerRegistry.getHandlerByObjectType(this.expectedClass);
            if (handler == null) {
                if (this.expectedClass.isArray()) {
                    ArrayList<Object> temp = new ArrayList<Object>();
                    Element child = XmlUtil.getFirstChildElement((Node)this.node);
                    while (child != null) {
                        XmlObjectDecoder sub = new XmlObjectDecoder(child, null);
                        Object obj = sub.readObject();
                        temp.add(obj);
                        child = XmlUtil.getNextElement((Node)child);
                    }
                    int length = temp.size();
                    Object array = Array.newInstance(this.expectedClass.getComponentType(), length);
                    for (int i = 0; i < length; ++i) {
                        Object element = temp.get(i);
                        Array.set(array, i, element);
                    }
                    return array;
                }
                throw new ConnectorException("No deserializer for type: " + this.expectedClass);
            }
            return handler.deserialize(this);
        }
        if (this.node.getTagName().equals("null")) {
            return null;
        }
        if (this.node.getTagName().equals("Array")) {
            String componentType = XmlUtil.getAttribute((Element)this.node, (String)"componentType");
            if (componentType == null) {
                componentType = "Object";
            }
            Class<?> componentClass = this.decodeClass(componentType);
            ArrayList<Object> temp = new ArrayList<Object>();
            Element child = XmlUtil.getFirstChildElement((Node)this.node);
            while (child != null) {
                XmlObjectDecoder sub = new XmlObjectDecoder(child, null);
                Object obj = sub.readObject();
                temp.add(obj);
                child = XmlUtil.getNextElement((Node)child);
            }
            int length = temp.size();
            Object array = Array.newInstance(componentClass, length);
            for (int i = 0; i < length; ++i) {
                Object element = temp.get(i);
                Array.set(array, i, element);
            }
            return array;
        }
        Class<?> clazz = this.decodeClass(this.node.getTagName());
        ObjectSerializationHandler handler = ObjectSerializerRegistry.getHandlerByObjectType(clazz);
        if (handler == null) {
            throw new ConnectorException("No deserializer for type: " + clazz);
        }
        return handler.deserialize(this);
    }
}

