/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public abstract class AbstractPoolHealthIndicator
extends AbstractHealthIndicator
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPoolHealthIndicator.class);
    private final long maxWait;
    private final ExecutorService executor;

    protected void doHealthCheck(Health.Builder builder) {
        Health.Builder poolBuilder = builder.up();
        String message = "";
        try {
            Future<Health.Builder> result = this.executor.submit(new Validator(this, builder));
            poolBuilder = result.get(this.maxWait, TimeUnit.MILLISECONDS);
            message = "OK";
        }
        catch (TimeoutException e) {
            poolBuilder.down();
            message = String.format("Pool validation timed out. Max wait is %s ms.", this.maxWait);
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            poolBuilder.outOfService();
            message = e.getMessage();
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
        poolBuilder.withDetail("message", (Object)message).withDetail("name", (Object)((Object)((Object)this)).getClass().getSimpleName()).withDetail("activeCount", (Object)this.getActiveCount()).withDetail("idleCount", (Object)this.getIdleCount());
    }

    public void destroy() {
        this.executor.shutdown();
    }

    protected abstract Health.Builder checkPool(Health.Builder var1) throws Exception;

    protected int getIdleCount() {
        return -1;
    }

    protected int getActiveCount() {
        return -1;
    }

    @Generated
    protected AbstractPoolHealthIndicator(long maxWait, ExecutorService executor) {
        this.maxWait = maxWait;
        this.executor = executor;
    }

    private static class Validator
    implements Callable<Health.Builder> {
        private final AbstractPoolHealthIndicator monitor;
        private final Health.Builder builder;

        Validator(AbstractPoolHealthIndicator monitor, Health.Builder builder) {
            this.monitor = monitor;
            this.builder = builder;
        }

        @Override
        public Health.Builder call() throws Exception {
            return this.monitor.checkPool(this.builder);
        }
    }
}

