/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.client.util.GenericData;
import com.google.api.services.directory.Directory;
import com.google.api.services.directory.model.Alias;
import com.google.api.services.directory.model.Aliases;
import com.google.api.services.directory.model.User;
import com.google.api.services.directory.model.UserAddress;
import com.google.api.services.directory.model.UserExternalId;
import com.google.api.services.directory.model.UserIm;
import com.google.api.services.directory.model.UserName;
import com.google.api.services.directory.model.UserOrganization;
import com.google.api.services.directory.model.UserPhone;
import com.google.api.services.directory.model.UserPhoto;
import com.google.api.services.directory.model.UserRelation;
import com.google.common.base.CharMatcher;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.io.IOException;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.googleapps.GoogleApiExecutor;
import net.tirasa.connid.bundles.googleapps.GoogleAppsConfiguration;
import net.tirasa.connid.bundles.googleapps.GoogleAppsCustomSchema;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import net.tirasa.connid.bundles.googleapps.GroupHandler;
import net.tirasa.connid.bundles.googleapps.RequestResultHandler;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaUtil;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributeInfos;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AndFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsAllValuesFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterVisitor;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.NotFilter;
import org.identityconnectors.framework.common.objects.filter.OrFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public class UserHandler
implements FilterVisitor<StringBuilder, Directory.Users.List> {
    private static final Log LOG = Log.getLog(UserHandler.class);
    private static final Map<String, String> NAME_DICTIONARY;
    private static final Set<String> S;
    private static final Set<String> SW;
    private static final Escaper STRING_ESCAPER;

    public StringBuilder visitAndFilter(Directory.Users.List list, AndFilter andFilter) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Filter filter : andFilter.getFilters()) {
            StringBuilder sb = (StringBuilder)filter.accept((FilterVisitor)this, (Object)list);
            if (null == sb) continue;
            if (!first) {
                builder.append(' ');
            } else {
                first = false;
            }
            builder.append((CharSequence)sb);
        }
        return builder;
    }

    public StringBuilder visitContainsFilter(Directory.Users.List list, ContainsFilter filter) {
        String filedName = NAME_DICTIONARY.get(filter.getName());
        if (null != filedName && S.contains(filedName)) {
            return this.getStringBuilder(filter.getAttribute(), ':', null, filedName);
        }
        throw new InvalidAttributeValueException("");
    }

    protected StringBuilder getStringBuilder(Attribute attribute, char operator, Character postfix, String filedName) {
        StringBuilder builder = new StringBuilder();
        builder.append(filedName).append(operator);
        String stringValue = AttributeUtil.getAsStringValue((Attribute)attribute);
        if (StringUtil.isNotBlank((String)stringValue)) {
            stringValue = STRING_ESCAPER.escape(stringValue);
            if (CharMatcher.whitespace().matchesAnyOf((CharSequence)stringValue)) {
                builder.append('\'').append(stringValue);
                if (null != postfix) {
                    builder.append(postfix);
                }
                builder.append('\'');
            } else {
                builder.append(stringValue);
                if (null != postfix) {
                    builder.append(postfix);
                }
            }
        }
        return builder;
    }

    public StringBuilder visitStartsWithFilter(Directory.Users.List list, StartsWithFilter filter) {
        String filedName = NAME_DICTIONARY.get(filter.getName());
        if (null != filedName && SW.contains(filedName)) {
            return this.getStringBuilder(filter.getAttribute(), ':', Character.valueOf('*'), filedName);
        }
        throw new InvalidAttributeValueException("");
    }

    public StringBuilder visitEqualsFilter(Directory.Users.List list, EqualsFilter equalsFilter) {
        if (AttributeUtil.namesEqual((String)equalsFilter.getName(), (String)"customer")) {
            if (null != list.getDomain()) {
                throw new InvalidAttributeValueException("The 'customer' and 'domain' can not be in the same query");
            }
            list.setCustomer(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (AttributeUtil.namesEqual((String)equalsFilter.getName(), (String)"domain")) {
            if (null != list.getCustomer()) {
                throw new InvalidAttributeValueException("The 'customer' and 'domain' can not be in the same query");
            }
            list.setDomain(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else {
            String filedName = NAME_DICTIONARY.get(equalsFilter.getName());
            if (null != filedName) {
                return this.getStringBuilder(equalsFilter.getAttribute(), '=', null, filedName);
            }
            throw new InvalidAttributeValueException("");
        }
        return null;
    }

    public StringBuilder visitEqualsIgnoreCaseFilter(Directory.Users.List list, EqualsIgnoreCaseFilter equalsFilter) {
        if (AttributeUtil.namesEqual((String)equalsFilter.getName(), (String)"customer")) {
            if (null != list.getDomain()) {
                throw new InvalidAttributeValueException("The 'customer' and 'domain' can not be in the same query");
            }
            list.setCustomer(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (AttributeUtil.namesEqual((String)equalsFilter.getName(), (String)"domain")) {
            if (null != list.getCustomer()) {
                throw new InvalidAttributeValueException("The 'customer' and 'domain' can not be in the same query");
            }
            list.setDomain(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else {
            String filedName = NAME_DICTIONARY.get(equalsFilter.getName());
            if (null != filedName) {
                return this.getStringBuilder(equalsFilter.getAttribute(), '=', null, filedName);
            }
            throw new InvalidAttributeValueException("");
        }
        return null;
    }

    public StringBuilder visitContainsAllValuesFilter(Directory.Users.List list, ContainsAllValuesFilter filter) {
        return null;
    }

    public StringBuilder visitExtendedFilter(Directory.Users.List list, Filter filter) {
        return null;
    }

    public StringBuilder visitGreaterThanFilter(Directory.Users.List list, GreaterThanFilter filter) {
        return null;
    }

    public StringBuilder visitGreaterThanOrEqualFilter(Directory.Users.List list, GreaterThanOrEqualFilter filter) {
        return null;
    }

    public StringBuilder visitLessThanFilter(Directory.Users.List list, LessThanFilter filter) {
        return null;
    }

    public StringBuilder visitLessThanOrEqualFilter(Directory.Users.List list, LessThanOrEqualFilter filter) {
        return null;
    }

    public StringBuilder visitNotFilter(Directory.Users.List list, NotFilter filter) {
        return null;
    }

    public StringBuilder visitOrFilter(Directory.Users.List list, OrFilter orFilter) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Filter filter : orFilter.getFilters()) {
            StringBuilder sb = (StringBuilder)filter.accept((FilterVisitor)this, (Object)list);
            if (null == sb) continue;
            if (!first) {
                builder.append(' ');
            } else {
                first = false;
            }
            builder.append((CharSequence)sb);
        }
        return builder;
    }

    public StringBuilder visitEndsWithFilter(Directory.Users.List list, EndsWithFilter filter) {
        return null;
    }

    public static ObjectClassInfo getObjectClassInfo(String customSchemasJSON) {
        ObjectClassInfoBuilder builder = new ObjectClassInfoBuilder();
        builder.addAttributeInfo(Name.INFO);
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"id").setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"givenName").setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"familyName").setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"fullName").setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"isAdmin", Boolean.TYPE));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"isDelegatedAdmin", Boolean.TYPE).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"lastLoginTime").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"creationTime").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"agreedToTerms", Boolean.TYPE).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)OperationalAttributes.PASSWORD_NAME, GuardedString.class).setRequired(true).setReadable(false).setReturnedByDefault(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"suspensionReason").setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"changePasswordAtNextLogin", Boolean.class));
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"ipWhitelisted", Boolean.class));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"externalIds", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"relations", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"organizations", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"phones", Map.class).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"aliases").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"nonEditableAliases").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"customerId").setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"orgUnitPath"));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"isMailboxSetup", Boolean.class).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"includeInGlobalAddressList", Boolean.class));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"thumbnailPhotoUrl").setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"deletionTime").setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"__PHOTO__", byte[].class).setReturnedByDefault(false).build());
        builder.addAttributeInfo(PredefinedAttributeInfos.GROUPS);
        if (StringUtil.isNotBlank((String)customSchemasJSON)) {
            List<GoogleAppsCustomSchema> customSchemas = GoogleAppsUtil.extractCustomSchemas(customSchemasJSON);
            for (GoogleAppsCustomSchema customSchema : customSchemas) {
                if (customSchema.getType().equals("object")) {
                    String basicName = customSchema.getName();
                    for (GoogleAppsCustomSchema innerSchema : customSchema.getInnerSchemas()) {
                        builder.addAttributeInfo(UserHandler.getAttributeInfoBuilder(basicName + "." + innerSchema.getName(), innerSchema).build());
                    }
                    continue;
                }
                LOG.warn("CustomSchema type {0} not allowed at this level", new Object[]{customSchema.getType()});
            }
        }
        return builder.build();
    }

    private static AttributeInfoBuilder getAttributeInfoBuilder(String name, GoogleAppsCustomSchema schema) {
        AttributeInfoBuilder attributeInfoBuilder = AttributeInfoBuilder.define((String)name);
        attributeInfoBuilder.setMultiValued(schema.getMultiValued().booleanValue());
        switch (schema.getType()) {
            case "string": {
                attributeInfoBuilder.setType(String.class);
                break;
            }
            case "boolean": {
                attributeInfoBuilder.setType(Boolean.class);
                break;
            }
            case "int": {
                attributeInfoBuilder.setType(Integer.class);
                break;
            }
        }
        return attributeInfoBuilder;
    }

    public static Directory.Users.Insert createUser(Directory.Users service, AttributesAccessor attributes, String customSchemas) {
        User user = new User();
        user.setPrimaryEmail(GoogleAppsUtil.getName(attributes.getName()));
        GuardedString password = attributes.getPassword();
        if (null == password) {
            throw new InvalidAttributeValueException("Missing required attribute '__PASSWORD__'");
        }
        user.setPassword(SecurityUtil.decrypt((GuardedString)password));
        user.setName(new UserName());
        String givenName = attributes.findString("givenName");
        if (!StringUtil.isNotBlank((String)givenName)) {
            throw new InvalidAttributeValueException("Missing required attribute 'givenName'.The user's first name. Required when creating a user account.");
        }
        user.getName().setGivenName(givenName);
        String familyName = attributes.findString("familyName");
        if (!StringUtil.isNotBlank((String)familyName)) {
            throw new InvalidAttributeValueException("Missing required attribute 'familyName'.The user's last name. Required when creating a user account.");
        }
        user.getName().setFamilyName(familyName);
        user.setEmails((Object)attributes.findList("emails"));
        user.setIms(UserHandler.buildObjs(attributes.findList("ims"), UserIm.class));
        user.setRelations(UserHandler.buildObjs(attributes.findList("relations"), UserRelation.class));
        user.setAddresses(UserHandler.buildObjs(attributes.findList("addresses"), UserAddress.class));
        user.setOrganizations(UserHandler.buildObjs(attributes.findList("organizations"), UserOrganization.class));
        user.setPhones(UserHandler.buildObjs(attributes.findList("phones"), UserPhone.class));
        user.setExternalIds(UserHandler.buildObjs(Optional.ofNullable(attributes.findList("externalIds")).orElse(null), UserExternalId.class));
        Optional.ofNullable(attributes.findBoolean(OperationalAttributes.ENABLE_NAME)).ifPresent(enable -> user.setSuspended(Boolean.valueOf(enable == false)));
        user.setChangePasswordAtNextLogin(attributes.findBoolean("changePasswordAtNextLogin"));
        user.setIpWhitelisted(attributes.findBoolean("ipWhitelisted"));
        user.setOrgUnitPath(attributes.findString("orgUnitPath"));
        user.setIncludeInGlobalAddressList(attributes.findBoolean("includeInGlobalAddressList"));
        if (StringUtil.isNotBlank((String)customSchemas)) {
            user.setCustomSchemas(UserHandler.buildCustomAttrs(customSchemas, attributes));
        }
        try {
            return service.insert(user).setFields("id,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Groups#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private static <T extends GenericData> List<T> buildObjs(List<Object> values, Class<T> clazz) {
        return values == null ? null : values.stream().map(v -> {
            GenericData obj = null;
            if (v instanceof String) {
                obj = (GenericData)GoogleAppsUtil.extract(v.toString(), clazz);
            } else {
                LOG.error("Unable to build obj from object {0}", new Object[]{v});
            }
            return obj;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Object getValueByType(GoogleAppsCustomSchema innerSchema, AttributesAccessor attributes, String innerSchemaName) {
        return innerSchema.getMultiValued() != false ? attributes.findStringList(innerSchemaName) : attributes.findString(innerSchemaName);
    }

    private static Map<String, Map<String, Object>> buildCustomAttrs(String customSchemas, AttributesAccessor attributes) {
        List<GoogleAppsCustomSchema> schemas = GoogleAppsUtil.extractCustomSchemas(customSchemas);
        HashMap<String, Map<String, Object>> attrsToAdd = new HashMap<String, Map<String, Object>>();
        for (GoogleAppsCustomSchema customSchema : schemas) {
            if (customSchema.getType().equals("object")) {
                String basicName = customSchema.getName();
                for (GoogleAppsCustomSchema innerSchema : customSchema.getInnerSchemas()) {
                    String innerSchemaName = basicName + "." + innerSchema.getName();
                    if (attrsToAdd.containsKey(basicName)) {
                        ((Map)attrsToAdd.get(basicName)).put(innerSchema.getName(), UserHandler.getValueByType(innerSchema, attributes, innerSchemaName));
                        continue;
                    }
                    HashMap<String, Object> value = new HashMap<String, Object>();
                    value.put(innerSchema.getName(), UserHandler.getValueByType(innerSchema, attributes, innerSchemaName));
                    attrsToAdd.put(basicName, value);
                }
                continue;
            }
            LOG.warn("CustomSchema type {0} not allowed at this level", new Object[]{customSchema.getType()});
        }
        return attrsToAdd;
    }

    private static void set(AtomicReference<User> content, Consumer<User> consumer) {
        if (content.get() == null) {
            content.set(new User());
        }
        consumer.accept(content.get());
    }

    public static Directory.Users.Patch updateUser(Directory.Users service, String userKey, AttributesAccessor attributes, String customSchemas) {
        AtomicReference<User> content = new AtomicReference<User>();
        Optional.ofNullable(attributes.getName()).filter(email -> email.getNameValue() != null).ifPresent(email -> UserHandler.set(content, u -> u.setPrimaryEmail(email.getNameValue())));
        Optional.ofNullable(attributes.findBoolean(OperationalAttributes.ENABLE_NAME)).ifPresent(enable -> UserHandler.set(content, u -> u.setSuspended(Boolean.valueOf(enable == false))));
        Optional.ofNullable(attributes.getPassword()).ifPresent(password -> UserHandler.set(content, u -> u.setPassword(SecurityUtil.decrypt((GuardedString)password))));
        Optional.ofNullable(attributes.find("givenName")).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> UserHandler.set(content, u -> {
            u.setName(new UserName());
            u.getName().setGivenName(stringValue);
        }));
        Optional.ofNullable(attributes.find("familyName")).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> UserHandler.set(content, u -> Optional.ofNullable(u.getName()).orElseGet(() -> {
            u.setName(new UserName());
            return u.getName();
        }).setFamilyName(stringValue)));
        Optional.ofNullable(attributes.find("changePasswordAtNextLogin")).flatMap(GoogleAppsUtil::getBooleanValue).ifPresent(booleanValue -> UserHandler.set(content, u -> u.setChangePasswordAtNextLogin(booleanValue)));
        Optional.ofNullable(attributes.find("ipWhitelisted")).flatMap(GoogleAppsUtil::getBooleanValue).ifPresent(booleanValue -> UserHandler.set(content, u -> u.setIpWhitelisted(booleanValue)));
        Optional.ofNullable(attributes.find("orgUnitPath")).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> UserHandler.set(content, u -> u.setOrgUnitPath(stringValue)));
        Optional.ofNullable(attributes.find("includeInGlobalAddressList")).flatMap(GoogleAppsUtil::getBooleanValue).ifPresent(booleanValue -> UserHandler.set(content, u -> u.setIncludeInGlobalAddressList(booleanValue)));
        Optional.ofNullable(attributes.find("emails")).ifPresent(emails -> UserHandler.set(content, u -> u.setEmails((Object)emails.getValue())));
        Optional.ofNullable(attributes.findList("ims")).ifPresent(value -> UserHandler.set(content, u -> u.setIms(UserHandler.buildObjs(value, UserIm.class))));
        Optional.ofNullable(attributes.findList("externalIds")).ifPresent(value -> UserHandler.set(content, u -> u.setExternalIds(UserHandler.buildObjs(value, UserExternalId.class))));
        Optional.ofNullable(attributes.findList("relations")).ifPresent(value -> UserHandler.set(content, u -> u.setRelations(UserHandler.buildObjs(value, UserRelation.class))));
        Optional.ofNullable(attributes.findList("addresses")).ifPresent(value -> UserHandler.set(content, u -> u.setAddresses(UserHandler.buildObjs(value, UserAddress.class))));
        Optional.ofNullable(attributes.findList("organizations")).ifPresent(value -> UserHandler.set(content, u -> u.setOrganizations(UserHandler.buildObjs(value, UserOrganization.class))));
        Optional.ofNullable(attributes.findList("phones")).ifPresent(value -> UserHandler.set(content, u -> u.setPhones(UserHandler.buildObjs(value, UserPhone.class))));
        if (StringUtil.isNotBlank((String)customSchemas)) {
            UserHandler.set(content, u -> u.setCustomSchemas(UserHandler.buildCustomAttrs(customSchemas, attributes)));
        }
        if (null == content.get()) {
            return null;
        }
        try {
            return service.patch(userKey, content.get()).setFields("id,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Users#Patch", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private static Object getValueByType(GoogleAppsCustomSchema innerSchema, Set<AttributeDelta> modifications, String innerSchemaName) {
        return Optional.ofNullable(AttributeDeltaUtil.find((String)innerSchemaName, modifications)).map(attrDelta -> innerSchema.getMultiValued() != false ? attrDelta.getValuesToReplace() : AttributeDeltaUtil.getStringValue((AttributeDelta)attrDelta)).orElse(null);
    }

    private static Map<String, Map<String, Object>> buildCustomAttrs(String customSchemas, Set<AttributeDelta> modifications) {
        List<GoogleAppsCustomSchema> schemas = GoogleAppsUtil.extractCustomSchemas(customSchemas);
        HashMap<String, Map<String, Object>> attrsToAdd = new HashMap<String, Map<String, Object>>();
        for (GoogleAppsCustomSchema customSchema : schemas) {
            if (customSchema.getType().equals("object")) {
                String basicName = customSchema.getName();
                for (GoogleAppsCustomSchema innerSchema : customSchema.getInnerSchemas()) {
                    String innerSchemaName = basicName + "." + innerSchema.getName();
                    if (attrsToAdd.containsKey(basicName)) {
                        ((Map)attrsToAdd.get(basicName)).put(innerSchema.getName(), UserHandler.getValueByType(innerSchema, modifications, innerSchemaName));
                        continue;
                    }
                    HashMap<String, Object> value = new HashMap<String, Object>();
                    value.put(innerSchema.getName(), UserHandler.getValueByType(innerSchema, modifications, innerSchemaName));
                    attrsToAdd.put(basicName, value);
                }
                continue;
            }
            LOG.warn("CustomSchema type {0} not allowed at this level", new Object[]{customSchema.getType()});
        }
        return attrsToAdd;
    }

    public static Directory.Users.Update updateUser(Directory.Users service, String userKey, Set<AttributeDelta> modifications, String customSchemas) {
        if (AttributeDeltaUtil.getUidAttributeDelta(modifications) != null || AttributeDeltaUtil.getAttributeDeltaForName(modifications) != null) {
            throw new IllegalArgumentException("Do not perform rename via updateDelta, use standard update");
        }
        AtomicReference<User> content = new AtomicReference<User>();
        Optional.ofNullable(AttributeDeltaUtil.find((String)OperationalAttributes.ENABLE_NAME, modifications)).flatMap(GoogleAppsUtil::getBooleanValue).ifPresent(enable -> UserHandler.set(content, u -> u.setSuspended(Boolean.valueOf(enable == false))));
        Optional.ofNullable(AttributeDeltaUtil.getPasswordValue(modifications)).ifPresent(password -> UserHandler.set(content, u -> u.setPassword(SecurityUtil.decrypt((GuardedString)password))));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"givenName", modifications)).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> UserHandler.set(content, u -> {
            u.setName(new UserName());
            u.getName().setGivenName(stringValue);
        }));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"familyName", modifications)).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> UserHandler.set(content, u -> Optional.ofNullable(u.getName()).orElseGet(() -> {
            u.setName(new UserName());
            return u.getName();
        }).setFamilyName(stringValue)));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"changePasswordAtNextLogin", modifications)).flatMap(GoogleAppsUtil::getBooleanValue).ifPresent(booleanValue -> UserHandler.set(content, u -> u.setChangePasswordAtNextLogin(booleanValue)));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"ipWhitelisted", modifications)).flatMap(GoogleAppsUtil::getBooleanValue).ifPresent(booleanValue -> UserHandler.set(content, u -> u.setIpWhitelisted(booleanValue)));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"orgUnitPath", modifications)).flatMap(GoogleAppsUtil::getStringValue).ifPresent(stringValue -> UserHandler.set(content, u -> u.setOrgUnitPath(stringValue)));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"includeInGlobalAddressList", modifications)).flatMap(GoogleAppsUtil::getBooleanValue).ifPresent(booleanValue -> UserHandler.set(content, u -> u.setIncludeInGlobalAddressList(booleanValue)));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"emails", modifications)).ifPresent(a -> UserHandler.set(content, u -> u.setEmails((Object)a.getValuesToReplace())));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"ims", modifications)).ifPresent(a -> UserHandler.set(content, u -> u.setIms(UserHandler.buildObjs(a.getValuesToReplace(), UserIm.class))));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"externalIds", modifications)).ifPresent(a -> UserHandler.set(content, u -> u.setExternalIds(UserHandler.buildObjs(a.getValuesToReplace(), UserExternalId.class))));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"relations", modifications)).ifPresent(a -> UserHandler.set(content, u -> u.setRelations(UserHandler.buildObjs(a.getValuesToReplace(), UserRelation.class))));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"addresses", modifications)).ifPresent(a -> UserHandler.set(content, u -> u.setAddresses(UserHandler.buildObjs(a.getValuesToReplace(), UserAddress.class))));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"organizations", modifications)).ifPresent(a -> UserHandler.set(content, u -> u.setOrganizations(UserHandler.buildObjs(a.getValuesToReplace(), UserOrganization.class))));
        Optional.ofNullable(AttributeDeltaUtil.find((String)"phones", modifications)).ifPresent(a -> UserHandler.set(content, u -> u.setPhones(UserHandler.buildObjs(a.getValuesToReplace(), UserPhone.class))));
        if (StringUtil.isNotBlank((String)customSchemas)) {
            UserHandler.set(content, u -> u.setCustomSchemas(UserHandler.buildCustomAttrs(customSchemas, modifications)));
        }
        if (null == content.get()) {
            return null;
        }
        try {
            return service.update(userKey, content.get()).setFields("id,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Users#update", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Users.Photos.Update createUpdateUserPhoto(Directory.Users.Photos service, String userKey, byte[] data) {
        UserPhoto content = new UserPhoto();
        content.setPhotoData(Base64.getMimeEncoder().encodeToString(data));
        try {
            return service.update(userKey, content).setFields("id");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Aliases#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Set<String> listAliases(Directory.Users.Aliases service, final String userKey) {
        try {
            return GoogleApiExecutor.execute(service.list(userKey), new RequestResultHandler<Directory.Users.Aliases.List, Aliases, Set<String>>(){

                @Override
                public Set<String> handleResult(Directory.Users.Aliases.List request, Aliases value) {
                    return Optional.ofNullable(value.getAliases()).map(aliases -> aliases.stream().map(map -> (String)((Map)map).get("alias")).filter(Objects::nonNull).collect(Collectors.toSet())).orElse(Collections.emptySet());
                }

                @Override
                public Set<String> handleError(Throwable e) {
                    LOG.error(e, "While getting aliases for {0}", new Object[]{userKey});
                    return Collections.emptySet();
                }
            });
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Aliases#list", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Users.Aliases.Insert createUserAlias(Directory.Users.Aliases service, String userKey, String alias) {
        Alias content = new Alias();
        content.setAlias(alias);
        try {
            return service.insert(userKey, content).setFields("id,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Aliases#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Users.Aliases.Delete deleteUserAlias(Directory.Users.Aliases service, String userKey, String alias) {
        try {
            return service.delete(userKey, alias);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Aliases#Delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private static Object getValueFromKey(String customSchema, Map<String, Map<String, Object>> customSchemas) {
        String[] names = customSchema.split("\\.");
        return names.length > 1 ? (customSchemas.get(names[0]) != null ? customSchemas.get(names[0]).get(names[1]) : null) : null;
    }

    public static ConnectorObject fromUser(GoogleAppsConfiguration configuration, User user, Set<String> attributesToGet, Directory.Groups service) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        if (null != user.getEtag()) {
            builder.setUid(new Uid(user.getId(), user.getEtag()));
        } else {
            builder.setUid(user.getId());
        }
        builder.setName(user.getPrimaryEmail());
        Optional.ofNullable(user.getSuspended()).ifPresent(suspended -> builder.addAttribute(new Attribute[]{AttributeBuilder.buildEnabled((suspended == false ? 1 : 0) != 0)}));
        if (null == attributesToGet || attributesToGet.contains("id")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"id", (Object[])new Object[]{user.getId()})});
        }
        if (null == attributesToGet || attributesToGet.contains("primaryEmail")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"primaryEmail", (Object[])new Object[]{user.getPrimaryEmail()})});
        }
        if (null == attributesToGet || attributesToGet.contains("givenName")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"givenName", (Object[])new Object[]{null != user.getName() ? user.getName().getGivenName() : null})});
        }
        if (null == attributesToGet || attributesToGet.contains("familyName")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"familyName", (Object[])new Object[]{null != user.getName() ? user.getName().getFamilyName() : null})});
        }
        if (null == attributesToGet || attributesToGet.contains("fullName")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"fullName", (Object[])new Object[]{null != user.getName() ? user.getName().getFullName() : null})});
        }
        if (null == attributesToGet || attributesToGet.contains("isAdmin")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"isAdmin", (Object[])new Object[]{user.getIsAdmin()})});
        }
        if (null == attributesToGet || attributesToGet.contains("isDelegatedAdmin")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"isDelegatedAdmin", (Object[])new Object[]{user.getIsDelegatedAdmin()})});
        }
        if ((null == attributesToGet || attributesToGet.contains("lastLoginTime")) && user.getLastLoginTime() != null) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"lastLoginTime", (Object[])new Object[]{user.getLastLoginTime().toString()})});
        }
        if ((null == attributesToGet || attributesToGet.contains("creationTime")) && user.getCreationTime() != null) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"creationTime", (Object[])new Object[]{user.getCreationTime().toString()})});
        }
        if (null == attributesToGet || attributesToGet.contains("agreedToTerms")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"agreedToTerms", (Object[])new Object[]{user.getAgreedToTerms()})});
        }
        if (null == attributesToGet || attributesToGet.contains("suspensionReason")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"suspensionReason", (Object[])new Object[]{user.getSuspensionReason()})});
        }
        if (null == attributesToGet || attributesToGet.contains("changePasswordAtNextLogin")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"changePasswordAtNextLogin", (Object[])new Object[]{user.getChangePasswordAtNextLogin()})});
        }
        if (null == attributesToGet || attributesToGet.contains("ipWhitelisted")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"ipWhitelisted", (Object[])new Object[]{user.getIpWhitelisted()})});
        }
        if (null == attributesToGet || attributesToGet.contains("ims")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"ims", (Collection)((Collection)user.getIms()))});
        }
        if (null == attributesToGet || attributesToGet.contains("emails")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"emails", (Collection)((Collection)user.getEmails()))});
        }
        if (null == attributesToGet || attributesToGet.contains("externalIds")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"externalIds", (Collection)((Collection)user.getExternalIds()))});
        }
        if (null == attributesToGet || attributesToGet.contains("relations")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"relations", (Collection)((Collection)user.getRelations()))});
        }
        if (null == attributesToGet || attributesToGet.contains("addresses")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"addresses", (Collection)((Collection)user.getAddresses()))});
        }
        if (null == attributesToGet || attributesToGet.contains("organizations")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"organizations", (Collection)((Collection)user.getOrganizations()))});
        }
        if (null == attributesToGet || attributesToGet.contains("phones")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"phones", (Collection)((Collection)user.getPhones()))});
        }
        if (null == attributesToGet || attributesToGet.contains("aliases")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"aliases", (Collection)user.getAliases())});
        }
        if (null == attributesToGet || attributesToGet.contains("nonEditableAliases")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"nonEditableAliases", (Collection)user.getNonEditableAliases())});
        }
        if (null == attributesToGet || attributesToGet.contains("customerId")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"customerId", (Object[])new Object[]{user.getCustomerId()})});
        }
        if (null == attributesToGet || attributesToGet.contains("orgUnitPath")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"orgUnitPath", (Object[])new Object[]{user.getOrgUnitPath()})});
        }
        if (null == attributesToGet || attributesToGet.contains("isMailboxSetup")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"isMailboxSetup", (Object[])new Object[]{user.getIsMailboxSetup()})});
        }
        if (null == attributesToGet || attributesToGet.contains("includeInGlobalAddressList")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"includeInGlobalAddressList", (Object[])new Object[]{user.getIncludeInGlobalAddressList()})});
        }
        if (null == attributesToGet || attributesToGet.contains("thumbnailPhotoUrl")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"thumbnailPhotoUrl", (Object[])new Object[]{user.getThumbnailPhotoUrl()})});
        }
        if (null == attributesToGet || attributesToGet.contains("deletionTime")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"deletionTime", (Object[])new Object[]{null != user.getDeletionTime() ? user.getDeletionTime().toString() : null})});
        }
        if (null == attributesToGet || "full".equals(configuration.getProjection()) && StringUtil.isNotBlank((String)configuration.getCustomSchemasJSON())) {
            GoogleAppsUtil.extractCustomSchemas(configuration.getCustomSchemasJSON()).forEach(customSchema -> {
                if (customSchema.getType().equals("object")) {
                    for (GoogleAppsCustomSchema innerSchema : customSchema.getInnerSchemas()) {
                        String innerSchemaName = customSchema.getName() + "." + innerSchema.getName();
                        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)innerSchemaName, (Object[])new Object[]{null != user.getCustomSchemas() ? UserHandler.getValueFromKey(innerSchemaName, user.getCustomSchemas()) : null})});
                    }
                } else {
                    LOG.warn("CustomSchema type {0} not allowed at this level", new Object[]{customSchema.getType()});
                }
            });
        }
        if (null != attributesToGet && attributesToGet.contains(PredefinedAttributes.GROUPS_NAME)) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)PredefinedAttributes.GROUPS_NAME, GroupHandler.listGroups(service, user.getId(), configuration.getDomain()))});
        }
        return builder.build();
    }

    static {
        SortedMap dictionary = CollectionUtil.newCaseInsensitiveMap();
        dictionary.put(Uid.NAME, Uid.NAME);
        dictionary.put("email", "email");
        dictionary.put(Name.NAME, "email");
        dictionary.put("givenName", "givenName");
        dictionary.put("familyName", "familyName");
        dictionary.put("isAdmin", "isAdmin");
        dictionary.put("isDelegatedAdmin", "isDelegatedAdmin");
        dictionary.put("isSuspended", "isSuspended");
        dictionary.put("im", "im");
        dictionary.put("externalId", "externalId");
        dictionary.put("manager", "manager");
        dictionary.put("managerId", "managerId");
        dictionary.put("directManager", "directManager");
        dictionary.put("directManagerId", "directManagerId");
        dictionary.put("address", "address");
        dictionary.put("addressPoBox", "addressPoBox");
        dictionary.put("address/poBox", "addressPoBox");
        dictionary.put("addressExtended", "addressExtended");
        dictionary.put("address/extended", "addressExtended");
        dictionary.put("addressStreet", "addressStreet");
        dictionary.put("address/street", "addressStreet");
        dictionary.put("addressLocality", "addressLocality");
        dictionary.put("address/locality", "addressLocality");
        dictionary.put("addressRegion", "addressRegion");
        dictionary.put("address/region", "addressRegion");
        dictionary.put("addressPostalCode", "addressPostalCode");
        dictionary.put("address/postalCode", "addressPostalCode");
        dictionary.put("addressCountry", "addressCountry");
        dictionary.put("address/country", "addressCountry");
        dictionary.put("orgName", "orgName");
        dictionary.put("organizations/name", "orgName");
        NAME_DICTIONARY = dictionary;
        SortedSet s = CollectionUtil.newCaseInsensitiveSet();
        s.add(Name.NAME);
        s.add("email");
        s.add("givenName");
        s.add("familyName");
        SW = CollectionUtil.newCaseInsensitiveSet();
        SW.addAll(s);
        s.add("im");
        s.add("externalId");
        s.add("address");
        s.add("addressPoBox");
        s.add("addressExtended");
        s.add("addressStreet");
        s.add("addressLocality");
        s.add("addressRegion");
        s.add("addressPostalCode");
        s.add("addressCountry");
        s.add("orgName");
        s.add("orgTitle");
        s.add("orgDepartment");
        s.add("orgDescription");
        s.add("orgCostCenter");
        S = s;
        STRING_ESCAPER = Escapers.builder().addEscape('\'', "\\'").build();
    }
}

