/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.bucket4j.producer;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Refill;
import io.github.bucket4j.local.LocalBucketBuilder;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apereo.cas.bucket4j.producer.BucketStore;
import org.apereo.cas.configuration.model.support.bucket4j.BaseBucket4jProperties;
import org.apereo.cas.configuration.support.Beans;

public class InMemoryBucketStore
implements BucketStore {
    private final Map<String, AbstractBucket> store = new ConcurrentHashMap<String, AbstractBucket>();
    private final BaseBucket4jProperties properties;

    @Override
    public AbstractBucket obtainBucket(String key) {
        return this.store.computeIfAbsent(key, k -> (AbstractBucket)this.getBucketLimits().build());
    }

    private LocalBucketBuilder getBucketLimits() {
        LocalBucketBuilder builder = Bucket.builder().withNanosecondPrecision();
        this.properties.getBandwidth().stream().map(bandwidth -> {
            Bandwidth limit = null;
            switch (bandwidth.getRefillStrategy()) {
                case INTERVALLY: {
                    limit = Bandwidth.classic((long)bandwidth.getCapacity(), (Refill)Refill.intervally((long)bandwidth.getRefillCount(), (Duration)Beans.newDuration((String)bandwidth.getRefillDuration())));
                    break;
                }
                default: {
                    limit = Bandwidth.simple((long)bandwidth.getCapacity(), (Duration)Beans.newDuration((String)bandwidth.getDuration())).withInitialTokens(bandwidth.getInitialTokens() <= 0L ? bandwidth.getCapacity() : bandwidth.getInitialTokens());
                }
            }
            limit = limit.withInitialTokens(bandwidth.getInitialTokens() <= 0L ? bandwidth.getCapacity() : bandwidth.getInitialTokens());
            return limit;
        }).forEach(arg_0 -> ((LocalBucketBuilder)builder).addLimit(arg_0));
        return builder;
    }

    @Generated
    public InMemoryBucketStore(BaseBucket4jProperties properties) {
        this.properties = properties;
    }
}

