/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.token.cipher.JwtTicketCipherExecutor;
import org.apereo.cas.token.cipher.RegisteredServiceJwtTicketCipherExecutor;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.lang.Nullable;

@Endpoint(id="jwtTicketSigningPublicKey", enableByDefault=false)
public class JwtTokenCipherSigningPublicKeyEndpoint
extends BaseCasActuatorEndpoint {
    private final CipherExecutor tokenCipherExecutor;
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    public JwtTokenCipherSigningPublicKeyEndpoint(CasConfigurationProperties casProperties, CipherExecutor tokenCipherExecutor, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
        super(casProperties);
        this.tokenCipherExecutor = tokenCipherExecutor;
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }

    @ReadOperation(produces={"text/plain"})
    @Operation(summary="Get public key for signing operations", parameters={@Parameter(name="service")})
    public String fetchPublicKey(@Nullable String service) throws Exception {
        Key signingKey = this.tokenCipherExecutor.getSigningKey();
        if (StringUtils.isNotBlank((CharSequence)service)) {
            JwtTicketCipherExecutor cipher;
            RegisteredService registeredService = this.servicesManager.findServiceBy(this.webApplicationServiceFactory.createService(service));
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
            RegisteredServiceJwtTicketCipherExecutor serviceCipher = new RegisteredServiceJwtTicketCipherExecutor();
            if (serviceCipher.supports(registeredService) && (cipher = serviceCipher.getTokenTicketCipherExecutorForService(registeredService)).isEnabled()) {
                signingKey = cipher.getSigningKey();
            }
        }
        if (signingKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaSigningKey = (RSAPrivateCrtKey)signingKey;
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = factory.generatePublic(new RSAPublicKeySpec(rsaSigningKey.getModulus(), rsaSigningKey.getPublicExponent()));
            return EncodingUtils.encodeBase64((byte[])publicKey.getEncoded());
        }
        return null;
    }
}

