/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.util.model.TriStateBoolean;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;

public class ChainingSingleSignOnParticipationStrategy
implements SingleSignOnParticipationStrategy {
    private final List<SingleSignOnParticipationStrategy> providers = new ArrayList<SingleSignOnParticipationStrategy>(0);

    public void addStrategy(SingleSignOnParticipationStrategy provider) {
        this.providers.add(provider);
    }

    public void addStrategy(List<SingleSignOnParticipationStrategy> provider) {
        this.providers.addAll(provider);
    }

    public boolean isParticipating(SingleSignOnParticipationRequest ssoRequest) {
        List<SingleSignOnParticipationStrategy> supporters = this.getSupportingSingleSignOnParticipationStrategies(ssoRequest);
        if (supporters.isEmpty()) {
            return SingleSignOnParticipationStrategy.alwaysParticipating().isParticipating(ssoRequest);
        }
        return supporters.stream().allMatch(p -> p.isParticipating(ssoRequest));
    }

    public boolean supports(SingleSignOnParticipationRequest ssoRequest) {
        return this.providers.stream().anyMatch(p -> p.supports(ssoRequest));
    }

    public TriStateBoolean isCreateCookieOnRenewedAuthentication(SingleSignOnParticipationRequest context) {
        List<SingleSignOnParticipationStrategy> supporters = this.getSupportingSingleSignOnParticipationStrategies(context);
        boolean result = supporters.stream().allMatch(p -> {
            TriStateBoolean createCookieOnRenewedAuthentication = p.isCreateCookieOnRenewedAuthentication(context);
            return createCookieOnRenewedAuthentication.isTrue() || createCookieOnRenewedAuthentication.isUndefined();
        });
        return TriStateBoolean.fromBoolean((boolean)result);
    }

    private List<SingleSignOnParticipationStrategy> getSupportingSingleSignOnParticipationStrategies(SingleSignOnParticipationRequest context) {
        return this.providers.stream().filter(p -> p.supports(context)).collect(Collectors.toList());
    }

    @Generated
    public ChainingSingleSignOnParticipationStrategy() {
    }
}

