/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.LinkedAccountUR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.UserPullResultHandler;
import org.apache.syncope.core.provisioning.api.rules.PullMatch;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractPullResultHandler;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultUserPullResultHandler
extends AbstractPullResultHandler
implements UserPullResultHandler {
    @Autowired
    private UserProvisioningManager userProvisioningManager;

    @Override
    protected AnyUtils getAnyUtils() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
    }

    @Override
    protected String getName(AnyTO anyTO) {
        return ((UserTO)UserTO.class.cast(anyTO)).getUsername();
    }

    @Override
    protected String getName(AnyCR anyCR) {
        return ((UserCR)UserCR.class.cast(anyCR)).getUsername();
    }

    @Override
    protected ProvisioningManager<?, ?> getProvisioningManager() {
        return this.userProvisioningManager;
    }

    @Override
    protected AnyTO getAnyTO(Any<?> any) {
        return this.userDataBinder.getUserTO((User)any, true);
    }

    @Override
    protected WorkflowResult<? extends AnyUR> update(AnyUR req) {
        UserWorkflowResult update = this.uwfAdapter.update((UserUR)req, null, this.profile.getExecutor(), this.getContext());
        return new WorkflowResult((Object)((UserUR)((Pair)update.getResult()).getLeft()), update.getPropByRes(), update.getPerformedTasks());
    }

    protected Boolean enabled(SyncDelta delta) {
        return ((PullTask)this.profile.getTask()).isSyncStatus() ? AttributeUtil.isEnabled((ConnectorObject)delta.getObject()) : null;
    }

    @Override
    protected AnyTO doCreate(AnyCR anyCR, SyncDelta delta) {
        Pair created = this.userProvisioningManager.create((UserCR)UserCR.class.cast(anyCR), true, this.enabled(delta), Set.of(((PullTask)this.profile.getTask()).getResource().getKey()), true, this.profile.getExecutor(), this.getContext());
        return this.userDataBinder.getUserTO((String)created.getKey());
    }

    @Override
    protected AnyUR doUpdate(AnyTO before, AnyUR req, SyncDelta delta, ProvisioningReport result) {
        Pair updated = this.userProvisioningManager.update((UserUR)UserUR.class.cast(req), result, this.enabled(delta), Set.of(((PullTask)this.profile.getTask()).getResource().getKey()), true, this.profile.getExecutor(), this.getContext());
        this.createRemediationIfNeeded(req, delta, result);
        return (AnyUR)updated.getLeft();
    }

    @Override
    protected AuditElements.Result handleLinkedAccounts(SyncDelta delta, List<PullMatch> matches, Provision provision) throws JobExecutionException {
        AuditElements.Result global = AuditElements.Result.SUCCESS;
        for (PullMatch match : matches) {
            if (match.getAny() == null) {
                LOG.error("Could not find linking user, cannot process match {}", (Object)match);
                return AuditElements.Result.FAILURE;
            }
            User user = (User)match.getAny();
            Optional found = user.getLinkedAccount(((PullTask)this.profile.getTask()).getResource().getKey(), delta.getUid().getUidValue());
            if (found.isPresent()) {
                LinkedAccount account = (LinkedAccount)found.get();
                block0 : switch (delta.getDeltaType()) {
                    case CREATE: 
                    case UPDATE: 
                    case CREATE_OR_UPDATE: {
                        switch (((PullTask)this.profile.getTask()).getMatchingRule()) {
                            case UPDATE: {
                                global = DefaultUserPullResultHandler.and(global, this.update(delta, account, provision));
                                break block0;
                            }
                            case DEPROVISION: 
                            case UNASSIGN: {
                                global = DefaultUserPullResultHandler.and(global, this.deprovision(((PullTask)this.profile.getTask()).getMatchingRule(), delta, account));
                                break block0;
                            }
                            case LINK: 
                            case UNLINK: {
                                LOG.warn("{} not applicable to linked accounts, ignoring", (Object)((PullTask)this.profile.getTask()).getMatchingRule());
                                break block0;
                            }
                            case IGNORE: {
                                global = DefaultUserPullResultHandler.and(global, this.ignore(delta, account, true, new String[0]));
                                break block0;
                            }
                        }
                        break;
                    }
                    case DELETE: {
                        global = DefaultUserPullResultHandler.and(global, this.delete(delta, account, provision));
                        break;
                    }
                }
                continue;
            }
            block10 : switch (delta.getDeltaType()) {
                case CREATE: 
                case UPDATE: 
                case CREATE_OR_UPDATE: {
                    LinkedAccountTO accountTO = new LinkedAccountTO();
                    accountTO.setConnObjectKeyValue(delta.getUid().getUidValue());
                    accountTO.setResource(((PullTask)this.profile.getTask()).getResource().getKey());
                    switch (((PullTask)this.profile.getTask()).getUnmatchingRule()) {
                        case ASSIGN: 
                        case PROVISION: {
                            global = DefaultUserPullResultHandler.and(global, this.provision(((PullTask)this.profile.getTask()).getUnmatchingRule(), delta, user, accountTO, provision));
                            break block10;
                        }
                        case IGNORE: {
                            global = DefaultUserPullResultHandler.and(global, this.ignore(delta, null, false, new String[0]));
                            break block10;
                        }
                    }
                    break;
                }
                case DELETE: {
                    this.end(AnyTypeKind.USER.name(), ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
                    LOG.debug("No match found for deletion");
                    break;
                }
            }
        }
        return global;
    }

    protected AuditElements.Result deprovision(MatchingRule matchingRule, SyncDelta delta, LinkedAccount account) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(AnyTypeKind.USER.name(), MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return AuditElements.Result.SUCCESS;
        }
        LOG.debug("About to deprovision {}", (Object)account);
        ProvisioningReport report = new ProvisioningReport();
        report.setOperation(ResourceOperation.DELETE);
        report.setAnyType(MatchType.LINKED_ACCOUNT.name());
        report.setStatus(ProvisioningReport.Status.SUCCESS);
        report.setKey(account.getKey());
        report.setUidValue(account.getConnObjectKeyValue());
        LinkedAccountTO before = this.userDataBinder.getLinkedAccountTO(account);
        AuditElements.Result resultStatus = AuditElements.Result.SUCCESS;
        if (!this.profile.isDryRun()) {
            Object output = before;
            try {
                if (matchingRule == MatchingRule.UNASSIGN) {
                    for (PullActions action : this.profile.getActions()) {
                        action.beforeUnassign(this.profile, delta, (EntityTO)before);
                    }
                } else if (matchingRule == MatchingRule.DEPROVISION) {
                    for (PullActions action : this.profile.getActions()) {
                        action.beforeDeprovision(this.profile, delta, (EntityTO)before);
                    }
                }
                PropagationByResource propByLinkedAccount = new PropagationByResource();
                propByLinkedAccount.add(ResourceOperation.DELETE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue()));
                this.taskExecutor.execute((Collection)this.propagationManager.getDeleteTasks(AnyTypeKind.USER, account.getOwner().getKey(), null, propByLinkedAccount, null), false, this.profile.getExecutor());
                for (PullActions action : this.profile.getActions()) {
                    action.after(this.profile, delta, (EntityTO)before, report);
                }
                resultStatus = AuditElements.Result.SUCCESS;
                LOG.debug("Linked account {} successfully updated", (Object)account.getConnObjectKeyValue());
            }
            catch (PropagationException e) {
                LOG.error("Could not propagate linked acccount {}", (Object)account.getConnObjectKeyValue());
                output = e;
                resultStatus = AuditElements.Result.FAILURE;
            }
            catch (Exception e) {
                this.throwIgnoreProvisionException(delta, e);
                report.setStatus(ProvisioningReport.Status.FAILURE);
                report.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOG.error("Could not update linked account {}", (Object)account, (Object)e);
                output = e;
                resultStatus = AuditElements.Result.FAILURE;
            }
            this.end(AnyTypeKind.USER.name(), MatchingRule.toEventName((MatchingRule)matchingRule), resultStatus, before, output, delta, new Object[0]);
            this.profile.getResults().add(report);
        }
        return resultStatus;
    }

    protected AuditElements.Result provision(UnmatchingRule rule, SyncDelta delta, User user, LinkedAccountTO accountTO, Provision provision) throws JobExecutionException {
        AuditElements.Result resultStatus;
        Throwable output;
        ProvisioningReport report;
        block12: {
            if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
                LOG.debug("PullTask not configured for create");
                this.end(AnyTypeKind.USER.name(), UnmatchingRule.toEventName((UnmatchingRule)rule), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
                return AuditElements.Result.SUCCESS;
            }
            LOG.debug("About to create {}", (Object)accountTO);
            report = new ProvisioningReport();
            report.setOperation(ResourceOperation.CREATE);
            report.setName(accountTO.getConnObjectKeyValue());
            report.setUidValue(accountTO.getConnObjectKeyValue());
            report.setAnyType(MatchType.LINKED_ACCOUNT.name());
            report.setStatus(ProvisioningReport.Status.SUCCESS);
            if (this.profile.isDryRun()) {
                report.setKey(null);
                this.end(AnyTypeKind.USER.name(), UnmatchingRule.toEventName((UnmatchingRule)rule), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
                return AuditElements.Result.SUCCESS;
            }
            UserTO owner = this.userDataBinder.getUserTO(user, false);
            UserCR connObject = (UserCR)this.connObjectUtils.getAnyCR(delta.getObject(), (PullTask)this.profile.getTask(), AnyTypeKind.USER, provision, false);
            if (connObject.getUsername().equals(owner.getUsername())) {
                accountTO.setUsername(null);
            } else if (!connObject.getUsername().equals(accountTO.getUsername())) {
                accountTO.setUsername(connObject.getUsername());
            }
            if (connObject.getPassword() != null) {
                accountTO.setPassword(connObject.getPassword());
            }
            accountTO.setSuspended(BooleanUtils.isTrue((Boolean)BooleanUtils.negate((Boolean)this.enabled(delta))));
            connObject.getPlainAttrs().forEach(connObjectAttr -> {
                Optional ownerAttr = owner.getPlainAttr(connObjectAttr.getSchema());
                if (ownerAttr.isPresent() && ((Attr)ownerAttr.get()).getValues().equals(connObjectAttr.getValues())) {
                    accountTO.getPlainAttrs().removeIf(attr -> connObjectAttr.getSchema().equals(attr.getSchema()));
                } else {
                    accountTO.getPlainAttrs().add(connObjectAttr);
                }
            });
            for (PullActions action : this.profile.getActions()) {
                if (rule == UnmatchingRule.ASSIGN) {
                    action.beforeAssign(this.profile, delta, accountTO);
                    continue;
                }
                if (rule != UnmatchingRule.PROVISION) continue;
                action.beforeProvision(this.profile, delta, accountTO);
            }
            report.setName(accountTO.getConnObjectKeyValue());
            UserUR req = new UserUR();
            req.setKey(user.getKey());
            req.getLinkedAccounts().add((LinkedAccountUR)((LinkedAccountUR.Builder)new LinkedAccountUR.Builder().operation(PatchOperation.ADD_REPLACE)).linkedAccountTO(accountTO).build());
            try {
                this.userProvisioningManager.update(req, report, null, Set.of(((PullTask)this.profile.getTask()).getResource().getKey()), true, this.profile.getExecutor(), this.getContext());
                LinkedAccountTO created = ((User)this.userDAO.find(req.getKey())).getLinkedAccount(accountTO.getResource(), accountTO.getConnObjectKeyValue()).map(acct -> this.userDataBinder.getLinkedAccountTO(acct)).orElse(null);
                output = created;
                resultStatus = AuditElements.Result.SUCCESS;
                for (PullActions action : this.profile.getActions()) {
                    action.after(this.profile, delta, (EntityTO)created, report);
                }
                LOG.debug("Linked account {} successfully created", (Object)accountTO.getConnObjectKeyValue());
            }
            catch (PropagationException e) {
                LOG.error("Could not propagate linked acccount {}", (Object)accountTO.getConnObjectKeyValue());
                output = e;
                resultStatus = AuditElements.Result.FAILURE;
            }
            catch (Exception e) {
                this.throwIgnoreProvisionException(delta, e);
                report.setStatus(ProvisioningReport.Status.FAILURE);
                report.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOG.error("Could not create linked account {} ", (Object)accountTO.getConnObjectKeyValue(), (Object)e);
                output = e;
                resultStatus = AuditElements.Result.FAILURE;
                if (!((PullTask)this.profile.getTask()).isRemediation()) break block12;
                this.createRemediation(provision.getAnyType(), null, null, (AnyUR)req, report, delta);
            }
        }
        this.end(AnyTypeKind.USER.name(), UnmatchingRule.toEventName((UnmatchingRule)rule), resultStatus, null, output, delta, new Object[0]);
        this.profile.getResults().add(report);
        return resultStatus;
    }

    protected AuditElements.Result update(SyncDelta delta, LinkedAccount account, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(AnyTypeKind.USER.name(), MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return AuditElements.Result.SUCCESS;
        }
        LOG.debug("About to update {}", (Object)account);
        ProvisioningReport report = new ProvisioningReport();
        report.setOperation(ResourceOperation.UPDATE);
        report.setKey(account.getKey());
        report.setUidValue(account.getConnObjectKeyValue());
        report.setName(account.getConnObjectKeyValue());
        report.setAnyType(MatchType.LINKED_ACCOUNT.name());
        report.setStatus(ProvisioningReport.Status.SUCCESS);
        AuditElements.Result resultStatus = AuditElements.Result.SUCCESS;
        if (!this.profile.isDryRun()) {
            Throwable output;
            LinkedAccountTO before;
            block11: {
                before = this.userDataBinder.getLinkedAccountTO(account);
                UserTO owner = this.userDataBinder.getUserTO(account.getOwner(), false);
                UserCR connObject = (UserCR)this.connObjectUtils.getAnyCR(delta.getObject(), (PullTask)this.profile.getTask(), AnyTypeKind.USER, provision, false);
                LinkedAccountTO update = this.userDataBinder.getLinkedAccountTO(account);
                if (connObject.getUsername().equals(owner.getUsername())) {
                    update.setUsername(null);
                } else if (!connObject.getUsername().equals(update.getUsername())) {
                    update.setUsername(connObject.getUsername());
                }
                if (connObject.getPassword() != null) {
                    update.setPassword(connObject.getPassword());
                }
                update.setSuspended(BooleanUtils.isTrue((Boolean)BooleanUtils.negate((Boolean)this.enabled(delta))));
                HashSet attrsToRemove = new HashSet();
                connObject.getPlainAttrs().forEach(connObjectAttr -> {
                    Optional ownerAttr = owner.getPlainAttr(connObjectAttr.getSchema());
                    if (ownerAttr.isPresent() && ((Attr)ownerAttr.get()).getValues().equals(connObjectAttr.getValues())) {
                        attrsToRemove.add(connObjectAttr.getSchema());
                    } else {
                        Optional updateAttr = update.getPlainAttr(connObjectAttr.getSchema());
                        if (updateAttr.isEmpty() || !((Attr)updateAttr.get()).getValues().equals(connObjectAttr.getValues())) {
                            attrsToRemove.add(connObjectAttr.getSchema());
                            update.getPlainAttrs().add(connObjectAttr);
                        }
                    }
                });
                update.getPlainAttrs().removeIf(attr -> attrsToRemove.contains(attr.getSchema()));
                UserUR userUR = new UserUR();
                userUR.setKey(account.getOwner().getKey());
                userUR.getLinkedAccounts().add((LinkedAccountUR)((LinkedAccountUR.Builder)new LinkedAccountUR.Builder().operation(PatchOperation.ADD_REPLACE)).linkedAccountTO(update).build());
                for (PullActions action : this.profile.getActions()) {
                    action.beforeUpdate(this.profile, delta, (EntityTO)before, (AnyUR)userUR);
                }
                try {
                    this.userProvisioningManager.update(userUR, report, null, Set.of(((PullTask)this.profile.getTask()).getResource().getKey()), true, this.profile.getExecutor(), this.getContext());
                    resultStatus = AuditElements.Result.SUCCESS;
                    LinkedAccountTO updated = ((User)this.userDAO.find(userUR.getKey())).getLinkedAccount(account.getResource().getKey(), account.getConnObjectKeyValue()).map(acct -> this.userDataBinder.getLinkedAccountTO(acct)).orElse(null);
                    output = updated;
                    for (PullActions action : this.profile.getActions()) {
                        action.after(this.profile, delta, (EntityTO)updated, report);
                    }
                    LOG.debug("Linked account {} successfully updated", (Object)account.getConnObjectKeyValue());
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate linked acccount {}", (Object)account.getConnObjectKeyValue());
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                catch (Exception e) {
                    this.throwIgnoreProvisionException(delta, e);
                    report.setStatus(ProvisioningReport.Status.FAILURE);
                    report.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOG.error("Could not update linked account {}", (Object)account, (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                    if (!((PullTask)this.profile.getTask()).isRemediation()) break block11;
                    this.createRemediation(provision.getAnyType(), null, null, (AnyUR)userUR, report, delta);
                }
            }
            this.end(AnyTypeKind.USER.name(), MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), resultStatus, before, output, delta, new Object[0]);
            this.profile.getResults().add(report);
        }
        return resultStatus;
    }

    protected AuditElements.Result delete(SyncDelta delta, LinkedAccount account, Provision provision) throws JobExecutionException {
        AuditElements.Result resultStatus;
        block7: {
            if (!((PullTask)this.profile.getTask()).isPerformDelete()) {
                LOG.debug("PullTask not configured for delete");
                this.end(AnyTypeKind.USER.name(), ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
                return AuditElements.Result.SUCCESS;
            }
            LOG.debug("About to delete {}", (Object)account);
            resultStatus = AuditElements.Result.FAILURE;
            ProvisioningReport report = new ProvisioningReport();
            try {
                Exception output;
                LinkedAccountTO before;
                block8: {
                    report.setKey(account.getKey());
                    report.setName(account.getConnObjectKeyValue());
                    report.setUidValue(account.getConnObjectKeyValue());
                    report.setOperation(ResourceOperation.DELETE);
                    report.setAnyType(MatchType.LINKED_ACCOUNT.name());
                    report.setStatus(ProvisioningReport.Status.SUCCESS);
                    if (this.profile.isDryRun()) break block7;
                    before = this.userDataBinder.getLinkedAccountTO(account);
                    for (Object action : this.profile.getActions()) {
                        action.beforeDelete(this.profile, delta, (EntityTO)before);
                    }
                    UserUR req = new UserUR();
                    req.setKey(account.getOwner().getKey());
                    req.getLinkedAccounts().add((LinkedAccountUR)((LinkedAccountUR.Builder)new LinkedAccountUR.Builder().operation(PatchOperation.DELETE)).linkedAccountTO(before).build());
                    try {
                        this.userProvisioningManager.update(req, report, null, Set.of(((PullTask)this.profile.getTask()).getResource().getKey()), true, this.profile.getExecutor(), this.getContext());
                        resultStatus = AuditElements.Result.SUCCESS;
                        output = null;
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)before, report);
                        }
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        report.setStatus(ProvisioningReport.Status.FAILURE);
                        report.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not delete linked account {}", (Object)account, (Object)e);
                        output = e;
                        if (!((PullTask)this.profile.getTask()).isRemediation()) break block8;
                        this.createRemediation(provision.getAnyType(), null, null, (AnyUR)req, report, delta);
                    }
                }
                this.end(AnyTypeKind.USER.name(), ResourceOperation.DELETE.name().toLowerCase(), resultStatus, before, output, delta, new Object[0]);
                this.profile.getResults().add(report);
            }
            catch (Exception e) {
                LOG.error("Could not delete linked account {}", (Object)account, (Object)e);
            }
        }
        return resultStatus;
    }

    protected AuditElements.Result ignore(SyncDelta delta, LinkedAccount account, boolean matching, String ... message) throws JobExecutionException {
        LOG.debug("Linked account to ignore {}", (Object)delta.getObject().getUid().getUidValue());
        ProvisioningReport report = new ProvisioningReport();
        report.setName(delta.getUid().getUidValue());
        report.setUidValue(delta.getUid().getUidValue());
        report.setOperation(ResourceOperation.NONE);
        report.setAnyType(MatchType.LINKED_ACCOUNT.name());
        report.setStatus(ProvisioningReport.Status.SUCCESS);
        if (message != null && message.length >= 1) {
            report.setMessage(message[0]);
        }
        if (account != null) {
            report.setKey(account.getKey());
        }
        this.end(AnyTypeKind.USER.name(), matching ? MatchingRule.toEventName((MatchingRule)MatchingRule.IGNORE) : UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.IGNORE), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
        this.profile.getResults().add(report);
        return AuditElements.Result.SUCCESS;
    }
}

