/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.token.device.InvalidOAuth20DeviceTokenException;
import org.apereo.cas.support.oauth.validator.token.device.ThrottledOAuth20DeviceUserCodeApprovalException;
import org.apereo.cas.support.oauth.validator.token.device.UnapprovedOAuth20DeviceUserCodeException;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCode;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20DefaultTokenGenerator
implements OAuth20TokenGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20DefaultTokenGenerator.class);
    protected final OAuth20AccessTokenFactory accessTokenFactory;
    protected final OAuth20DeviceTokenFactory deviceTokenFactory;
    protected final OAuth20DeviceUserCodeFactory deviceUserCodeFactory;
    protected final OAuth20RefreshTokenFactory refreshTokenFactory;
    protected final TicketRegistry ticketRegistry;
    protected final CasConfigurationProperties casProperties;

    private static OAuth20TokenGeneratedResult generateAccessTokenResult(AccessTokenRequestContext holder, Pair<OAuth20AccessToken, OAuth20RefreshToken> pair) {
        return OAuth20TokenGeneratedResult.builder().registeredService((RegisteredService)holder.getRegisteredService()).accessToken((OAuth20AccessToken)pair.getKey()).refreshToken((OAuth20RefreshToken)pair.getValue()).grantType(holder.getGrantType()).responseType(holder.getResponseType()).build();
    }

    public OAuth20TokenGeneratedResult generate(AccessTokenRequestContext holder) throws Exception {
        if (OAuth20ResponseTypes.DEVICE_CODE.equals((Object)holder.getResponseType())) {
            return this.generateAccessTokenOAuthDeviceCodeResponseType(holder);
        }
        Pair<OAuth20AccessToken, OAuth20RefreshToken> pair = this.generateAccessTokenOAuthGrantTypes(holder);
        return OAuth20DefaultTokenGenerator.generateAccessTokenResult(holder, pair);
    }

    protected OAuth20TokenGeneratedResult generateAccessTokenOAuthDeviceCodeResponseType(AccessTokenRequestContext holder) throws Exception {
        String deviceCode = holder.getDeviceCode();
        if (StringUtils.isNotBlank((CharSequence)deviceCode)) {
            OAuth20DeviceToken deviceCodeTicket = this.getDeviceTokenFromTicketRegistry(deviceCode);
            OAuth20DeviceUserCode deviceUserCode = this.getDeviceUserCodeFromRegistry(deviceCodeTicket);
            if (deviceUserCode.isUserCodeApproved()) {
                LOGGER.debug("Provided user code [{}] linked to device code [{}] is approved", (Object)deviceCodeTicket.getId(), (Object)deviceCode);
                this.ticketRegistry.deleteTicket(deviceCode);
                AccessTokenRequestContext deviceResult = AccessTokenRequestContext.builder().service(holder.getService()).authentication(holder.getAuthentication()).registeredService(holder.getRegisteredService()).ticketGrantingTicket(holder.getTicketGrantingTicket()).grantType(holder.getGrantType()).scopes(new LinkedHashSet(0)).responseType(holder.getResponseType()).generateRefreshToken(holder.getRegisteredService() != null && holder.isGenerateRefreshToken()).build();
                Pair<OAuth20AccessToken, OAuth20RefreshToken> ticketPair = this.generateAccessTokenOAuthGrantTypes(deviceResult);
                return OAuth20DefaultTokenGenerator.generateAccessTokenResult(deviceResult, ticketPair);
            }
            if (deviceCodeTicket.getLastTimeUsed() != null) {
                long interval = Beans.newDuration((String)this.casProperties.getAuthn().getOauth().getDeviceToken().getRefreshInterval()).getSeconds();
                boolean shouldSlowDown = deviceCodeTicket.getLastTimeUsed().plusSeconds(interval).isAfter(ZonedDateTime.now(ZoneOffset.UTC));
                if (shouldSlowDown) {
                    LOGGER.error("Request for user code approval is greater than the configured refresh interval of [{}] second(s)", (Object)interval);
                    throw new ThrottledOAuth20DeviceUserCodeApprovalException(deviceCodeTicket.getId());
                }
            }
            deviceCodeTicket.update();
            this.ticketRegistry.updateTicket((Ticket)deviceCodeTicket);
            LOGGER.error("Provided user code [{}] linked to device code [{}] is NOT approved yet", (Object)deviceCodeTicket.getId(), (Object)deviceCode);
            throw new UnapprovedOAuth20DeviceUserCodeException(deviceCodeTicket.getId());
        }
        Pair<OAuth20DeviceToken, OAuth20DeviceUserCode> deviceTokens = this.createDeviceTokensInTicketRegistry(holder);
        return OAuth20TokenGeneratedResult.builder().responseType(holder.getResponseType()).registeredService((RegisteredService)holder.getRegisteredService()).deviceCode(((OAuth20DeviceToken)deviceTokens.getLeft()).getId()).userCode(((OAuth20DeviceUserCode)deviceTokens.getValue()).getId()).build();
    }

    protected Pair<OAuth20AccessToken, OAuth20RefreshToken> generateAccessTokenOAuthGrantTypes(AccessTokenRequestContext holder) throws Exception {
        LOGGER.debug("Creating access token for [{}]", (Object)holder.getService());
        AuthenticationBuilder authnBuilder = DefaultAuthenticationBuilder.newInstance((Authentication)holder.getAuthentication()).setAuthenticationDate(ZonedDateTime.now(ZoneOffset.UTC)).addAttribute("grant_type", (Object)holder.getGrantType().getType()).addAttribute("scope", (Object)holder.getScopes());
        String clientId = Optional.ofNullable(holder.getRegisteredService()).map(OAuthRegisteredService::getClientId).orElse("");
        Map requestedClaims = holder.getClaims().getOrDefault("userinfo", new HashMap());
        requestedClaims.forEach((arg_0, arg_1) -> ((AuthenticationBuilder)authnBuilder).addAttribute(arg_0, arg_1));
        FunctionUtils.doIfNotNull((Object)holder.getDpop(), unused -> authnBuilder.addAttribute("DPoP", (Object)holder.getDpop()));
        FunctionUtils.doIfNotNull((Object)holder.getDpopConfirmation(), unused -> authnBuilder.addAttribute("DPoPConfirmation", (Object)holder.getDpopConfirmation()));
        Authentication authentication = authnBuilder.build();
        LOGGER.debug("Creating access token for [{}]", (Object)holder);
        TicketGrantingTicket ticketGrantingTicket = holder.getTicketGrantingTicket();
        OAuth20AccessToken accessToken = this.accessTokenFactory.create(holder.getService(), authentication, ticketGrantingTicket, (Collection)holder.getScopes(), (String)Optional.ofNullable(holder.getToken()).map(Ticket::getId).orElse(null), clientId, holder.getClaims(), holder.getResponseType(), holder.getGrantType());
        LOGGER.debug("Created access token [{}]", (Object)accessToken);
        this.addTicketToRegistry((Ticket)accessToken, ticketGrantingTicket);
        LOGGER.debug("Added access token [{}] to registry", (Object)accessToken);
        this.updateOAuthCode(holder, accessToken);
        OAuth20RefreshToken refreshToken = (OAuth20RefreshToken)FunctionUtils.doIf((boolean)holder.isGenerateRefreshToken(), (Supplier)Unchecked.supplier(() -> this.generateRefreshToken(holder, accessToken)), () -> {
            LOGGER.debug("Service [{}] is not able/allowed to receive refresh tokens", (Object)holder.getService());
            return null;
        }).get();
        return Pair.of((Object)accessToken, (Object)refreshToken);
    }

    protected void updateOAuthCode(AccessTokenRequestContext holder, OAuth20AccessToken accessToken) throws Exception {
        if (holder.isRefreshToken()) {
            OAuth20RefreshToken refreshToken = (OAuth20RefreshToken)holder.getToken();
            refreshToken.getAccessTokens().add(accessToken.getId());
            this.ticketRegistry.updateTicket((Ticket)refreshToken);
        } else if (holder.isCodeToken()) {
            Ticket codeState = (Ticket)Ticket.class.cast(holder.getToken());
            codeState.update();
            if (holder.getToken().isExpired()) {
                this.ticketRegistry.deleteTicket(holder.getToken().getId());
            } else {
                this.ticketRegistry.updateTicket((Ticket)holder.getToken());
            }
            this.ticketRegistry.updateTicket((Ticket)holder.getTicketGrantingTicket());
        }
    }

    protected void addTicketToRegistry(Ticket ticket, TicketGrantingTicket ticketGrantingTicket) throws Exception {
        LOGGER.debug("Adding ticket [{}] to registry", (Object)ticket);
        this.ticketRegistry.addTicket(ticket);
        if (ticketGrantingTicket != null) {
            LOGGER.debug("Updating parent ticket-granting ticket [{}]", (Object)ticketGrantingTicket);
            this.ticketRegistry.updateTicket((Ticket)ticketGrantingTicket);
        }
    }

    protected void addTicketToRegistry(Ticket ticket) throws Exception {
        this.addTicketToRegistry(ticket, null);
    }

    protected OAuth20RefreshToken generateRefreshToken(AccessTokenRequestContext responseHolder, OAuth20AccessToken accessToken) throws Exception {
        LOGGER.debug("Creating refresh token for [{}]", (Object)responseHolder.getService());
        OAuth20RefreshToken refreshToken = this.refreshTokenFactory.create(responseHolder.getService(), responseHolder.getAuthentication(), responseHolder.getTicketGrantingTicket(), (Collection)responseHolder.getScopes(), responseHolder.getRegisteredService().getClientId(), accessToken.getId(), responseHolder.getClaims(), responseHolder.getResponseType(), responseHolder.getGrantType());
        LOGGER.debug("Adding refresh token [{}] to the registry", (Object)refreshToken);
        this.addTicketToRegistry((Ticket)refreshToken, responseHolder.getTicketGrantingTicket());
        if (responseHolder.isExpireOldRefreshToken()) {
            this.expireOldRefreshToken(responseHolder);
        }
        return refreshToken;
    }

    private OAuth20DeviceUserCode getDeviceUserCodeFromRegistry(OAuth20DeviceToken deviceCodeTicket) {
        return (OAuth20DeviceUserCode)FunctionUtils.doAndHandle(() -> (OAuth20DeviceUserCode)this.ticketRegistry.getTicket(deviceCodeTicket.getUserCode(), OAuth20DeviceUserCode.class), throwable -> {
            LOGGER.error("Provided user code [{}] is invalid or expired and cannot be found in the ticket registry", (Object)deviceCodeTicket.getUserCode());
            throw new InvalidOAuth20DeviceTokenException(deviceCodeTicket.getUserCode());
        }).get();
    }

    private OAuth20DeviceToken getDeviceTokenFromTicketRegistry(String deviceCode) {
        return (OAuth20DeviceToken)FunctionUtils.doAndHandle(() -> (OAuth20DeviceToken)this.ticketRegistry.getTicket(deviceCode, OAuth20DeviceToken.class), throwable -> {
            LoggingUtils.error((Logger)LOGGER, (Throwable)throwable);
            throw new InvalidOAuth20DeviceTokenException(deviceCode);
        }).get();
    }

    private Pair<OAuth20DeviceToken, OAuth20DeviceUserCode> createDeviceTokensInTicketRegistry(AccessTokenRequestContext holder) throws Exception {
        OAuth20DeviceToken deviceToken = this.deviceTokenFactory.createDeviceCode(holder.getService());
        LOGGER.debug("Created device code token [{}]", (Object)deviceToken.getId());
        OAuth20DeviceUserCode deviceUserCode = this.deviceUserCodeFactory.createDeviceUserCode(deviceToken);
        LOGGER.debug("Created device user code token [{}]", (Object)deviceUserCode.getId());
        this.addTicketToRegistry((Ticket)deviceToken);
        LOGGER.debug("Added device token [{}] to registry", (Object)deviceToken);
        this.addTicketToRegistry((Ticket)deviceUserCode);
        LOGGER.debug("Added device user token [{}] to registry", (Object)deviceUserCode);
        return Pair.of((Object)deviceToken, (Object)deviceUserCode);
    }

    private void expireOldRefreshToken(AccessTokenRequestContext responseHolder) throws Exception {
        OAuth20Token oldRefreshToken = responseHolder.getToken();
        LOGGER.debug("Expiring old refresh token [{}]", (Object)oldRefreshToken);
        oldRefreshToken.markTicketExpired();
        this.ticketRegistry.deleteTicket((Ticket)oldRefreshToken);
    }

    @Generated
    public OAuth20DefaultTokenGenerator(OAuth20AccessTokenFactory accessTokenFactory, OAuth20DeviceTokenFactory deviceTokenFactory, OAuth20DeviceUserCodeFactory deviceUserCodeFactory, OAuth20RefreshTokenFactory refreshTokenFactory, TicketRegistry ticketRegistry, CasConfigurationProperties casProperties) {
        this.accessTokenFactory = accessTokenFactory;
        this.deviceTokenFactory = deviceTokenFactory;
        this.deviceUserCodeFactory = deviceUserCodeFactory;
        this.refreshTokenFactory = refreshTokenFactory;
        this.ticketRegistry = ticketRegistry;
        this.casProperties = casProperties;
    }
}

