/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.panels;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.ui.commons.MapChoiceRenderer;
import org.apache.syncope.client.ui.commons.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPasswordFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.form.FormProperty;
import org.apache.syncope.common.lib.form.FormPropertyValue;
import org.apache.syncope.common.lib.form.SyncopeForm;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.PatternValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeFormPanel<F extends SyncopeForm>
extends Panel {
    private static final long serialVersionUID = -8847854414429745216L;
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeFormPanel.class);

    public SyncopeFormPanel(String id, F form) {
        super(id);
        ListModel model = new ListModel(new ArrayList());
        ((List)model.getObject()).addAll(form.getProperties());
        ListView<FormProperty> propView = new ListView<FormProperty>("propView", (IModel)model){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<FormProperty> item) {
                AbstractFieldPanel field;
                final FormProperty prop = (FormProperty)item.getModelObject();
                String label = StringUtils.isBlank((CharSequence)prop.getName()) ? prop.getId() : prop.getName();
                switch (prop.getType()) {
                    case Boolean: {
                        field = new AjaxCheckBoxPanel("value", label, (IModel<Boolean>)new PropertyModel<Boolean>((Object)prop, "value"){
                            private static final long serialVersionUID = -3743432456095828573L;

                            public Boolean getObject() {
                                return BooleanUtils.toBoolean((String)prop.getValue());
                            }

                            public void setObject(Boolean object) {
                                prop.setValue(BooleanUtils.toStringTrueFalse((Boolean)object));
                            }
                        }, false);
                        break;
                    }
                    case Date: {
                        final FastDateFormat formatter = FastDateFormat.getInstance((String)prop.getDatePattern());
                        field = new AjaxDateTimeFieldPanel("value", label, (IModel<Date>)new PropertyModel<Date>((Object)prop, "value"){
                            private static final long serialVersionUID = -3743432456095828573L;

                            public Date getObject() {
                                try {
                                    return StringUtils.isBlank((CharSequence)prop.getValue()) ? null : formatter.parse(prop.getValue());
                                }
                                catch (ParseException e) {
                                    LOG.error("Unparsable date: {}", (Object)prop.getValue(), (Object)e);
                                    return null;
                                }
                            }

                            public void setObject(Date object) {
                                prop.setValue(formatter.format(object));
                            }
                        }, formatter);
                        break;
                    }
                    case Enum: {
                        field = new AjaxDropDownChoicePanel<String>("value", label, (IModel<String>)new PropertyModel((Object)prop, "value"), false).setChoiceRenderer(new MapChoiceRenderer(prop.getEnumValues().stream().collect(Collectors.toMap(FormPropertyValue::getKey, FormPropertyValue::getValue)))).setChoices(prop.getEnumValues().stream().map(FormPropertyValue::getKey).collect(Collectors.toList()));
                        break;
                    }
                    case Dropdown: {
                        if (prop.isDropdownFreeForm()) {
                            field = new AjaxTextFieldPanel("value", label, (IModel<String>)new PropertyModel((Object)prop, "value"), false);
                            field.setChoices(prop.getDropdownValues().stream().map(FormPropertyValue::getKey).collect(Collectors.toList()));
                            break;
                        }
                        if (prop.isDropdownSingleSelection()) {
                            field = new AjaxDropDownChoicePanel<String>("value", label, (IModel<String>)new PropertyModel((Object)prop, "value"), false).setChoiceRenderer(new MapChoiceRenderer(prop.getDropdownValues().stream().collect(Collectors.toMap(FormPropertyValue::getKey, FormPropertyValue::getValue)))).setChoices(prop.getDropdownValues().stream().map(FormPropertyValue::getKey).collect(Collectors.toList()));
                            break;
                        }
                        field = new AjaxPalettePanel.Builder().setName(label).setRenderer(new MapChoiceRenderer(prop.getDropdownValues().stream().collect(Collectors.toMap(FormPropertyValue::getKey, FormPropertyValue::getValue)))).build("value", new IModel<List<String>>(){
                            private static final long serialVersionUID = 1015030402166681242L;

                            public List<String> getObject() {
                                return Optional.ofNullable(prop.getValue()).map(v -> List.of(v.split(";"))).orElse(null);
                            }

                            public void setObject(List<String> object) {
                                prop.setValue((String)Optional.ofNullable(object).map(v -> v.stream().collect(Collectors.joining(";"))).orElse(null));
                            }
                        }, (IModel<List<String>>)new ListModel(prop.getDropdownValues().stream().map(FormPropertyValue::getKey).collect(Collectors.toList())));
                        break;
                    }
                    case Long: {
                        field = new AjaxNumberFieldPanel.Builder<Long>().build("value", label, Long.class, (IModel<Long>)new PropertyModel<Long>((Object)prop, "value"){
                            private static final long serialVersionUID = -7688359318035249200L;

                            public Long getObject() {
                                return StringUtils.isBlank((CharSequence)prop.getValue()) ? null : Long.valueOf(NumberUtils.toLong((String)prop.getValue()));
                            }

                            public void setObject(Long object) {
                                prop.setValue(String.valueOf(object));
                            }
                        });
                        break;
                    }
                    case Password: {
                        field = new AjaxPasswordFieldPanel("value", label, (IModel<String>)new PropertyModel((Object)prop, "value"), false).setResetPassword(false);
                        break;
                    }
                    default: {
                        field = new AjaxTextFieldPanel("value", label, (IModel<String>)new PropertyModel((Object)prop, "value"), false);
                        Optional.ofNullable(prop.getStringRegEx()).ifPresent(re -> ((AjaxTextFieldPanel)field).addValidator((IValidator<? super String>)new PatternValidator(re)));
                    }
                }
                ((AbstractFieldPanel)field).setReadOnly(!prop.isWritable());
                if (prop.isRequired()) {
                    field.addRequiredLabel();
                }
                item.add(new Component[]{field});
            }
        };
        this.add(new Component[]{propView.setReuseItems(true)});
    }
}

