/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.azure.ad.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.azure.ad.authentication.AzureActiveDirectoryAuthenticationHandler;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.azuread.AzureActiveDirectoryAuthenticationProperties;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.MicrosoftGraphPersonAttributeDao;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Authentication, module="azuread")
@AutoConfiguration
public class AzureActiveDirectoryAuthenticationConfiguration {
    @ConditionalOnMissingBean(name={"microsoftAzureActiveDirectoryAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer microsoftAzureActiveDirectoryAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="microsoftAzureActiveDirectoryAuthenticationHandler") AuthenticationHandler handler, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(handler, defaultPrincipalResolver);
    }

    @ConditionalOnMissingBean(name={"microsoftAzureActiveDirectoryAttributeRepositoryPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PersonDirectoryAttributeRepositoryPlanConfigurer microsoftAzureActiveDirectoryAttributeRepositoryPlanConfigurer(@Qualifier(value="microsoftAzureActiveDirectoryAttributeRepositories") List<IPersonAttributeDao> repositories) {
        return plan -> repositories.forEach(arg_0 -> ((PersonDirectoryAttributeRepositoryPlan)plan).registerAttributeRepository(arg_0));
    }

    @Configuration(value="AzureActiveDirectoryAuthenticationInternalConfiguration", proxyBeanMethods=false)
    public static class AzureActiveDirectoryAuthenticationInternalConfiguration {
        @ConditionalOnMissingBean(name={"microsoftAzureActiveDirectoryAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public List<IPersonAttributeDao> microsoftAzureActiveDirectoryAttributeRepositories(CasConfigurationProperties casProperties) {
            ArrayList<IPersonAttributeDao> list = new ArrayList<IPersonAttributeDao>();
            PrincipalAttributesProperties attrs = casProperties.getAuthn().getAttributeRepository();
            attrs.getAzureActiveDirectory().stream().filter(msft -> StringUtils.isNotBlank((CharSequence)msft.getClientId()) && StringUtils.isNotBlank((CharSequence)msft.getClientSecret())).forEach(msft -> {
                MicrosoftGraphPersonAttributeDao dao = new MicrosoftGraphPersonAttributeDao();
                FunctionUtils.doIfNotNull((Object)msft.getId(), xva$0 -> dao.setId(new String[]{xva$0}));
                FunctionUtils.doIfNotNull((Object)msft.getDomain(), arg_0 -> ((MicrosoftGraphPersonAttributeDao)dao).setDomain(arg_0));
                FunctionUtils.doIfNotNull((Object)msft.getApiBaseUrl(), arg_0 -> ((MicrosoftGraphPersonAttributeDao)dao).setApiBaseUrl(arg_0));
                FunctionUtils.doIfNotNull((Object)msft.getGrantType(), arg_0 -> ((MicrosoftGraphPersonAttributeDao)dao).setGrantType(arg_0));
                FunctionUtils.doIfNotNull((Object)msft.getLoginBaseUrl(), arg_0 -> ((MicrosoftGraphPersonAttributeDao)dao).setLoginBaseUrl(arg_0));
                FunctionUtils.doIfNotNull((Object)msft.getLoggingLevel(), arg_0 -> ((MicrosoftGraphPersonAttributeDao)dao).setLoggingLevel(arg_0));
                FunctionUtils.doIfNotNull((Object)msft.getAttributes(), arg_0 -> ((MicrosoftGraphPersonAttributeDao)dao).setProperties(arg_0));
                FunctionUtils.doIfNotNull((Object)msft.getResource(), arg_0 -> ((MicrosoftGraphPersonAttributeDao)dao).setResource(arg_0));
                FunctionUtils.doIfNotNull((Object)msft.getScope(), arg_0 -> ((MicrosoftGraphPersonAttributeDao)dao).setScope(arg_0));
                FunctionUtils.doIfNotNull((Object)msft.getTenant(), arg_0 -> ((MicrosoftGraphPersonAttributeDao)dao).setTenant(arg_0));
                dao.setClientSecret(msft.getClientSecret());
                dao.setClientId(msft.getClientId());
                dao.setOrder(msft.getOrder());
                list.add((IPersonAttributeDao)dao);
            });
            return list;
        }

        @ConditionalOnMissingBean(name={"microsoftAzureActiveDirectoryPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory microsoftAzureActiveDirectoryPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }

        @ConditionalOnMissingBean(name={"microsoftAzureActiveDirectoryAuthenticationHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationHandler microsoftAzureActiveDirectoryAuthenticationHandler(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="microsoftAzureActiveDirectoryPrincipalFactory") PrincipalFactory factory) {
            AzureActiveDirectoryAuthenticationProperties azure = casProperties.getAuthn().getAzureActiveDirectory();
            AzureActiveDirectoryAuthenticationHandler handler = new AzureActiveDirectoryAuthenticationHandler(azure.getName(), servicesManager, factory, azure.getOrder(), azure.getClientId(), azure.getLoginUrl(), azure.getResource());
            handler.setState(azure.getState());
            handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)azure.getPrincipalTransformation()));
            handler.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)azure.getPasswordEncoder(), (ApplicationContext)applicationContext));
            handler.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)azure.getCredentialCriteria()));
            return handler;
        }
    }
}

