/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.request;

import java.util.function.Supplier;
import org.apache.wicket.core.request.mapper.ResourceReferenceMapper;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.util.string.Strings;

public class StaticResourceRewriteMapper
implements IRequestMapper {
    private final String baseUrl;
    private final IRequestMapper chain;

    public static Builder withBaseUrl(String baseUrl) {
        return new Builder(baseUrl);
    }

    private StaticResourceRewriteMapper(String baseUrl, IRequestMapper chain) {
        this.baseUrl = baseUrl;
        this.chain = chain;
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        ResourceReferenceRequestHandler resourceReferenceRequestHandler;
        if (requestHandler instanceof ResourceReferenceRequestHandler && (resourceReferenceRequestHandler = (ResourceReferenceRequestHandler)requestHandler).getResource() instanceof IStaticCacheableResource) {
            Url url = this.chain.mapHandler(requestHandler);
            if (url != null && url.getQueryParameters().isEmpty()) {
                return Url.parse((CharSequence)Strings.join((String)"/", (String[])new String[]{this.baseUrl, url.toString()}));
            }
            return url;
        }
        return null;
    }

    public IRequestHandler mapRequest(Request request) {
        return null;
    }

    public int getCompatibilityScore(Request request) {
        return 0;
    }

    public static final class Builder {
        private final String url;

        private Builder(String url) {
            this.url = url;
        }

        public void install(WebApplication app) {
            ResourceReferenceMapper delegate = new ResourceReferenceMapper((IPageParametersEncoder)new PageParametersEncoder(), this.newParentFolderPlaceholder(app), this.newResourceCachingStrategy(app));
            StaticResourceRewriteMapper mapper = new StaticResourceRewriteMapper(this.url, (IRequestMapper)delegate);
            app.mount((IRequestMapper)mapper);
        }

        private Supplier<String> newParentFolderPlaceholder(WebApplication app) {
            return () -> app.getResourceSettings().getParentFolderPlaceholder();
        }

        private Supplier<IResourceCachingStrategy> newResourceCachingStrategy(WebApplication app) {
            return () -> app.getResourceSettings().getCachingStrategy();
        }
    }
}

