/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap.mapping;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.AbstractJDBCConf;
import org.apache.syncope.common.lib.AbstractLDAPConf;
import org.apache.syncope.common.lib.auth.AbstractOIDCAuthModuleConf;
import org.apache.syncope.common.lib.auth.AppleOIDCAuthModuleConf;
import org.apache.syncope.common.lib.auth.AuthModuleConf;
import org.apache.syncope.common.lib.auth.AzureActiveDirectoryAuthModuleConf;
import org.apache.syncope.common.lib.auth.AzureOIDCAuthModuleConf;
import org.apache.syncope.common.lib.auth.DuoMfaAuthModuleConf;
import org.apache.syncope.common.lib.auth.GoogleMfaAuthModuleConf;
import org.apache.syncope.common.lib.auth.GoogleOIDCAuthModuleConf;
import org.apache.syncope.common.lib.auth.JDBCAuthModuleConf;
import org.apache.syncope.common.lib.auth.JaasAuthModuleConf;
import org.apache.syncope.common.lib.auth.KeycloakOIDCAuthModuleConf;
import org.apache.syncope.common.lib.auth.LDAPAuthModuleConf;
import org.apache.syncope.common.lib.auth.OAuth20AuthModuleConf;
import org.apache.syncope.common.lib.auth.OIDCAuthModuleConf;
import org.apache.syncope.common.lib.auth.OktaAuthModuleConf;
import org.apache.syncope.common.lib.auth.SAML2IdPAuthModuleConf;
import org.apache.syncope.common.lib.auth.SimpleMfaAuthModuleConf;
import org.apache.syncope.common.lib.auth.SpnegoAuthModuleConf;
import org.apache.syncope.common.lib.auth.StaticAuthModuleConf;
import org.apache.syncope.common.lib.auth.SyncopeAuthModuleConf;
import org.apache.syncope.common.lib.auth.U2FAuthModuleConf;
import org.apache.syncope.common.lib.auth.X509AuthModuleConf;
import org.apache.syncope.common.lib.to.AuthModuleTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.types.AuthModuleState;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.bootstrap.mapping.PropertySourceMapper;
import org.apereo.cas.configuration.CasCoreConfigurationUtils;
import org.apereo.cas.configuration.model.core.authentication.AuthenticationHandlerStates;
import org.apereo.cas.configuration.model.support.azuread.AzureActiveDirectoryAuthenticationProperties;
import org.apereo.cas.configuration.model.support.generic.AcceptAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jaas.JaasAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.QueryJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapSearchProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mfa.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.LdapGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.okta.OktaAuthenticationProperties;
import org.apereo.cas.configuration.model.support.pac4j.oauth.Pac4jOAuth20ClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.oidc.BasePac4jOidcClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.oidc.Pac4jAppleOidcClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.oidc.Pac4jAzureOidcClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.oidc.Pac4jGenericOidcClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.oidc.Pac4jGoogleOidcClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.oidc.Pac4jKeyCloakOidcClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.oidc.Pac4jOidcClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.saml.Pac4jSamlClientProperties;
import org.apereo.cas.configuration.model.support.spnego.SpnegoAuthenticationProperties;
import org.apereo.cas.configuration.model.support.spnego.SpnegoLdapProperties;
import org.apereo.cas.configuration.model.support.spnego.SpnegoProperties;
import org.apereo.cas.configuration.model.support.syncope.SyncopeAuthenticationProperties;
import org.apereo.cas.configuration.model.support.x509.SubjectDnPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.X509LdapProperties;
import org.apereo.cas.configuration.model.support.x509.X509Properties;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.model.TriStateBoolean;
import org.springframework.core.io.Resource;

public class AuthModulePropertySourceMapper
extends PropertySourceMapper
implements AuthModuleConf.Mapper {
    protected final WARestClient waRestClient;

    public AuthModulePropertySourceMapper(WARestClient waRestClient) {
        this.waRestClient = waRestClient;
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, StaticAuthModuleConf conf) {
        AcceptAuthenticationProperties props = new AcceptAuthenticationProperties();
        props.setName(authModuleTO.getKey());
        props.setState(AuthenticationHandlerStates.valueOf((String)authModuleTO.getState().name()));
        props.setOrder(authModuleTO.getOrder());
        props.setCredentialCriteria(conf.getCredentialCriteria());
        String users = conf.getUsers().entrySet().stream().map(entry -> (String)entry.getKey() + "::" + (String)entry.getValue()).collect(Collectors.joining(","));
        props.setUsers(users);
        return AuthModulePropertySourceMapper.prefix("cas.authn.accept.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, LDAPAuthModuleConf conf) {
        LdapAuthenticationProperties props = new LdapAuthenticationProperties();
        props.setName(authModuleTO.getKey());
        props.setState(AuthenticationHandlerStates.valueOf((String)authModuleTO.getState().name()));
        props.setOrder(Integer.valueOf(authModuleTO.getOrder()));
        props.setType(AbstractLdapAuthenticationProperties.AuthenticationTypes.valueOf((String)conf.getAuthenticationType().name()));
        props.setDnFormat(conf.getDnFormat());
        props.setEnhanceWithEntryResolver(conf.isEnhanceWithEntryResolver());
        props.setDerefAliases((String)Optional.ofNullable(conf.getDerefAliases()).map(Enum::name).orElse(null));
        props.setResolveFromAttribute(conf.getResolveFromAttribute());
        props.setPrincipalAttributeId(conf.getPrincipalAttributeId());
        props.setPrincipalDnAttributeName(conf.getPrincipalDnAttributeName());
        props.setPrincipalAttributeList(authModuleTO.getItems().stream().map(item -> item.getIntAttrName() + ":" + item.getExtAttrName()).collect(Collectors.toList()));
        props.setAllowMultiplePrincipalAttributeValues(conf.isAllowMultiplePrincipalAttributeValues());
        props.setAdditionalAttributes(conf.getAdditionalAttributes());
        props.setAllowMissingPrincipalAttributeValue(conf.isAllowMissingPrincipalAttributeValue());
        props.setCollectDnAttribute(conf.isCollectDnAttribute());
        props.setCredentialCriteria(conf.getCredentialCriteria());
        props.getPasswordPolicy().setType(AbstractLdapProperties.LdapType.valueOf((String)conf.getLdapType().name()));
        this.fill((AbstractLdapSearchProperties)props, (AbstractLDAPConf)conf);
        return AuthModulePropertySourceMapper.prefix("cas.authn.ldap[].", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, JDBCAuthModuleConf conf) {
        QueryJdbcAuthenticationProperties props = new QueryJdbcAuthenticationProperties();
        props.setName(authModuleTO.getKey());
        props.setState(AuthenticationHandlerStates.valueOf((String)authModuleTO.getState().name()));
        props.setOrder(authModuleTO.getOrder());
        props.setSql(conf.getSql());
        props.setFieldDisabled(conf.getFieldDisabled());
        props.setFieldExpired(conf.getFieldExpired());
        props.setFieldPassword(conf.getFieldPassword());
        props.setPrincipalAttributeList(authModuleTO.getItems().stream().map(item -> item.getIntAttrName() + ":" + item.getExtAttrName()).collect(Collectors.toList()));
        props.setCredentialCriteria(conf.getCredentialCriteria());
        this.fill((AbstractJpaProperties)props, (AbstractJDBCConf)conf);
        return AuthModulePropertySourceMapper.prefix("cas.authn.jdbc.query[].", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, JaasAuthModuleConf conf) {
        JaasAuthenticationProperties props = new JaasAuthenticationProperties();
        props.setName(authModuleTO.getKey());
        props.setState(AuthenticationHandlerStates.valueOf((String)authModuleTO.getState().name()));
        props.setOrder(authModuleTO.getOrder());
        props.setLoginConfigType(conf.getLoginConfigType());
        props.setKerberosKdcSystemProperty(conf.getKerberosKdcSystemProperty());
        props.setKerberosRealmSystemProperty(conf.getKerberosRealmSystemProperty());
        props.setLoginConfigType(conf.getLoginConfigurationFile());
        props.setRealm(conf.getRealm());
        props.setCredentialCriteria(conf.getCredentialCriteria());
        return AuthModulePropertySourceMapper.prefix("cas.authn.jaas[].", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, OAuth20AuthModuleConf conf) {
        Pac4jOAuth20ClientProperties props = new Pac4jOAuth20ClientProperties();
        props.setId(conf.getClientId());
        props.setSecret(conf.getClientSecret());
        props.setClientName(Optional.ofNullable(conf.getClientName()).orElse(authModuleTO.getKey()));
        props.setEnabled(authModuleTO.getState() == AuthModuleState.ACTIVE);
        props.setCustomParams(conf.getCustomParams());
        props.setAuthUrl(conf.getAuthUrl());
        props.setProfilePath(conf.getProfilePath());
        props.setProfileVerb(conf.getProfileVerb());
        props.setProfileUrl(conf.getProfileUrl());
        props.setTokenUrl(conf.getTokenUrl());
        props.setResponseType(conf.getResponseType());
        props.setScope(conf.getScope());
        props.setPrincipalAttributeId(conf.getUserIdAttribute());
        props.setWithState(conf.isWithState());
        props.setProfileAttrs(authModuleTO.getItems().stream().collect(Collectors.toMap(Item::getIntAttrName, Item::getExtAttrName)));
        return AuthModulePropertySourceMapper.prefix("cas.authn.pac4j.oauth2[].", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    protected void map(AuthModuleTO authModuleTO, BasePac4jOidcClientProperties props, AbstractOIDCAuthModuleConf conf) {
        props.setId(conf.getClientId());
        props.setSecret(conf.getClientSecret());
        props.setClientName(Optional.ofNullable(conf.getClientName()).orElse(authModuleTO.getKey()));
        props.setEnabled(authModuleTO.getState() == AuthModuleState.ACTIVE);
        props.setCustomParams(conf.getCustomParams());
        props.setDiscoveryUri(conf.getDiscoveryUri());
        props.setMaxClockSkew(conf.getMaxClockSkew());
        props.setPreferredJwsAlgorithm(conf.getPreferredJwsAlgorithm());
        props.setResponseMode(conf.getResponseMode());
        props.setResponseType(conf.getResponseType());
        props.setScope(conf.getScope());
        props.setPrincipalAttributeId(conf.getUserIdAttribute());
        props.setExpireSessionWithToken(conf.isExpireSessionWithToken());
        props.setTokenExpirationAdvance(conf.getTokenExpirationAdvance());
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, OIDCAuthModuleConf conf) {
        Pac4jGenericOidcClientProperties props = new Pac4jGenericOidcClientProperties();
        this.map(authModuleTO, (BasePac4jOidcClientProperties)props, (AbstractOIDCAuthModuleConf)conf);
        Pac4jOidcClientProperties client = new Pac4jOidcClientProperties();
        client.setGeneric(props);
        return AuthModulePropertySourceMapper.prefix("cas.authn.pac4j.oidc[].generic.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, AzureOIDCAuthModuleConf conf) {
        Pac4jAzureOidcClientProperties props = new Pac4jAzureOidcClientProperties();
        this.map(authModuleTO, (BasePac4jOidcClientProperties)props, (AbstractOIDCAuthModuleConf)conf);
        props.setTenant(conf.getTenant());
        Pac4jOidcClientProperties client = new Pac4jOidcClientProperties();
        client.setAzure(props);
        return AuthModulePropertySourceMapper.prefix("cas.authn.pac4j.oidc[].azure.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, GoogleOIDCAuthModuleConf conf) {
        Pac4jGoogleOidcClientProperties props = new Pac4jGoogleOidcClientProperties();
        this.map(authModuleTO, (BasePac4jOidcClientProperties)props, (AbstractOIDCAuthModuleConf)conf);
        Pac4jOidcClientProperties client = new Pac4jOidcClientProperties();
        client.setGoogle(props);
        return AuthModulePropertySourceMapper.prefix("cas.authn.pac4j.oidc[].google.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, KeycloakOIDCAuthModuleConf conf) {
        Pac4jKeyCloakOidcClientProperties props = new Pac4jKeyCloakOidcClientProperties();
        this.map(authModuleTO, (BasePac4jOidcClientProperties)props, (AbstractOIDCAuthModuleConf)conf);
        props.setRealm(conf.getRealm());
        props.setBaseUri(conf.getBaseUri());
        Pac4jOidcClientProperties client = new Pac4jOidcClientProperties();
        client.setKeycloak(props);
        return AuthModulePropertySourceMapper.prefix("cas.authn.pac4j.oidc[].keycloak.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, AppleOIDCAuthModuleConf conf) {
        Pac4jAppleOidcClientProperties props = new Pac4jAppleOidcClientProperties();
        this.map(authModuleTO, (BasePac4jOidcClientProperties)props, (AbstractOIDCAuthModuleConf)conf);
        props.setTimeout(conf.getTimeout());
        props.setPrivateKey(conf.getPrivateKey());
        props.setPrivateKeyId(conf.getPrivateKeyId());
        props.setTeamId(conf.getTeamId());
        Pac4jOidcClientProperties client = new Pac4jOidcClientProperties();
        client.setApple(props);
        return AuthModulePropertySourceMapper.prefix("cas.authn.pac4j.oidc[].apple.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, SAML2IdPAuthModuleConf conf) {
        Pac4jSamlClientProperties props = new Pac4jSamlClientProperties();
        props.setClientName(Optional.ofNullable(conf.getClientName()).orElse(authModuleTO.getKey()));
        props.setEnabled(authModuleTO.getState() == AuthModuleState.ACTIVE);
        props.setAcceptedSkew(conf.getAcceptedSkew());
        props.setAssertionConsumerServiceIndex(conf.getAssertionConsumerServiceIndex());
        props.setAttributeConsumingServiceIndex(conf.getAttributeConsumingServiceIndex());
        props.setAuthnContextClassRef(conf.getAuthnContextClassRefs());
        props.setAuthnContextComparisonType(conf.getAuthnContextComparisonType());
        props.setBlockedSignatureSigningAlgorithms(conf.getBlockedSignatureSigningAlgorithms());
        props.setDestinationBinding(conf.getDestinationBinding().getUri());
        props.setIdentityProviderMetadataPath(conf.getIdentityProviderMetadataPath());
        props.setServiceProviderMetadataPath(conf.getServiceProviderMetadataPath());
        props.setKeystorePath(conf.getKeystorePath());
        props.setWantsAssertionsSigned(conf.isWantsAssertionsSigned());
        props.setWantsResponsesSigned(conf.isResponsesSigned());
        props.setKeystoreAlias(conf.getKeystoreAlias());
        props.setKeystorePassword(conf.getKeystorePassword());
        props.setMaximumAuthenticationLifetime(conf.getMaximumAuthenticationLifetime());
        props.setNameIdPolicyFormat(conf.getNameIdPolicyFormat());
        props.setPrivateKeyPassword(conf.getPrivateKeyPassword());
        props.setProviderName(conf.getProviderName());
        props.setServiceProviderEntityId(conf.getServiceProviderEntityId());
        props.setSignatureAlgorithms(conf.getSignatureAlgorithms());
        props.setSignatureCanonicalizationAlgorithm(conf.getSignatureCanonicalizationAlgorithm());
        props.setSignatureReferenceDigestMethods(conf.getSignatureReferenceDigestMethods());
        props.setPrincipalAttributeId(conf.getUserIdAttribute());
        props.setNameIdPolicyAllowCreate(StringUtils.isBlank((CharSequence)conf.getNameIdPolicyAllowCreate()) ? TriStateBoolean.UNDEFINED : TriStateBoolean.valueOf((String)conf.getNameIdPolicyAllowCreate().toUpperCase()));
        return AuthModulePropertySourceMapper.prefix("cas.authn.pac4j.saml[].", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, X509AuthModuleConf conf) {
        X509Properties props = new X509Properties();
        props.setName(conf.getName());
        props.setOrder(conf.getOrder());
        props.setCacheDiskOverflow(conf.isCacheDiskOverflow());
        props.setCacheDiskSize(conf.getCacheDiskSize());
        props.setCacheEternal(conf.isCacheEternal());
        props.setCacheMaxElementsInMemory(conf.getCacheMaxElementsInMemory());
        props.setCacheTimeToLiveSeconds(conf.getCacheTimeToLiveSeconds());
        props.setCheckAll(conf.isCheckAll());
        props.setCheckKeyUsage(conf.isCheckKeyUsage());
        props.setCrlExpiredPolicy(conf.getCrlExpiredPolicy().name());
        props.setCrlFetcher(conf.getCrlFetcher().name());
        props.setCrlResourceExpiredPolicy(conf.getCrlResourceExpiredPolicy().name());
        props.setCrlResourceUnavailablePolicy(conf.getCrlResourceUnavailablePolicy().name());
        props.setCrlResources(conf.getCrlResources());
        props.setCrlUnavailablePolicy(conf.getCrlUnavailablePolicy().name());
        props.setExtractCert(conf.isExtractCert());
        props.setMaxPathLength(conf.getMaxPathLength());
        props.setMaxPathLengthAllowUnspecified(conf.isMaxPathLengthAllowUnspecified());
        props.setMixedMode(conf.isMixedMode());
        props.setRefreshIntervalSeconds(conf.getRefreshIntervalSeconds());
        props.setRegExSubjectDnPattern(conf.getRegExSubjectDnPattern());
        props.setRegExTrustedIssuerDnPattern(conf.getRegExTrustedIssuerDnPattern());
        props.setRequireKeyUsage(conf.isRequireKeyUsage());
        props.setRevocationChecker(conf.getRevocationChecker().name());
        props.setRevocationPolicyThreshold(conf.getRevocationPolicyThreshold());
        props.setSslHeaderName(conf.getSslHeaderName());
        props.setThrowOnFetchFailure(conf.isThrowOnFetchFailure());
        props.setPrincipalType(X509Properties.PrincipalTypes.valueOf((String)conf.getPrincipalType().name()));
        if (StringUtils.isNotBlank((CharSequence)conf.getPrincipalAlternateAttribute())) {
            switch (props.getPrincipalType()) {
                case CN_EDIPI: {
                    props.getCnEdipi().setAlternatePrincipalAttribute(conf.getPrincipalAlternateAttribute());
                    break;
                }
                case RFC822_EMAIL: {
                    props.getRfc822Email().setAlternatePrincipalAttribute(conf.getPrincipalAlternateAttribute());
                    break;
                }
                case SUBJECT: {
                    props.setPrincipalDescriptor(conf.getPrincipalAlternateAttribute());
                    break;
                }
                case SUBJECT_ALT_NAME: {
                    props.getSubjectAltName().setAlternatePrincipalAttribute(conf.getPrincipalAlternateAttribute());
                    break;
                }
            }
        }
        props.getSubjectDn().setFormat(SubjectDnPrincipalResolverProperties.SubjectDnFormat.valueOf((String)conf.getPrincipalTypeSubjectDnFormat().name()));
        props.getSerialNoDn().setSerialNumberPrefix(conf.getPrincipalTypeSerialNoDnSerialNumberPrefix());
        props.getSerialNoDn().setValueDelimiter(conf.getPrincipalTypeSerialNoDnValueDelimiter());
        props.getSerialNo().setPrincipalHexSNZeroPadding(conf.isPrincipalTypeSerialNoHexSNZeroPadding());
        props.getSerialNo().setPrincipalSNRadix(conf.getPrincipalTypeSerialNoSNRadix());
        if (conf.getLdap() != null) {
            X509LdapProperties ldapProps = new X509LdapProperties();
            ldapProps.setCertificateAttribute(conf.getLdap().getCertificateAttribute());
            this.fill((AbstractLdapSearchProperties)ldapProps, (AbstractLDAPConf)conf.getLdap());
            props.setLdap(ldapProps);
        }
        return AuthModulePropertySourceMapper.prefix("cas.authn.x509.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, SyncopeAuthModuleConf conf) {
        SyncopeClient syncopeClient = this.waRestClient.getSyncopeClient();
        if (syncopeClient == null) {
            LOG.warn("Application context is not ready to bootstrap WA configuration");
            return Map.of();
        }
        SyncopeAuthenticationProperties props = new SyncopeAuthenticationProperties();
        props.setName(authModuleTO.getKey());
        props.setState(AuthenticationHandlerStates.valueOf((String)authModuleTO.getState().name()));
        props.setDomain(conf.getDomain());
        props.setUrl(StringUtils.substringBefore((String)syncopeClient.getAddress(), (String)"/rest"));
        props.setAttributeMappings(authModuleTO.getItems().stream().collect(Collectors.toMap(Item::getIntAttrName, Item::getExtAttrName)));
        props.setCredentialCriteria(conf.getCredentialCriteria());
        return AuthModulePropertySourceMapper.prefix("cas.authn.syncope.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, AzureActiveDirectoryAuthModuleConf conf) {
        AzureActiveDirectoryAuthenticationProperties props = new AzureActiveDirectoryAuthenticationProperties();
        props.setName(authModuleTO.getKey());
        props.setOrder(authModuleTO.getOrder());
        props.setState(AuthenticationHandlerStates.valueOf((String)authModuleTO.getState().name()));
        props.setClientId(conf.getClientId());
        props.setLoginUrl(conf.getLoginUrl());
        props.setResource(conf.getResource());
        props.setCredentialCriteria(conf.getCredentialCriteria());
        return AuthModulePropertySourceMapper.prefix("cas.authn.azure-active-directory.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, OktaAuthModuleConf conf) {
        OktaAuthenticationProperties props = new OktaAuthenticationProperties();
        props.setName(authModuleTO.getKey());
        props.setOrder(authModuleTO.getOrder());
        props.setState(AuthenticationHandlerStates.valueOf((String)authModuleTO.getState().name()));
        props.setOrganizationUrl(conf.getOrganizationUrl());
        props.setCredentialCriteria(conf.getCredentialCriteria());
        return AuthModulePropertySourceMapper.prefix("cas.authn.okta.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, GoogleMfaAuthModuleConf conf) {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.setName(authModuleTO.getKey());
        props.setOrder(authModuleTO.getOrder());
        props.getCore().setIssuer(conf.getIssuer());
        props.getCore().setCodeDigits(conf.getCodeDigits());
        props.getCore().setLabel(conf.getLabel());
        props.getCore().setTimeStepSize(conf.getTimeStepSize());
        props.getCore().setWindowSize(conf.getWindowSize());
        if (conf.getLdap() != null) {
            LdapGoogleAuthenticatorMultifactorProperties ldapProps = new LdapGoogleAuthenticatorMultifactorProperties();
            ldapProps.setAccountAttributeName(conf.getLdap().getAccountAttributeName());
            this.fill((AbstractLdapSearchProperties)ldapProps, (AbstractLDAPConf)conf.getLdap());
            props.setLdap(ldapProps);
        }
        return AuthModulePropertySourceMapper.prefix("cas.authn.mfa.gauth.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, DuoMfaAuthModuleConf conf) {
        DuoSecurityMultifactorAuthenticationProperties props = new DuoSecurityMultifactorAuthenticationProperties();
        props.setName(authModuleTO.getKey());
        props.setOrder(authModuleTO.getOrder());
        props.setDuoApiHost(conf.getApiHost());
        props.setDuoApplicationKey(conf.getApplicationKey());
        props.setDuoIntegrationKey(conf.getIntegrationKey());
        props.setDuoSecretKey(conf.getSecretKey());
        return AuthModulePropertySourceMapper.prefix("cas.authn.mfa.duo.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, U2FAuthModuleConf conf) {
        U2FMultifactorAuthenticationProperties props = new U2FMultifactorAuthenticationProperties();
        props.setName(authModuleTO.getKey());
        props.setOrder(authModuleTO.getOrder());
        props.getCore().setExpireDevices(conf.getExpireDevices());
        props.getCore().setExpireDevicesTimeUnit(TimeUnit.valueOf(conf.getExpireDevicesTimeUnit()));
        props.getCore().setExpireRegistrations(conf.getExpireRegistrations());
        props.getCore().setExpireRegistrationsTimeUnit(TimeUnit.valueOf(conf.getExpireRegistrationsTimeUnit()));
        return AuthModulePropertySourceMapper.prefix("cas.authn.mfa.u2f.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, SimpleMfaAuthModuleConf conf) {
        CasSimpleMultifactorAuthenticationProperties props = new CasSimpleMultifactorAuthenticationProperties();
        props.setName(authModuleTO.getKey());
        props.setOrder(authModuleTO.getOrder());
        props.getMail().setAttributeName(conf.getEmailAttribute());
        props.getMail().setFrom(conf.getEmailFrom());
        props.getMail().setSubject(conf.getEmailSubject());
        props.getMail().setText(conf.getEmailText());
        props.getToken().getCore().setTokenLength(conf.getTokenLength());
        props.getToken().getCore().setTimeToKillInSeconds(conf.getTimeToKillInSeconds());
        if (StringUtils.isNotBlank((CharSequence)conf.getBypassGroovyScript())) {
            try {
                props.getBypass().getGroovy().setLocation((Resource)ResourceUtils.getResourceFrom((String)conf.getBypassGroovyScript()));
            }
            catch (Exception e) {
                LOG.error("Unable to load groovy script for bypass", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }
        return AuthModulePropertySourceMapper.prefix("cas.authn.mfa.simple.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AuthModuleTO authModuleTO, SpnegoAuthModuleConf conf) {
        SpnegoProperties props = new SpnegoProperties();
        props.setName(authModuleTO.getKey());
        props.setOrder(authModuleTO.getOrder());
        SpnegoAuthenticationProperties jcifsProperties = new SpnegoAuthenticationProperties();
        jcifsProperties.setJcifsServicePrincipal(conf.getJcifsServicePrincipal());
        props.getProperties().add(jcifsProperties);
        props.setMixedModeAuthentication(conf.isMixedModeAuthentication());
        props.setIpsToCheckPattern(conf.getIpsToCheckPattern());
        props.setSend401OnAuthenticationFailure(conf.isSend401OnAuthenticationFailure());
        props.setAlternativeRemoteHostAttribute(conf.getAlternativeRemoteHostAttribute());
        props.setDnsTimeout(conf.getDnsTimeout());
        props.setHostNameClientActionStrategy(conf.getHostNameClientActionStrategy());
        props.setHostNamePatternString(conf.getHostNamePatternString());
        props.setNtlm(conf.isNtlm());
        props.setNtlmAllowed(conf.isNtlmAllowed());
        props.setPoolSize(conf.getPoolSize());
        props.setPoolTimeout(conf.getPoolTimeout());
        props.setPrincipalWithDomainName(conf.isPrincipalWithDomainName());
        props.setSpnegoAttributeName(conf.getSpnegoAttributeName());
        props.setSupportedBrowsers(conf.getSupportedBrowsers());
        props.getSystem().setUseSubjectCredsOnly(conf.isUseSubjectCredsOnly());
        props.getSystem().setLoginConf(conf.getLoginConf());
        props.getSystem().setKerberosKdc(conf.getKerberosKdc());
        props.getSystem().setKerberosRealm(conf.getKerberosRealm());
        props.getSystem().setKerberosConf(conf.getKerberosConf());
        props.getSystem().setKerberosDebug(BooleanUtils.toStringTrueFalse((boolean)conf.isKerberosDebug()));
        if (conf.getLdap() != null) {
            SpnegoLdapProperties ldapProps = new SpnegoLdapProperties();
            this.fill((AbstractLdapSearchProperties)ldapProps, (AbstractLDAPConf)conf.getLdap());
            props.setLdap(ldapProps);
        } else {
            props.setLdap(null);
        }
        props.getPrincipal().setActiveAttributeRepositoryIds(conf.getAttributeRepoId());
        return AuthModulePropertySourceMapper.prefix("cas.authn.spnego.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }
}

