/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.task;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.core.flowable.task.FlowableServiceTask;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.flowable.engine.delegate.DelegateExecution;

public class PasswordReset
extends FlowableServiceTask {
    protected final UserDataBinder dataBinder;
    protected final UserDAO userDAO;

    public PasswordReset(UserDataBinder dataBinder, UserDAO userDAO) {
        this.dataBinder = dataBinder;
        this.userDAO = userDAO;
    }

    @Override
    protected void doExecute(DelegateExecution execution) {
        User user = (User)execution.getVariable("user", User.class);
        String token = (String)execution.getVariable("token", String.class);
        String password = (String)execution.getVariable("password", String.class);
        if (!user.checkToken(token)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Wrong token: " + token + " for " + user));
        }
        user.removeToken();
        UserUR req = (UserUR)new UserUR.Builder(user.getKey()).password((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().onSyncope(true).resources(this.userDAO.findAllResourceKeys(user.getKey())).value((Object)password)).build()).build();
        Pair propInfo = this.dataBinder.update(user, req);
        execution.setVariable("user", (Object)user);
        execution.setVariable("userUR", (Object)req);
        execution.setVariable("propByResource", propInfo.getLeft());
        execution.setVariable("propByLinkedAccount", propInfo.getRight());
    }
}

