/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.support;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.idm.api.Group;
import org.flowable.idm.engine.impl.GroupQueryImpl;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SyncopeGroupQueryImpl
extends GroupQueryImpl {
    private static final long serialVersionUID = -2595069675443343682L;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    private List<Group> result;

    private static Group fromSyncopeGroup(String name) {
        GroupEntityImpl group = new GroupEntityImpl();
        group.setId(name);
        return group;
    }

    private void execute() {
        if (this.id != null) {
            org.apache.syncope.core.persistence.api.entity.group.Group syncopeGroup = this.groupDAO.findByName(this.id);
            this.result = syncopeGroup == null ? List.of() : List.of(SyncopeGroupQueryImpl.fromSyncopeGroup(syncopeGroup.getName()));
        } else if (this.userId != null) {
            this.result = this.userDAO.findAllGroupNames(this.userDAO.findByUsername(this.userId)).stream().map(SyncopeGroupQueryImpl::fromSyncopeGroup).collect(Collectors.toList());
        }
    }

    @Transactional(readOnly=true)
    public long count() {
        this.checkQueryOk();
        this.resultType = ListQueryParameterObject.ResultType.COUNT;
        if (this.result == null) {
            this.execute();
        }
        return this.result.size();
    }

    @Transactional(readOnly=true)
    public List<Group> list() {
        this.checkQueryOk();
        this.resultType = ListQueryParameterObject.ResultType.LIST;
        if (this.result == null) {
            this.execute();
        }
        return this.result;
    }
}

