/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.storage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yubico.data.CredentialRegistration;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.webauthn.WebAuthnUtils;
import org.apereo.cas.webauthn.storage.BaseWebAuthnCredentialRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class JsonResourceWebAuthnCredentialRepository
extends BaseWebAuthnCredentialRepository
implements InitializingBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonResourceWebAuthnCredentialRepository.class);
    private final Resource location;

    public JsonResourceWebAuthnCredentialRepository(CasConfigurationProperties properties, Resource location, CipherExecutor<String, String> cipherExecutor) {
        super(properties, cipherExecutor);
        this.location = location;
    }

    public void afterPropertiesSet() {
        this.readFromJsonRepository();
    }

    @Override
    public Collection<CredentialRegistration> getRegistrationsByUsername(String username) {
        Map<String, Set<CredentialRegistration>> storage = this.readFromJsonRepository();
        return storage.containsKey(username.trim().toLowerCase()) ? (Collection)storage.get(username.trim().toLowerCase()) : new HashSet<CredentialRegistration>(0);
    }

    public Stream<CredentialRegistration> stream() {
        return this.readFromJsonRepository().values().stream().flatMap(Collection::stream);
    }

    @Override
    protected void update(String username, Collection<CredentialRegistration> givenRecords) {
        Map<String, Set<CredentialRegistration>> storage = this.readFromJsonRepository();
        List records = givenRecords.stream().map(record -> {
            if (record.getRegistrationTime() == null) {
                return record.withRegistrationTime(Instant.now(Clock.systemUTC()));
            }
            return record;
        }).collect(Collectors.toList());
        storage.put(username.trim().toLowerCase(), new LinkedHashSet(records));
        FunctionUtils.doUnchecked(u -> WebAuthnUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValue(this.location.getFile(), (Object)storage), (Object[])new Object[0]);
    }

    private Map<String, Set<CredentialRegistration>> readFromJsonRepository() {
        return (Map)FunctionUtils.doUnchecked(() -> {
            LOGGER.trace("Ensuring JSON repository file exists at [{}]", (Object)this.location.getFile());
            boolean result = this.location.getFile().createNewFile();
            if (result) {
                LOGGER.trace("Created JSON repository file at [{}]", (Object)this.location.getFile());
            }
            if (this.location.getFile().length() > 0L) {
                LOGGER.trace("Reading JSON repository file at [{}]", (Object)this.location.getFile());
                return new ConcurrentHashMap((Map)WebAuthnUtils.getObjectMapper().readValue(this.location.getFile(), (TypeReference)new TypeReference<Map<? extends String, ? extends Set<CredentialRegistration>>>(){}));
            }
            return new ConcurrentHashMap(0);
        });
    }
}

