/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j.authentication.handler.support;

import java.security.GeneralSecurityException;
import javax.security.auth.login.AccountNotFoundException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.integration.pac4j.authentication.handler.support.AbstractWrapperAuthenticationHandler;
import org.apereo.cas.services.ServicesManager;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.http.credentials.authenticator.test.SimpleTestUsernamePasswordAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

public class UsernamePasswordWrapperAuthenticationHandler
extends AbstractWrapperAuthenticationHandler<UsernamePasswordCredential, UsernamePasswordCredentials> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UsernamePasswordWrapperAuthenticationHandler.class);
    protected Authenticator authenticator = new SimpleTestUsernamePasswordAuthenticator();
    private PasswordEncoder passwordEncoder = NoOpPasswordEncoder.getInstance();
    private PrincipalNameTransformer principalNameTransformer = formUserId -> formUserId;

    public UsernamePasswordWrapperAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, SessionStore sessionStore) {
        super(name, servicesManager, principalFactory, order, sessionStore);
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return UsernamePasswordCredential.class.isAssignableFrom(clazz);
    }

    @Override
    protected UsernamePasswordCredentials convertToPac4jCredentials(UsernamePasswordCredential casCredential) throws GeneralSecurityException {
        LOGGER.debug("CAS credentials: [{}]", (Object)casCredential);
        String username = this.principalNameTransformer.transform(casCredential.getUsername());
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new AccountNotFoundException("Username is null.");
        }
        String password = this.passwordEncoder.encode((CharSequence)casCredential.toPassword());
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        LOGGER.debug("pac4j credentials: [{}]", (Object)credentials);
        return credentials;
    }

    @Override
    protected Authenticator getAuthenticator(Credential credential) {
        return this.authenticator;
    }

    @Override
    protected Class<UsernamePasswordCredential> getCasCredentialsType() {
        return UsernamePasswordCredential.class;
    }

    @Generated
    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Generated
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Generated
    public void setPrincipalNameTransformer(PrincipalNameTransformer principalNameTransformer) {
        this.principalNameTransformer = principalNameTransformer;
    }
}

